/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.sdo.ImmutableEventDatagram;

public class ConsumerState {
    private WorkingState workingState = WorkingState.FREE;
    private String eventId = null;
    private byte[] eventSource = null;
    private long startTime = -1L;

    public WorkingState getWorkingState() {
        return this.workingState;
    }

    public String getEventId() {
        return this.eventId;
    }

    public byte[] getEventSource() {
        return this.eventSource;
    }

    public long getStartTime() {
        return this.startTime;
    }

    synchronized void busy(ImmutableEventDatagram event) {
        this.workingState = WorkingState.BUSY;
        this.eventId = event.getEventId();
        this.eventSource = event.getEventSource();
        this.startTime = System.currentTimeMillis();
    }

    synchronized void free() {
        this.workingState = WorkingState.FREE;
        this.eventId = null;
        this.eventSource = null;
        this.startTime = -1L;
    }

    public static enum WorkingState {
        BUSY,
        FREE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

