/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent.worker;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.utils.Utils;

abstract class AbstractWorker
implements Runnable {
    private FabricThread thread;
    private volatile boolean isStarted = false;
    private volatile boolean isSleeping = false;
    protected boolean logExceptionOnStop = true;

    AbstractWorker(String name, String description, boolean isDaemon) {
        this.thread = isDaemon ? FabricThreadManager.getInstance().createDaemonThread(name, description, this) : FabricThreadManager.getInstance().createThread(name, description, this);
    }

    public synchronized void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            this.thread.start();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean force) {
        this.stop(100L, force);
    }

    public void stop(long timeout) {
        this.stop(timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long timeout, boolean force) {
        AbstractWorker abstractWorker = this;
        synchronized (abstractWorker) {
            if (this.isStarted) {
                this.isStarted = false;
                this.isSleeping = true;
                this.notifyAll();
            }
        }
        Utils.sleep(5L);
        abstractWorker = this;
        synchronized (abstractWorker) {
            if (timeout > 0L) {
                this.thread.join(timeout);
                Utils.sleep(5L);
            }
            if (this.thread.isRunning()) {
                this.thread.stop();
            }
        }
        if (force) {
            this.forceStop();
        }
    }

    private synchronized void forceStop() {
        if (this.thread.isRunning()) {
            new Thread(() -> {
                if (this.thread.isRunning()) {
                    Utils.sleep(500L);
                    if (this.thread.isRunning()) {
                        this.logExceptionOnStop = false;
                        this.thread.kill();
                    }
                }
            }).start();
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void run() {
        try {
            while (this.canWork()) {
                this.checkActivity();
                if (!this.doWait() || !this.isStarted) continue;
                this.doExecute();
            }
        }
        catch (InterruptedException exception) {
            Trace.logDebug(this, "Thread worker '" + this.getName() + "' interrupted.");
        }
        catch (Throwable exception) {
            if (this.logExceptionOnStop) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Thread worker '" + this.getName() + "' terminated.");
            }
            Trace.logDebug(this, "Thread worker '" + this.getName() + "' terminated.");
        }
        this.doStop();
    }

    public void join() {
        this.thread.join();
    }

    public void join(long timeout) {
        this.thread.join(timeout);
    }

    public synchronized void wakeUp() {
        if (this.hasTasks()) {
            this.doNotify();
        }
    }

    public synchronized void sleep() {
        this.isSleeping = true;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public FabricThread getThread() {
        return this.thread;
    }

    protected abstract void doExecute() throws FabricException, InterruptedException;

    protected abstract boolean hasTasks();

    protected void doStop() {
        if (this.isStarted) {
            this.isStarted = false;
            this.isSleeping = true;
        }
    }

    protected boolean canWork() {
        return this.isStarted;
    }

    protected synchronized void checkActivity() {
        if (!this.hasTasks()) {
            this.isSleeping = true;
        }
    }

    protected synchronized boolean doWait() throws InterruptedException {
        while (this.isSleeping) {
            this.wait();
        }
        return true;
    }

    protected synchronized void doNotify() {
        if (this.isSleeping) {
            this.isSleeping = false;
            this.notifyAll();
        }
    }

    protected String getName() {
        return this.thread.getName();
    }

    public String toString() {
        return this.thread.toString();
    }
}

