/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent.worker;

import com.streamscape.lib.concurrent.worker.AbstractWorker;
import com.streamscape.sef.FabricException;

abstract class AbstractMonitorWorker
extends AbstractWorker {
    private long timeout;
    private volatile boolean timeoutChanged = false;
    private volatile boolean waitingForTimeout = false;
    private volatile boolean movingToSleepInProgress = false;

    AbstractMonitorWorker(String name, String description, boolean isDaemon, long timeout) throws FabricException {
        super(name, description, isDaemon);
        this.setTimeout(timeout);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long timeout) throws FabricException {
        if (timeout <= 0L) {
            throw new FabricException("Timeout must be positive.");
        }
        if (timeout != this.timeout) {
            this.timeout = timeout;
            if (this.isStarted() && this.waitingForTimeout) {
                this.timeoutChanged = true;
                this.notifyAll();
            }
        }
    }

    @Override
    protected synchronized boolean doWait() throws InterruptedException {
        super.doWait();
        this.waitForTimeout();
        if (this.timeoutChanged) {
            this.timeoutChanged = false;
            return false;
        }
        return !this.isSleeping();
    }

    private synchronized void waitForTimeout() throws InterruptedException {
        long endTime = System.currentTimeMillis() + this.timeout;
        long remainingTime = this.timeout;
        while (!this.isSleeping() && remainingTime > 0L && !this.timeoutChanged) {
            this.waitingForTimeout = true;
            this.wait(remainingTime);
            remainingTime = endTime - System.currentTimeMillis();
            if (this.movingToSleepInProgress && remainingTime > 0L) {
                remainingTime = this.timeout;
            }
            this.movingToSleepInProgress = false;
        }
        this.waitingForTimeout = false;
    }

    @Override
    public synchronized void sleep() {
        if (!this.isSleeping()) {
            super.sleep();
            if (this.waitingForTimeout) {
                this.movingToSleepInProgress = true;
                this.notifyAll();
            }
        }
    }

    @Override
    protected boolean hasTasks() {
        return true;
    }

    protected boolean isWaitingForTimeout() {
        return this.waitingForTimeout;
    }
}

