/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent;

import com.streamscape.lib.concurrent.ExecutedTask;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class TaskExecutor<ReturnValue, Parameter> {
    public ReturnValue execute(ExecutedTask<ReturnValue, Parameter> task, Parameter parameter, long timeout) throws Throwable {
        if (timeout <= 0L) {
            return task.execute(parameter);
        }
        FabricThread thread = FabricThreadManager.getInstance().createThread(task.getType() + ":" + task.getName(), task.getDescription(), new RequestCallable<ReturnValue, Parameter>(task, parameter));
        try {
            thread.start();
            return (ReturnValue)thread.getResult(timeout);
        }
        catch (InterruptedException exception) {
            thread.stop();
            throw new InterruptedException("Execution interrupted.");
        }
        catch (CancellationException exception) {
            thread.stop();
            throw new InterruptedException("Execution cancelled.");
        }
        catch (ExecutionException exception) {
            thread.stop();
            throw exception.getCause();
        }
        catch (TimeoutException exception) {
            thread.stop();
            throw exception;
        }
    }

    private static class RequestCallable<ReturnValue, Parameter>
    implements Callable<ReturnValue> {
        ExecutedTask<ReturnValue, Parameter> task;
        Parameter parameter;

        RequestCallable(ExecutedTask<ReturnValue, Parameter> task, Parameter parameter) {
            this.task = task;
            this.parameter = parameter;
        }

        @Override
        public ReturnValue call() throws Exception {
            return this.task.execute(this.parameter);
        }
    }
}

