/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FabricThreadPool {
    private ThreadPoolType type;
    private String name;
    private String description;
    private boolean isDaemon;
    private ThreadPoolExecutor executor;
    private FabricThreadManager threadManager;
    private LongNumberAllocatorSimple threadNumberAllocator = new LongNumberAllocatorSimple();

    FabricThreadPool(ThreadPoolType type, String name, String description, int minThreadsNumber, int maxThreadsNumber, int maxQueueSize, boolean isDaemon, FabricThreadManager threadManager) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.isDaemon = isDaemon;
        this.threadManager = threadManager;
        this.initExecutor(minThreadsNumber, maxThreadsNumber, maxQueueSize);
    }

    public ThreadPoolType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public int getMaximumThreadsNumber() {
        return this.executor.getMaximumPoolSize();
    }

    public int getCurrentThreadsNumber() {
        return this.executor.getPoolSize();
    }

    public Future<?> addTask(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> addTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private void initExecutor(int minThreadsNumber, int maxThreadsNumber, int maxQueueSize) {
        switch (this.type) {
            case FIXED: {
                this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(maxThreadsNumber, this.createThreadFactory(this.isDaemon));
                break;
            }
            case DYNAMIC: {
                this.executor = new ThreadPoolExecutor(minThreadsNumber, maxThreadsNumber, 60L, TimeUnit.SECONDS, maxQueueSize <= 0 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(maxQueueSize), this.createThreadFactory(this.isDaemon));
                this.executor.allowCoreThreadTimeOut(true);
            }
        }
    }

    private ThreadFactory createThreadFactory(boolean isDaemon) {
        return isDaemon ? new DaemonThreadFactory() : new UserThreadFactory();
    }

    private String getThreadName() {
        return this.name + ":Pool-" + this.threadNumberAllocator.getNumber();
    }

    private class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable task) {
            FabricThread thread = new FabricThread(FabricThreadPool.this.getThreadName(), FabricThreadPool.this.description, task, true, FabricThreadPool.this.threadManager);
            return thread.getUnderlyingThread();
        }
    }

    private class UserThreadFactory
    implements ThreadFactory {
        private UserThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable task) {
            FabricThread thread = new FabricThread(FabricThreadPool.this.getThreadName(), FabricThreadPool.this.description, task, false, FabricThreadPool.this.threadManager);
            return thread.getUnderlyingThread();
        }
    }
}

