/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadPool;
import com.streamscape.lib.concurrent.ThreadPoolType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class FabricThreadManager {
    private static FabricThreadManager instance = null;
    private Map<Long, FabricThread> threads = new HashMap<Long, FabricThread>();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FabricThreadManager getInstance() {
        if (instance != null) return instance;
        Class<FabricThreadManager> clazz = FabricThreadManager.class;
        synchronized (FabricThreadManager.class) {
            if (instance != null) return instance;
            instance = new FabricThreadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected FabricThreadManager() {
        while (this.rootThreadGroup.getParent() != null) {
            this.rootThreadGroup = this.rootThreadGroup.getParent();
        }
    }

    public ThreadMXBean getThreadBean() {
        return this.threadBean;
    }

    public List<ThreadInfo> getThreadsInfo() {
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        long[] threadIds = this.threadBean.getAllThreadIds();
        for (int i = threadIds.length - 1; i >= 0; --i) {
            ThreadInfo info = this.threadBean.getThreadInfo(threadIds[i]);
            if (info == null) continue;
            result.add(info);
        }
        return result;
    }

    public FabricThread createThread(String name, String description, Runnable task) {
        return this.createThread(name, description, Executors.callable(task));
    }

    public <T> FabricThread<T> createThread(String name, String description, Callable<T> task) {
        return new FabricThread<T>(name, description, task, false, this);
    }

    public FabricThread createDaemonThread(String name, String description, Runnable task) {
        return this.createDaemonThread(name, description, Executors.callable(task));
    }

    public <T> FabricThread<T> createDaemonThread(String name, String description, Callable<T> task) {
        return new FabricThread<T>(name, description, task, true, this);
    }

    public FabricThreadPool createThreadPool(ThreadPoolType type, String name, String description, int threadsNumber) {
        return this.createThreadPool(type, name, description, threadsNumber, threadsNumber, -1);
    }

    public FabricThreadPool createThreadPool(ThreadPoolType type, String name, String description, int minThreadsNumber, int maxThreadsNumber, int maxQueueSize) {
        return new FabricThreadPool(type, name, description, minThreadsNumber, maxThreadsNumber, maxQueueSize, false, this);
    }

    public FabricThreadPool createDaemonThreadPool(ThreadPoolType type, String name, String description, int threadsNumber) {
        return this.createDaemonThreadPool(type, name, description, threadsNumber, threadsNumber, -1);
    }

    public FabricThreadPool createDaemonThreadPool(ThreadPoolType type, String name, String description, int minThreadsNumber, int maxThreadsNumber, int maxQueueSize) {
        return new FabricThreadPool(type, name, description, minThreadsNumber, maxThreadsNumber, maxQueueSize, true, this);
    }

    public FabricThread lookupThread(long threadId) {
        FabricThread result = this.doGetThread(threadId);
        if (result != null && !result.isRunning()) {
            result = null;
        }
        return result;
    }

    public FabricThread lookupThread(String name) {
        long[] threadIds = this.threadBean.getAllThreadIds();
        for (int i = threadIds.length - 1; i >= 0; --i) {
            ThreadInfo info = this.threadBean.getThreadInfo(threadIds[i]);
            if (info == null || !info.getThreadName().equals(name)) continue;
            return this.doGetThread(info.getThreadId());
        }
        return null;
    }

    synchronized FabricThread doGetThread(long threadId) {
        return this.threads.get(threadId);
    }

    public synchronized List<FabricThread> getThreads() {
        return this.threads.values().stream().filter(FabricThread::isRunning).collect(Collectors.toList());
    }

    public synchronized boolean killThread(long threadId) {
        FabricThread fabricThread = this.lookupThread(threadId);
        if (fabricThread != null) {
            fabricThread.kill();
            return true;
        }
        Thread thread = this.getThread(threadId);
        if (thread != null) {
            thread.stop();
            return true;
        }
        return false;
    }

    public synchronized boolean interruptThread(long threadId) {
        FabricThread fabricThread = this.lookupThread(threadId);
        if (fabricThread != null) {
            fabricThread.interrupt();
            return true;
        }
        Thread thread = this.getThread(threadId);
        if (thread != null) {
            thread.interrupt();
            return true;
        }
        return false;
    }

    synchronized void addThread(FabricThread thread) {
        if (thread != null) {
            this.threads.put(thread.getId(), thread);
        }
    }

    void removeThread(FabricThread thread) {
        if (thread != null) {
            this.threads.remove(thread.getId());
        }
    }

    Thread getThread(long threadId) {
        Thread[] allThreads = new Thread[this.threadBean.getThreadCount()];
        this.rootThreadGroup.enumerate(allThreads, true);
        for (Thread thread : allThreads) {
            if (thread.getId() != threadId) continue;
            return thread;
        }
        return null;
    }
}

