/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.concurrent;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import java.lang.management.ThreadInfo;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FabricThread<T> {
    private String name;
    private String description;
    private Callable<T> task;
    private Object userData;
    private FabricThreadManager threadManager;
    private Thread thread;
    private ExecutorService executorService;
    private Future<T> executionResult;
    private long startTime = -1L;

    FabricThread(String name, String description, Callable<T> task, boolean isDaemon, FabricThreadManager threadManager) {
        this.name = name;
        this.description = description;
        this.task = task;
        this.threadManager = threadManager;
        this.executorService = Executors.newSingleThreadExecutor(this.createThreadFactory(isDaemon));
    }

    FabricThread(String name, String description, Runnable task, boolean isDaemon, FabricThreadManager threadManager) {
        this.name = name;
        this.description = description;
        this.threadManager = threadManager;
        this.createThread(task, isDaemon);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.executionResult = this.executorService.submit(this.task);
            this.executorService.shutdown();
        }
    }

    public synchronized void stop() {
        if (this.thread != null && this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public synchronized void kill() {
        if (this.thread != null) {
            this.thread.stop();
            this.doStop();
        }
    }

    public void join() {
        try {
            if (this.executionResult != null) {
                this.executionResult.get();
            }
        }
        catch (CancellationException exception) {
            this.logError("Thread '" + this.getFullName() + "': execution cancelled.");
            this.doStop();
        }
        catch (InterruptedException exception) {
            this.logError("Thread '" + this.getFullName() + "': execution interrupted.");
            this.doStop();
        }
        catch (ExecutionException exception) {
            this.logException(exception.getCause() != null ? exception.getCause() : exception);
            this.logError("Thread '" + this.getFullName() + "': execution failed.");
        }
    }

    public void join(long timeout) {
        try {
            if (this.executionResult != null) {
                this.executionResult.get(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (CancellationException exception) {
            this.logError("Thread '" + this.getFullName() + "': execution cancelled.");
            this.doStop();
        }
        catch (InterruptedException exception) {
            this.logError("Thread '" + this.getFullName() + "': execution interrupted.");
            this.doStop();
        }
        catch (ExecutionException exception) {
            this.logException(exception.getCause() != null ? exception.getCause() : exception);
            this.logError("Thread '" + this.getFullName() + "': execution failed.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public T getResult() throws CancellationException, InterruptedException, ExecutionException {
        try {
            return this.executionResult != null ? (T)this.executionResult.get() : null;
        }
        catch (CancellationException exception) {
            this.doStop();
            throw exception;
        }
        catch (InterruptedException exception) {
            this.doStop();
            throw exception;
        }
    }

    public T getResult(long timeout) throws CancellationException, InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.executionResult != null ? (T)this.executionResult.get(timeout, TimeUnit.MILLISECONDS) : null;
        }
        catch (CancellationException exception) {
            this.doStop();
            throw exception;
        }
        catch (InterruptedException exception) {
            this.doStop();
            throw exception;
        }
    }

    public long getId() {
        return this.thread != null ? this.thread.getId() : -1L;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ThreadInfo getInfo() {
        return this.thread != null ? this.threadManager.getThreadBean().getThreadInfo(this.thread.getId()) : null;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public StackTraceElement[] getStackTrace() {
        return this.thread != null ? this.thread.getStackTrace() : null;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isDaemon() {
        return this.thread != null && this.thread.isDaemon();
    }

    public synchronized boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    public String toString() {
        return "Thread " + this.getFullName() + (this.isDaemon() ? " daemon" : "");
    }

    synchronized void doStart() {
        if (this.thread != null) {
            this.startTime = System.currentTimeMillis();
            this.threadManager.addThread(this);
        }
    }

    synchronized void doStop() {
        if (this.thread != null) {
            this.threadManager.removeThread(this);
            this.thread = null;
        }
    }

    private ThreadFactory createThreadFactory(boolean isDaemon) {
        return isDaemon ? new DaemonThreadFactory() : new UserThreadFactory();
    }

    void createThread(Runnable task, boolean isDaemon) {
        this.thread = new ThreadWrapper(task, this.name);
        this.thread.setDaemon(isDaemon);
    }

    String getFullName() {
        return "<" + this.getId() + ", " + this.getName() + ">";
    }

    Thread getUnderlyingThread() {
        return this.thread;
    }

    protected void logError(String message) {
        Trace.logError(this, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable task) {
            FabricThread.this.createThread(task, true);
            return FabricThread.this.thread;
        }
    }

    class UserThreadFactory
    implements ThreadFactory {
        UserThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable task) {
            FabricThread.this.createThread(task, false);
            return FabricThread.this.thread;
        }
    }

    class ThreadWrapper
    extends Thread {
        ThreadWrapper(Runnable task, String name) {
            super(task, name);
            ThreadWrapper.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }

        @Override
        public void run() {
            FabricThread.this.doStart();
            try {
                super.run();
            }
            catch (Throwable exception) {
                FabricThread.this.logException(exception);
                FabricThread.this.logError("Thread " + FabricThread.this.getFullName() + " terminated.");
            }
            FabricThread.this.doStop();
        }

        class ExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            ExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                FabricThread.this.logException(exception);
                FabricThread.this.logError("Thread " + FabricThread.this.getFullName() + " terminated by uncaught exception.");
                FabricThread.this.doStop();
            }
        }
    }
}

