/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphPrintVisitor;

public class TypeGraphXmlPrintVisitor
extends TypeGraphPrintVisitor {
    @Override
    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
        String typeName = this.getTypeName(node.getType());
        if (level == 0) {
            this.print("<" + typeName);
        } else {
            String name = node.getName().replaceAll("\\$", "_");
            this.print(this.getSpace(level) + "<" + name + " type=\"" + typeName + "\"");
        }
        if (node.getChildren().isEmpty()) {
            this.println("/>");
        } else {
            this.println(">");
        }
        return true;
    }

    @Override
    public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
        if (node.getChildren().isEmpty()) {
            return;
        }
        String name = node.getName();
        if (level == 0) {
            name = this.getTypeName(node.getType());
        }
        this.println(this.getSpace(level) + "</" + name + ">");
    }
}

