/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class TypeGraphPrintVisitor
implements TypeGraphVisitor {
    protected OutputStream out = System.out;

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
        String typeName = this.getTypeName(node.getType());
        if (level == 0) {
            this.println(typeName);
        } else {
            Object modifiers = Modifier.toString(node.getModifiers());
            if (((String)modifiers).length() > 0) {
                modifiers = (String)modifiers + " ";
            }
            this.println(this.getSpace(level) + (String)modifiers + typeName + " " + node.getName());
        }
        return true;
    }

    @Override
    public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
    }

    protected void print(String string) throws TypeAnalyzerException {
        try {
            this.out.write(string.getBytes());
        }
        catch (IOException error) {
            throw new TypeAnalyzerException(error);
        }
    }

    protected void println(String string) throws TypeAnalyzerException {
        this.print(string);
        this.print("\n");
    }

    protected String getSpace(int level) {
        Object space = "";
        for (int i = 0; i < level; ++i) {
            space = (String)space + "  ";
        }
        return space;
    }

    protected String getTypeName(Type type) {
        if (TypeFactory.getCurrentSemanticTypeLookupContext() != null) {
            Class clazz = null;
            if (type instanceof Class) {
                clazz = (Class)type;
            } else {
                if (type instanceof TypeAnalyzer.ParameterizedTypeImplicitMap) {
                    return "implicitmap";
                }
                if (type instanceof ParameterizedType) {
                    clazz = (Class)((ParameterizedType)type).getRawType();
                } else if (type instanceof GenericArrayType && (type = ((GenericArrayType)type).getGenericComponentType()) instanceof Class) {
                    clazz = (Class)type;
                }
            }
            if (clazz != null) {
                return TypeFactory.resolveTypeName(clazz, TypeFactory.getCurrentSemanticTypeLookupContext());
            }
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    protected boolean isLastChild(TypeGraph node) {
        ArrayList<TypeGraph> siblings = node.getParent().getChildren();
        return node == siblings.get(siblings.size() - 1);
    }
}

