/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphPrintVisitor;
import java.util.Iterator;
import java.util.Stack;

public class TypeGraphPrettyPrintVisitor
extends TypeGraphPrintVisitor {
    protected Stack<Boolean> isLastChildStack = new Stack();

    @Override
    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
        String nodeString = node.getName() + " (" + this.getTypeName(node.getType()) + ")";
        if (level == 0) {
            this.println(nodeString);
        } else {
            Object space = "";
            Iterator iterator = this.isLastChildStack.iterator();
            while (iterator.hasNext()) {
                boolean isLastChild = (Boolean)iterator.next();
                if (isLastChild) {
                    space = (String)space + "    ";
                    continue;
                }
                space = (String)space + "|   ";
            }
            this.println((String)space + "|\n" + (String)space + "+-- " + nodeString);
            this.isLastChildStack.push(this.isLastChild(node));
        }
        return true;
    }

    @Override
    public void afterChildrenVisit(TypeGraph node, int level) {
        if (level > 0) {
            this.isLastChildStack.pop();
        }
    }
}

