/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphPrintVisitor;
import com.streamscape.omf.json.JSONSerializerFactory;
import java.io.IOException;

public class TypeGraphJsonPrintVisitor
extends TypeGraphPrintVisitor {
    private JsonGenerator generator;

    @Override
    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
        try {
            if (this.generator == null) {
                this.generator = JSONSerializerFactory.createDefaultEmptyMapper().getFactory().createGenerator(this.out);
                this.generator.useDefaultPrettyPrinter();
            }
            this.generator.writeStartObject();
            this.generator.writeStringField("fieldName", node.getName());
            this.generator.writeStringField("typeName", this.getTypeName(node.getType()));
            if (!node.getChildren().isEmpty()) {
                this.generator.writeFieldName("fields");
                this.generator.writeStartArray();
            }
        }
        catch (IOException exception) {
            throw new TypeAnalyzerException(exception);
        }
        return true;
    }

    @Override
    public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
        try {
            if (!node.getChildren().isEmpty()) {
                this.generator.writeEndArray();
            }
            this.generator.writeEndObject();
            if (level == 0) {
                this.generator.flush();
                this.generator.close();
                this.generator = null;
            }
        }
        catch (IOException exception) {
            throw new TypeAnalyzerException(exception);
        }
    }
}

