/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphPrintVisitor;

public class TypeGraphJsonExtJSPrintVisitor
extends TypeGraphPrintVisitor {
    @Override
    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
        String typeName = this.getTypeName(node.getType());
        String space = this.getSpace(level);
        if (level == 0) {
            this.println("[");
        } else {
            this.print(space + "{\n" + space + "  text:'" + node.getName() + " (" + typeName + ")'");
            if (node.getChildren().isEmpty()) {
                this.println(",\n" + space + "  leaf:true");
            } else {
                this.println(",\n" + space + "  children:\n" + space + "  [");
            }
        }
        return true;
    }

    @Override
    public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
        if (level == 0) {
            this.println("]");
        } else {
            String space = this.getSpace(level);
            if (!node.getChildren().isEmpty()) {
                this.println(space + "  ]");
            }
            if (this.isLastChild(node)) {
                this.println(space + "}");
            } else {
                this.println(space + "},");
            }
        }
    }
}

