/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class TypeGraph {
    protected String name;
    protected String alias;
    protected Type type;
    protected int modifiers;
    protected TypeGraph parent;
    protected ArrayList<TypeGraph> children;

    public TypeGraph(String fieldName, Type fieldType) {
        this.name = fieldName;
        this.type = fieldType;
        this.modifiers = 0;
        this.children = new ArrayList();
    }

    public TypeGraph(String fieldName, Type fieldType, int fieldModifiers, TypeGraph parentNode) {
        this(fieldName, fieldType);
        this.setModifiers(fieldModifiers);
        this.setParent(parentNode);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public TypeGraph getParent() {
        return this.parent;
    }

    public ArrayList<TypeGraph> getChildren() {
        return this.children;
    }

    public TypeGraph getChild(String childName) {
        return this.children.stream().filter(child -> child.getName().equals(childName)).findFirst().orElse(null);
    }

    public TypeGraph getNode(String path) {
        path = TypeAnalyzer.preprocessPath(path);
        return this.getNodeByPath(path);
    }

    public String getPath() {
        Object path = this.name;
        for (TypeGraph node = this.parent; node != null; node = node.getParent()) {
            path = node.getName() + "/" + (String)path;
        }
        return path;
    }

    public void setName(String fieldName) {
        this.name = fieldName;
    }

    public void setType(Type fieldType) {
        this.type = fieldType;
    }

    public void setParent(TypeGraph parentNode) {
        this.parent = parentNode;
    }

    public void setModifiers(int fieldModifiers) {
        this.modifiers = fieldModifiers;
    }

    public void addChild(TypeGraph child) {
        this.children.add(child);
        child.setParent(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void traverse(TypeGraphVisitor visitor) throws TypeAnalyzerException {
        this.traverse(visitor, 0);
    }

    public void merge(String path, TypeGraph graphToMerge) {
        TypeGraph node = this.getNode(path);
        if (node != null) {
            node.setType(graphToMerge.getType());
            for (TypeGraph child : graphToMerge.getChildren()) {
                node.addChild(child);
            }
        }
    }

    protected TypeGraph getNodeByPath(String path) {
        if (path.length() == 0) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.getChild(path);
        }
        String childName = path.substring(0, index);
        path = path.substring(index + 1);
        return this.getChild(childName).getNodeByPath(path);
    }

    protected void traverse(TypeGraphVisitor visitor, int level) throws TypeAnalyzerException {
        if (!visitor.visit(this, level)) {
            return;
        }
        for (TypeGraph child : this.children) {
            child.traverse(visitor, level + 1);
        }
        visitor.afterChildrenVisit(this, level);
    }
}

