/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.streamscape.Trace;
import com.streamscape.lib.analyzer.SerializableFieldsOnlyStrategy;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphCreationStrategy;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.json.jackson.JacksonUtils;
import com.streamscape.runtime.mf.operation.edl.annotations.ImplicitMap;
import com.streamscape.runtime.mf.operation.edl.annotations.Key;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType1;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType2;
import com.streamscape.runtime.mf.operation.edl.annotations.Value;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class TypeAnalyzer {
    protected TypeGraphCreationStrategy strategy = new SerializableFieldsOnlyStrategy();
    protected SemanticTypeCache typeCache;
    protected ClassLoader classLoader;
    protected HashMap<String, TypeGraph> parentTypes;
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String ELEMENT = "element";

    public void setStrategy(TypeGraphCreationStrategy graphStrategy) {
        this.strategy = graphStrategy;
    }

    public TypeGraphCreationStrategy getStrategy() {
        return this.strategy;
    }

    public void setSemanticTypeCache(SemanticTypeCache cache) {
        this.typeCache = cache;
    }

    public SemanticTypeCache getSemanticTypeCache() {
        return this.typeCache;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TypeGraph getTypeGraph(String path) throws TypeAnalyzerException {
        Type fieldType = this.getFieldType(path);
        return this.getTypeGraph(fieldType);
    }

    public TypeGraph getTypeGraph(Type type, String path) throws TypeAnalyzerException {
        Type fieldType = this.getFieldType(type, path);
        return this.getTypeGraph(fieldType);
    }

    public TypeGraph getTypeGraph(Type type) throws TypeAnalyzerException {
        this.parentTypes = new HashMap();
        return this.getTypeGraph(new TypeGraph("/", type));
    }

    public String getFieldTypeAsString(String path) throws TypeAnalyzerException {
        return this.getFieldClass(path).getName();
    }

    public Class<?> getFieldClass(String path) throws TypeAnalyzerException {
        Type fieldType = this.getFieldType(path);
        return TypeAnalyzer.getRawClass(fieldType);
    }

    public Type getFieldType(String path) throws TypeAnalyzerException {
        if (!((String)path).startsWith("//{")) {
            throw new TypeAnalyzerException("Path must start with semantic type: '//{<type>}'.");
        }
        int index = ((String)path).indexOf(125);
        String typeName = ((String)path).substring(3, index);
        if (((String)(path = ((String)path).substring(index + 1))).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        path = "//" + (String)path;
        Class<?> cls = this.getClassBySemanticType(typeName);
        return this.getFieldType(cls, (String)path);
    }

    public String getFieldTypeAsString(Type type, String path) throws TypeAnalyzerException {
        return this.getFieldClass(type, path).getName();
    }

    public Class<?> getFieldClass(Type type, String path) throws TypeAnalyzerException {
        Type fieldType = this.getFieldType(type, path);
        return TypeAnalyzer.getRawClass(fieldType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type getFieldType(Type type, String path) throws TypeAnalyzerException {
        if (!path.startsWith("//")) {
            throw new TypeAnalyzerException("Path must start with root identifier '//'.");
        }
        path = TypeAnalyzer.preprocessPath(path);
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        Object fieldType = type;
        try {
            while (tokenizer.hasMoreTokens() && fieldType != null) {
                String fieldName = tokenizer.nextToken();
                String fieldCast = null;
                int castStart = fieldName.indexOf(123);
                if (castStart != -1) {
                    int castEnd = fieldName.indexOf(125, castStart);
                    if (castEnd < castStart) {
                        throw new TypeAnalyzerException("Bad class cast expression: " + fieldName);
                    }
                    fieldCast = fieldName.substring(castStart + 1, castEnd);
                    fieldName = fieldName.substring(0, castStart);
                }
                Class<?> fieldClass = null;
                boolean isCommonType = false;
                if (fieldType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)fieldType;
                    fieldClass = (Class<?>)parameterizedType.getRawType();
                    if (Map.class.isAssignableFrom(fieldClass)) {
                        if (fieldName.equals(KEY)) {
                            fieldType = parameterizedType.getActualTypeArguments()[0];
                        } else {
                            if (!fieldName.equals(VALUE) && !fieldName.equals(ELEMENT)) throw new TypeAnalyzerException("Wrong syntax for map item: " + fieldName);
                            fieldType = parameterizedType.getActualTypeArguments()[1];
                        }
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array item: " + fieldName);
                        }
                        fieldType = parameterizedType.getActualTypeArguments()[0];
                    } else {
                        isCommonType = true;
                    }
                }
                if (fieldClass == null || isCommonType) {
                    if (fieldClass == null) {
                        fieldClass = fieldType;
                    }
                    if (fieldClass.isArray()) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array field: " + fieldName);
                        }
                        fieldType = fieldClass.getComponentType();
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array item: " + fieldName);
                        }
                        fieldType = Object.class;
                    } else if (Map.class.isAssignableFrom(fieldClass)) {
                        if (fieldName.equals(KEY)) {
                            fieldType = Object.class;
                        } else {
                            if (!fieldName.equals(VALUE) && !fieldName.equals(ELEMENT)) throw new TypeAnalyzerException("Wrong syntax for map item: " + fieldName);
                            fieldType = Object.class;
                        }
                    } else {
                        Field field = null;
                        while (fieldClass != null) {
                            try {
                                field = fieldClass.getDeclaredField(fieldName);
                                break;
                            }
                            catch (NoSuchFieldException notThisClass) {
                                fieldClass = fieldClass.getSuperclass();
                            }
                        }
                        if (field == null) throw new TypeAnalyzerException("Field '" + fieldName + "' not found in the class '" + TypeAnalyzer.getRawClass(type).getName() + "'.");
                        fieldType = this.applyAnnotations(field, field.getType(), field.getGenericType(), 0);
                    }
                }
                if (fieldCast == null) continue;
                Class<?> classToCast = this.getClassBySemanticType(fieldCast);
                fieldClass = TypeAnalyzer.getRawClass(fieldType);
                if (!fieldClass.isAssignableFrom(classToCast)) {
                    throw new TypeAnalyzerException("Can't cast " + String.valueOf(fieldClass) + " to " + String.valueOf(classToCast));
                }
                fieldType = classToCast;
            }
            return fieldType;
        }
        catch (Exception exception) {
            if (!(exception instanceof TypeAnalyzerException)) throw new TypeAnalyzerException(exception);
            throw (TypeAnalyzerException)exception;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field getField(Type type, String path) throws TypeAnalyzerException {
        if (!path.startsWith("//")) {
            throw new TypeAnalyzerException("Path must start with root identifier '//'.");
        }
        path = TypeAnalyzer.preprocessPath(path);
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        Class<?> clazz = type;
        try {
            void var4_5;
            while (tokenizer.hasMoreTokens() && var4_5 != null) {
                String fieldName = tokenizer.nextToken();
                Class fieldClass = null;
                boolean isCommonType = false;
                if (var4_5 instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)var4_5;
                    fieldClass = (Class)parameterizedType.getRawType();
                    if (Map.class.isAssignableFrom(fieldClass)) {
                        if (fieldName.equals(KEY)) {
                            Type type2 = parameterizedType.getActualTypeArguments()[0];
                        } else {
                            if (!fieldName.equals(VALUE) && !fieldName.equals(ELEMENT)) throw new TypeAnalyzerException("Wrong syntax for map item: " + fieldName);
                            Type type3 = parameterizedType.getActualTypeArguments()[1];
                        }
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array item: " + fieldName);
                        }
                        Type type4 = parameterizedType.getActualTypeArguments()[0];
                    } else {
                        isCommonType = true;
                    }
                }
                if (fieldClass != null && !isCommonType) continue;
                if (fieldClass == null) {
                    fieldClass = (Class)var4_5;
                }
                if (fieldClass.isArray()) {
                    if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                        throw new TypeAnalyzerException("Wrong syntax for array field: " + fieldName);
                    }
                    Class<?> clazz2 = fieldClass.getComponentType();
                    continue;
                }
                Field field = null;
                while (fieldClass != null) {
                    try {
                        field = fieldClass.getDeclaredField(fieldName);
                        break;
                    }
                    catch (NoSuchFieldException notThisClass) {
                        fieldClass = fieldClass.getSuperclass();
                    }
                }
                if (field == null) throw new TypeAnalyzerException("Field '" + fieldName + "' not found in the class '" + TypeAnalyzer.getRawClass(type).getName() + "'.");
                return field;
            }
            return null;
        }
        catch (Exception exception) {
            if (!(exception instanceof TypeAnalyzerException)) throw new TypeAnalyzerException(exception);
            throw (TypeAnalyzerException)exception;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<?> getFieldClass(String typeName, String path) throws TypeAnalyzerException {
        if (!path.startsWith("//")) {
            throw new TypeAnalyzerException("Path must start with root identifier '//'.");
        }
        path = TypeAnalyzer.preprocessPath(path);
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        Class<?> clazz = this.getClassBySemanticType(typeName);
        try {
            void var4_5;
            while (tokenizer.hasMoreTokens() && var4_5 != null) {
                String fieldName = tokenizer.nextToken();
                String fieldCast = null;
                int castStart = fieldName.indexOf(123);
                if (castStart != -1) {
                    int castEnd = fieldName.indexOf(125, castStart);
                    if (castEnd < castStart) {
                        throw new TypeAnalyzerException("Bad class cast expression: " + fieldName);
                    }
                    fieldCast = fieldName.substring(castStart + 1, castEnd);
                    fieldName = fieldName.substring(0, castStart);
                }
                Class fieldClass = null;
                boolean isCommonType = false;
                if (var4_5 instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)var4_5;
                    fieldClass = (Class)parameterizedType.getRawType();
                    if (Map.class.isAssignableFrom(fieldClass)) {
                        if (fieldName.equals(KEY)) {
                            Type type = parameterizedType.getActualTypeArguments()[0];
                        } else {
                            if (!fieldName.equals(VALUE)) throw new TypeAnalyzerException("Wrong syntax for map item: " + fieldName);
                            Type type = parameterizedType.getActualTypeArguments()[1];
                        }
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array item: " + fieldName);
                        }
                        Type type = parameterizedType.getActualTypeArguments()[0];
                    } else {
                        isCommonType = true;
                    }
                }
                if (fieldClass == null || isCommonType) {
                    if (fieldClass == null) {
                        fieldClass = (Class)var4_5;
                    }
                    if (fieldClass.isArray()) {
                        if (!fieldName.equals(ELEMENT) && !fieldName.equals(VALUE)) {
                            throw new TypeAnalyzerException("Wrong syntax for array field: " + fieldName);
                        }
                        Class<?> clazz2 = fieldClass.getComponentType();
                    } else {
                        Field field = null;
                        while (fieldClass != null) {
                            try {
                                field = fieldClass.getDeclaredField(fieldName);
                                break;
                            }
                            catch (NoSuchFieldException notThisClass) {
                                fieldClass = fieldClass.getSuperclass();
                            }
                        }
                        if (field == null) throw new TypeAnalyzerException("Field '" + fieldName + "' not found in semantic type '" + typeName + "'.");
                        Type type = field.getGenericType();
                    }
                }
                if (fieldCast == null) continue;
                Class<?> classToCast = this.getClassBySemanticType(fieldCast);
                fieldClass = TypeAnalyzer.getRawClass((Type)var4_5);
                if (!fieldClass.isAssignableFrom(classToCast)) {
                    throw new TypeAnalyzerException("Can't cast " + String.valueOf(fieldClass) + " to " + String.valueOf(classToCast));
                }
                Class<?> clazz3 = classToCast;
            }
            return TypeAnalyzer.getRawClass((Type)var4_5);
        }
        catch (Exception exception) {
            if (!(exception instanceof TypeAnalyzerException)) throw new TypeAnalyzerException(exception);
            throw (TypeAnalyzerException)exception;
        }
    }

    public boolean assertPath(String path) {
        try {
            this.getFieldClass(path);
            return true;
        }
        catch (TypeAnalyzerException wrongPath) {
            return false;
        }
    }

    public boolean assertPath(Type type, String path) {
        try {
            this.getFieldClass(type, path);
            return true;
        }
        catch (TypeAnalyzerException wrongPath) {
            return false;
        }
    }

    public Class<?> getClassBySemanticType(String semanticType) throws TypeAnalyzerException {
        Object className = null;
        if (this.typeCache != null) {
            className = this.typeCache.resolveSemanticType(semanticType);
        }
        if (className == null) {
            if (semanticType.endsWith("[]") && !semanticType.equals(byte[].class.getName())) {
                className = this.typeCache.resolveSemanticType(semanticType.substring(0, semanticType.length() - 2));
                if (className == null && semanticType.indexOf(46) != -1) {
                    className = semanticType.substring(0, semanticType.length() - 2);
                }
                if (className != null) {
                    className = "[L" + (String)className + ";";
                }
            } else if (semanticType.indexOf(46) != -1 || semanticType.equals(byte[].class.getName())) {
                className = semanticType;
            }
            if (className == null) {
                throw new TypeAnalyzerException("Resolving semantic type '" + semanticType + "' failed.");
            }
        }
        try {
            return ClassUtils.loadClass((String)className, this.classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw new TypeAnalyzerException("Loading class '" + (String)className + "' failed.", exception);
        }
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeAnalyzer.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return TypeAnalyzer.getRawClass(((GenericArrayType)type).getGenericComponentType());
        }
        return null;
    }

    TypeAnalyzer(ClassLoader loader, SemanticTypeCache cache, TypeGraphCreationStrategy graphStrategy) {
        this.classLoader = loader;
        this.typeCache = cache;
        this.strategy = graphStrategy;
    }

    static String preprocessPath(String path) {
        if (path.startsWith("//")) {
            path = path.substring(2);
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.replaceAll("\\[[0-9]*\\]", "/value");
        path = path.replaceAll("\\[key\\s*=[^\\]]*\\]", "/value");
        path = path.replaceAll("\\[value\\s*=[^\\]]*\\]", "/key");
        return path;
    }

    protected TypeGraph getTypeGraph(TypeGraph graph) throws TypeAnalyzerException {
        if ((graph = this.strategy.getGraphNode(graph)) == null) {
            return null;
        }
        if (this.strategy.shouldSkipChildren(graph)) {
            return graph;
        }
        String typeString = graph.getType().toString();
        if (this.parentTypes.get(typeString) != null) {
            return graph;
        }
        this.parentTypes.put(typeString, graph);
        this._getTypeGraph(graph);
        this.parentTypes.remove(typeString);
        return graph;
    }

    protected TypeGraph _getTypeGraph(TypeGraph graph) throws TypeAnalyzerException {
        Type type = graph.getType();
        Class<?> rawClass = null;
        if ((type = this.convertParametrizedClasses(type)) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            rawClass = (Class<?>)parameterizedType.getRawType();
            if (Map.class.isAssignableFrom(rawClass)) {
                Type keyType = parameterizedType.getActualTypeArguments()[0];
                Type valueType = parameterizedType.getActualTypeArguments()[1];
                this.createChildGraph(graph, KEY, keyType, 0);
                this.createChildGraph(graph, valueType instanceof Class && JacksonUtils.isPrimitive((Class)valueType) ? VALUE : ELEMENT, valueType, 0);
                return graph;
            }
            if (Collection.class.isAssignableFrom(rawClass)) {
                Type valueType = parameterizedType.getActualTypeArguments()[0];
                this.createChildGraph(graph, valueType instanceof Class && JacksonUtils.isPrimitive((Class)valueType) ? VALUE : ELEMENT, valueType, 0);
                return graph;
            }
        } else {
            if (type instanceof Class && ((Class)type).isArray()) {
                rawClass = (Class)type;
                while (rawClass.isArray()) {
                    rawClass = rawClass.getComponentType();
                }
                this.createChildGraph(graph, rawClass instanceof Class && JacksonUtils.isPrimitive(rawClass) ? VALUE : ELEMENT, rawClass, 0);
                return graph;
            }
            if (type instanceof TypeVariable || type instanceof WildcardType || type instanceof GenericArrayType) {
                return graph;
            }
        }
        if (rawClass == null) {
            rawClass = (Class<?>)type;
        }
        if (rawClass.isArray()) {
            while (rawClass.isArray()) {
                rawClass = rawClass.getComponentType();
            }
            this.createChildGraph(graph, rawClass.getSimpleName(), rawClass, 0);
            return graph;
        }
        TypeGraph parent = graph;
        if (type instanceof ParameterizedTypeImplicitMap) {
            TypeGraph child = new TypeGraph(ELEMENT, rawClass);
            graph.addChild(child);
            graph = child;
        }
        if (this.strategy.shouldIncludeParentTypes()) {
            this.createChildrenWithParentTypes(rawClass, graph);
        } else {
            this.createChildrenWithoutParentTypes(rawClass, graph);
        }
        return parent;
    }

    private Type convertParametrizedClasses(final Type type) {
        if (type instanceof Class) {
            if (Map.class.isAssignableFrom((Class)type)) {
                return new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return new Type[]{Object.class, Object.class};
                    }

                    @Override
                    public Type getRawType() {
                        return type;
                    }

                    @Override
                    public Type getOwnerType() {
                        return type;
                    }
                };
            }
            if (Collection.class.isAssignableFrom((Class)type)) {
                return new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return new Type[]{Object.class};
                    }

                    @Override
                    public Type getRawType() {
                        return type;
                    }

                    @Override
                    public Type getOwnerType() {
                        return type;
                    }
                };
            }
        }
        return type;
    }

    protected void createChildrenWithoutParentTypes(Class<?> cls, TypeGraph graph) throws TypeAnalyzerException {
        if (cls != null) {
            this.createChildrenWithoutParentTypes(cls.getSuperclass(), graph);
            this.processFields(cls, graph);
        }
    }

    protected void createChildrenWithParentTypes(Class<?> cls, TypeGraph graph) throws TypeAnalyzerException {
        if (cls != null) {
            this.createChildGraph(graph, "<Type>", cls.getSuperclass(), 0);
            this.processFields(cls, graph);
        }
    }

    private void processFields(Class<?> cls, TypeGraph graph) throws TypeAnalyzerException {
        for (Field field : cls.getDeclaredFields()) {
            Type type = this.applyAnnotations(field, field.getType(), field.getGenericType(), 0);
            JsonProperty aliasAnno = field.getAnnotation(JsonProperty.class);
            String alias = null;
            if (aliasAnno != null) {
                alias = aliasAnno.value();
            }
            this.createChildGraph(graph, field.getName(), type, field.getModifiers(), alias);
        }
    }

    protected TypeGraph createChildGraph(TypeGraph parent, String name, Type type, int modifiers, String alias) throws TypeAnalyzerException {
        if (type == null || type == Object.class && name.equalsIgnoreCase("<Type>")) {
            return parent;
        }
        TypeGraph child = new TypeGraph(name, type, modifiers, parent);
        if ((child = this.getTypeGraph(child)) != null) {
            child.setAlias(alias);
            parent.addChild(child);
        }
        return child;
    }

    protected TypeGraph createChildGraph(TypeGraph parent, String name, Type type, int modifiers) throws TypeAnalyzerException {
        return this.createChildGraph(parent, name, type, modifiers, null);
    }

    private Type applyAnnotations(Field field, Class fieldType, Type genericType, int level) throws TypeAnalyzerException {
        Annotation annotation;
        String typeName = null;
        String type1Name = null;
        if (level == 0) {
            annotation = field.getAnnotation(SemanticType.class);
            if (annotation != null) {
                typeName = annotation.type();
                type1Name = annotation.type1();
            }
        } else if (level == 1) {
            annotation = field.getAnnotation(SemanticType1.class);
            if (annotation != null) {
                typeName = annotation.type();
                type1Name = annotation.type1();
            }
        } else if (level == 2 && (annotation = field.getAnnotation(SemanticType2.class)) != null) {
            typeName = annotation.type();
            type1Name = annotation.type1();
        }
        if (typeName != null) {
            try {
                String type1Class;
                String typeClass = this.typeCache.resolveSemanticType(typeName);
                if (typeClass == null) {
                    typeClass = typeName;
                }
                String string = type1Class = type1Name != null && type1Name.length() > 0 ? this.typeCache.resolveSemanticType(type1Name) : null;
                if (type1Class == null) {
                    type1Class = type1Name;
                }
                if (Collection.class.isAssignableFrom(fieldType) && level == 0 && field.getAnnotation(ImplicitMap.class) != null) {
                    Class implicitMapClazz = ClassUtils.loadClass(typeClass, this.classLoader);
                    Class keyType = Object.class;
                    Class valueType = Object.class;
                    for (Field implicitMapField : implicitMapClazz.getDeclaredFields()) {
                        if (implicitMapField.getAnnotation(Key.class) != null) {
                            keyType = implicitMapField.getType();
                            continue;
                        }
                        if (implicitMapField.getAnnotation(Value.class) != null) {
                            valueType = implicitMapField.getType();
                            continue;
                        }
                        Trace.logError(this, "Unexpected field '" + implicitMapField.getName() + "' in ImplicitMap.");
                    }
                    return ParameterizedTypeImplicitMap.make(implicitMapClazz, new Type[]{keyType, valueType}, implicitMapClazz);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    Class valueClazz = ClassUtils.loadClass(typeClass, this.classLoader);
                    return ParameterizedTypeImpl.make(fieldType, new Type[]{this.applyAnnotations(field, valueClazz, valueClazz, level + 1)}, fieldType);
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    Class keyClazz = ClassUtils.loadClass(typeClass, this.classLoader);
                    Class valueClazz = ClassUtils.loadClass(type1Class, this.classLoader);
                    return ParameterizedTypeImpl.make(fieldType, new Type[]{keyClazz, this.applyAnnotations(field, valueClazz, valueClazz, level + 1)}, fieldType);
                }
            }
            catch (ClassNotFoundException exception) {
                throw new TypeAnalyzerException("Loading class '" + exception.getMessage() + "' failed.", exception);
            }
        }
        return genericType;
    }

    public static class ParameterizedTypeImplicitMap
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Class<?> rawType;
        private final Type ownerType;

        private ParameterizedTypeImplicitMap(Class<?> var1, Type[] var2, Type var3) {
            this.actualTypeArguments = var2;
            this.rawType = var1;
            this.ownerType = var3 != null ? var3 : var1.getDeclaringClass();
        }

        public static ParameterizedTypeImplicitMap make(Class<?> var0, Type[] var1, Type var2) {
            return new ParameterizedTypeImplicitMap(var0, var1, var2);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.actualTypeArguments.clone();
        }

        @Override
        public Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object var1) {
            if (var1 instanceof ParameterizedType) {
                ParameterizedType var2 = (ParameterizedType)var1;
                if (this == var2) {
                    return true;
                }
                Type var3 = var2.getOwnerType();
                Type var4 = var2.getRawType();
                return Objects.equals(this.ownerType, var3) && Objects.equals(this.rawType, var4) && Arrays.equals(this.actualTypeArguments, var2.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder var1 = new StringBuilder();
            if (this.ownerType != null) {
                if (this.ownerType instanceof Class) {
                    var1.append(((Class)this.ownerType).getName());
                } else {
                    var1.append(this.ownerType.toString());
                }
                var1.append("$");
                if (this.ownerType instanceof ParameterizedTypeImplicitMap) {
                    var1.append(this.rawType.getName().replace(((ParameterizedTypeImplicitMap)this.ownerType).rawType.getName() + "$", ""));
                } else {
                    var1.append(this.rawType.getSimpleName());
                }
            } else {
                var1.append(this.rawType.getName());
            }
            if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
                var1.append("<");
                boolean var2 = true;
                for (Type var6 : this.actualTypeArguments) {
                    if (!var2) {
                        var1.append(", ");
                    }
                    var1.append(var6.getTypeName());
                    var2 = false;
                }
                var1.append(">");
            }
            return var1.toString();
        }
    }
}

