/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.Trace;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.enums.ReadAccess;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.enums.WriteAccess;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.event.StreamStateEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.event.XMPPEvent;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class EventAnalyzer {
    private ImmutableEventDatagram event = null;
    private final LinkedHashMap<String, Property> systemProps = new LinkedHashMap();
    private final LinkedHashMap<String, Property> userProps = new LinkedHashMap();
    private final LinkedHashMap<String, Annotation> annotatedProps = new LinkedHashMap();
    private Class payLoadClass = null;

    public EventAnalyzer(ImmutableEventDatagram event) {
        this.event = event;
        this.parseEvent();
    }

    public LinkedHashMap<String, Property> getSystemProperties() {
        return this.systemProps;
    }

    public LinkedHashMap<String, Property> getUserProperties() {
        return this.userProps;
    }

    public LinkedHashMap<String, Annotation> getAnnotations() {
        return this.annotatedProps;
    }

    public Class getPayLoadClass() {
        return this.payLoadClass;
    }

    private void parseEvent() {
        this.putSystemProperty("Timestamp", this.event.getTimestamp(), Long.TYPE);
        this.putSystemProperty("EventId", this.event.getEventId(), String.class);
        this.putSystemProperty("TransmitAccess", this.event.getTransmitAccess(), Byte.TYPE);
        this.putSystemProperty("Durable", this.event.getDurable(), Boolean.TYPE);
        this.putSystemProperty("EventSource", Arrays.toString(this.event.getEventSource()), byte[].class);
        if (this.event instanceof AdvisoryEventDatagram) {
            this.handleAdvisoryEventDatagram();
        } else if (this.event instanceof IAbstractDataEvent) {
            this.handleIAbstractDataEvent();
        } else if (this.event instanceof IAbstractEvent) {
            this.handleIAbstractEvent();
        }
    }

    private void handleAdvisoryEventDatagram() {
        AdvisoryEvent ae;
        AdvisoryEventDatagram aed = (AdvisoryEventDatagram)this.event;
        this.putSystemProperty("CorrelationId", aed.getCorrelationId(), String.class);
        this.putSystemProperty("CorrelationIdAsBytes", Arrays.toString(aed.getCorrelationIdAsBytes()), byte[].class);
        this.putSystemProperty("EventGroupId", aed.getEventGroupId(), String.class);
        this.putSystemProperty("EventKey", aed.getEventKey(), String.class);
        if (aed instanceof AdvisoryEvent && (ae = (AdvisoryEvent)aed) instanceof FabricModeratorAdvisory) {
            FabricModeratorAdvisory fae = (FabricModeratorAdvisory)ae;
            this.putSystemProperty("Entity", fae.getEntity(), String.class);
            this.putSystemProperty("Info", fae.getInfo(), String.class);
            this.putSystemProperty("Type", (Object)fae.getType(), ModeratorAdvisoryType.class);
        }
    }

    private void handleIAbstractDataEvent() {
        IAbstractDataEvent iade = (IAbstractDataEvent)this.event;
        this.putSystemProperty("CorrelationId", iade.getCorrelationId(), String.class);
        this.putSystemProperty("CorrelationIdAsBytes", Arrays.toString(iade.getCorrelationIdAsBytes()), byte[].class);
        this.putSystemProperty("EventGroupId", iade.getEventGroupId(), String.class);
        this.putSystemProperty("EventKey", iade.getEventKey(), String.class);
        this.putSystemProperty("ForwardTo", iade.getForwardTo(), String.class);
        this.putSystemProperty("ReadAccess", ReadAccess.toString(iade.getReadAccess()), Byte.TYPE);
        this.putSystemProperty("ReplyTo", iade.getReplyTo(), String.class);
        this.putSystemProperty("WriteAccess", WriteAccess.toString(iade.getWriteAccess()), Byte.TYPE);
        for (String propName : iade.getEventPropertyNames()) {
            try {
                this.putUserProperty(propName, iade.getEventObjectProperty(propName), iade.getEventPropertyType(propName));
            }
            catch (SDOException exception) {
                Trace.logException(this, exception, true);
            }
        }
        try {
            for (String annotatedPropName : iade.getAnnotatedProperties()) {
                try {
                    this.putAnnotatedProperty(annotatedPropName, iade.getAnnotation(annotatedPropName).getSDRPath(), iade.getAnnotation(annotatedPropName).isValid());
                }
                catch (SDOException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        catch (SecurityViolationException exception) {
            Trace.logException(this, exception, true);
        }
        if (iade instanceof AbstractMutableEvent) {
            this.handleAbstractMutableEvent();
        }
    }

    private void handleAbstractMutableEvent() {
        if (this.event instanceof AcknowledgementEvent) {
            this.handleAcknowledgementEvent();
        } else if (this.event instanceof AuditEvent) {
            this.handleAuditEvent();
        } else if (this.event instanceof BytesEvent) {
            this.handleBytesEvent();
        } else if (this.event instanceof DataEvent) {
            this.handleDataEvent();
        } else if (this.event instanceof DeltaEvent) {
            this.handleDeltaEvent();
        } else if (this.event instanceof ExceptionEvent) {
            this.handleExceptionEvent();
        } else if (this.event instanceof FileEvent) {
            this.handleFileEvent();
        } else if (this.event instanceof MailEvent) {
            this.handleMailEvent();
        } else if (this.event instanceof MapEvent) {
            this.handleMapEvent();
        } else if (this.event instanceof RowArrayEvent) {
            this.handleRowArrayEvent();
        } else if (this.event instanceof RowChangeEvent) {
            this.handleRowChangeEvent();
        } else if (this.event instanceof RowEvent) {
            this.handleRowEvent();
        } else if (this.event instanceof RowSetEvent) {
            this.handleRowSetEvent();
        } else if (this.event instanceof StreamStateEvent) {
            this.handleStreamStateEvent();
        } else if (this.event instanceof TextEvent) {
            this.handleTextEvent();
        } else if (this.event instanceof XMLEvent) {
            this.handleXMLEvent();
        } else if (this.event instanceof XMPPEvent) {
            this.handleXMPPEvent();
        }
    }

    private void handleAcknowledgementEvent() {
        try {
            AcknowledgementEvent ae = (AcknowledgementEvent)this.event;
            this.putSystemUserProperty("Action", (Object)ae.getAction(), AcknowledgeAction.class);
            this.putSystemUserProperty("CorrelationEventExpiration", ae.getCorrelationEventExpiration(), Long.TYPE);
            this.putSystemUserProperty("CorrelationEventId", ae.getCorrelationEventId(), String.class);
            FabricAddress ces = ae.getCorrelationEventSource() != null ? this.parseEventSource(ae.getCorrelationEventSource()) : new FabricAddress();
            this.putSystemUserProperty("CorrelationEventSource", ces, byte[].class);
            this.putSystemUserProperty("CorrelationEventTimeStamp", ae.getCorrelationEventTimeStamp(), Long.TYPE);
            this.putSystemUserProperty("RecipientID", ae.getRecipientID(), String.class);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleAuditEvent() {
        try {
            AuditEvent ae = (AuditEvent)this.event;
            this.putSystemUserProperty("data", ae.getAuditData(), String.class, "getAuditData");
            this.putSystemUserProperty("severity", (Object)ae.getSeverity(), Severity.class, "getSeverity");
            this.payLoadClass = String.class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleBytesEvent() {
        try {
            BytesEvent be = (BytesEvent)this.event;
            this.putSystemUserProperty("BytesLength", be.getBytesLength(), Long.TYPE);
            this.payLoadClass = byte[].class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleDataEvent() {
        DataEvent de = (DataEvent)this.event;
        this.payLoadClass = de.getPayloadClass();
    }

    private void handleDeltaEvent() {
        DeltaEvent de = (DeltaEvent)this.event;
        this.payLoadClass = de.getPayloadClass();
    }

    private void handleExceptionEvent() {
        try {
            ExceptionEvent ee = (ExceptionEvent)this.event;
            this.putSystemUserProperty("ErrorCode", ee.getErrorCode(), Integer.TYPE);
            this.putSystemUserProperty("ErrorMessage", ee.getErrorMessage(), String.class);
            this.putSystemUserProperty("EventSink", ee.getEventSink(), byte[].class);
            this.putSystemUserProperty("Severity", (Object)ee.getSeverity(), Severity.class);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleFileEvent() {
        this.payLoadClass = byte[].class;
    }

    private void handleMailEvent() {
        try {
            MailEvent me = (MailEvent)this.event;
            this.putSystemUserProperty("From", me.getFrom(), List.class);
            this.putSystemUserProperty("To", me.getTo(), List.class);
            this.putSystemUserProperty("Cc", me.getCc(), List.class);
            this.putSystemUserProperty("Bcc", me.getBcc(), List.class);
            this.putSystemUserProperty("Subject", me.getSubject(), String.class);
            this.putSystemUserProperty("ContentType", me.getContentType(), String.class);
            this.putSystemUserProperty("SentDate", me.getSentDate(), Date.class);
            this.putSystemUserProperty("ReceivedDate", me.getReceivedDate(), Date.class);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleMapEvent() {
    }

    private void handleRowArrayEvent() {
        try {
            RowArrayEvent rae = (RowArrayEvent)this.event;
            this.putSystemUserProperty("Capacity", rae.getCapacity(), Integer.TYPE);
            this.putSystemUserProperty("HasKeyIndex", rae.hasKeyIndex(), Boolean.TYPE, "hasKeyIndex");
            this.putSystemUserProperty("IndexColumnName", rae.getIndexColumnName(), String.class);
            this.putSystemUserProperty("MRUEnabled", rae.isMRUEnabled(), Boolean.TYPE, "isMRUEnabled");
            this.payLoadClass = RowArray.class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleRowChangeEvent() {
        this.payLoadClass = Row.class;
    }

    private void handleRowEvent() {
        this.payLoadClass = Row.class;
    }

    private void handleRowSetEvent() {
        this.payLoadClass = RowSet.class;
    }

    private void handleStreamStateEvent() {
        try {
            StreamStateEvent sse = (StreamStateEvent)this.event;
            this.putSystemUserProperty("StreamState", (Object)sse.getStreamState(), StreamState.class);
            this.putSystemUserProperty("StreamPosition", sse.getStreamPosition(), Long.TYPE);
            this.payLoadClass = String.class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleTextEvent() {
        this.payLoadClass = String.class;
    }

    private void handleXMLEvent() {
        try {
            XMLEvent xmle = (XMLEvent)this.event;
            this.putSystemUserProperty("HasConstraint", xmle.hasConstraint(), Boolean.TYPE, "hasConstraint");
            this.payLoadClass = String.class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleXMPPEvent() {
        try {
            this.putSystemUserProperty("body", "", String.class, "getBody");
            this.payLoadClass = String.class;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void handleIAbstractEvent() {
        IAbstractEvent iae = (IAbstractEvent)this.event;
        this.putSystemProperty("EventGroupId", iae.getEventGroupId(), String.class);
        this.putSystemProperty("EventKey", iae.getEventKey(), String.class);
        if (iae instanceof OpaqueEvent) {
            OpaqueEvent oe = (OpaqueEvent)this.event;
            this.payLoadClass = oe.getPayloadClass();
        }
    }

    private FabricAddress parseEventSource(byte[] eventSource) {
        try {
            return new FabricAddress(eventSource);
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Can not parse EventSource" + Arrays.toString(this.event.getEventSource()) + ".");
            return null;
        }
    }

    private void putSystemProperty(String propName, Object propValue, Class<?> type) {
        this.systemProps.put(propName, new Property(propName, propValue, type, "get" + propName));
    }

    private void putUserProperty(String propName, Object propValue, PropertyType propertyType) {
        this.userProps.put(propName, new Property(propName, propValue));
    }

    private void putSystemUserProperty(String propName, Object propValue, Class<?> type) {
        this.systemProps.put(propName, new Property(propName, propValue, type, "get" + propName));
    }

    private void putSystemUserProperty(String propName, Object propValue, Class<?> type, String getterName) {
        this.systemProps.put(propName, new Property(propName, propValue, type, getterName));
    }

    private void putAnnotatedProperty(String propName, String sdrPath, boolean isValid) {
        this.annotatedProps.put(propName, new Annotation(propName, sdrPath, isValid));
    }

    public static String resolveTypeName(Class<?> type) {
        String result = TypeFactory.resolveTypeName(type, TypeFactory.getCurrentSemanticTypeLookupContext());
        return result != null ? result : Object.class.getSimpleName();
    }

    public static class Property {
        private String name = "";
        private Object value = "";
        private Class<?> type;
        private String getterName;

        public Property(String name, Object value) {
            this(name, value, null, null);
        }

        public Property(String name, Object value, Class<?> type, String getterName) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.getterName = getterName;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getTypeName() {
            if (this.type == null && this.value != null) {
                this.type = this.value.getClass();
                if (this.type == BigDecimal.class) {
                    return "decimal(" + EventPropertyValidator.getBigDecimalPrecision(this.value) + "," + EventPropertyValidator.getBigDecimalScale(this.value) + ")";
                }
            }
            return EventAnalyzer.resolveTypeName(this.type);
        }

        public String getGetterName() {
            return this.getterName;
        }
    }

    public static class Annotation {
        private String name;
        private String sdrPath;
        private boolean isValid;

        public Annotation(String name, String sdrPath, boolean isValid) {
            this.name = name;
            this.sdrPath = sdrPath;
            this.isValid = isValid;
        }

        public String getName() {
            return this.name;
        }

        public String getSDRPath() {
            return this.sdrPath;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

