/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.analyzer;

import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphCreationStrategy;
import com.streamscape.omf.json.utils.Primitives;
import java.lang.reflect.Modifier;
import java.util.Date;

public abstract class AbstractSkipStaticFieldsStrategy
implements TypeGraphCreationStrategy {
    @Override
    public TypeGraph getGraphNode(TypeGraph node) {
        if (Modifier.isStatic(node.getModifiers())) {
            return null;
        }
        return node;
    }

    @Override
    public boolean shouldSkipChildren(TypeGraph node) {
        Class<?> cls = TypeAnalyzer.getRawClass(node.getType());
        if (cls == null) {
            return true;
        }
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls.isPrimitive() || cls.isEnum() || cls == String.class || cls == Class.class || Primitives.isWrapperType(cls) || cls.equals(Date.class) || cls.equals(java.sql.Date.class);
    }
}

