/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization.manifest;

import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.artifact.BaseArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.PackageArtifact;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ManifestDefinition
implements Serializable {
    private int version;
    private String dataspaceType;
    private String dataspaceName;
    private String domainName;
    private String nodeName;
    private long creationTime;
    private boolean passwordProtected;
    private Map<Integer, List<ManifestEntity>> entities = new HashMap<Integer, List<ManifestEntity>>();

    public int getVersion() {
        return this.version;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public Map<Integer, List<ManifestEntity>> getEntities() {
        return this.entities;
    }

    public List<ManifestEntity> getTypeEntities(ObjectType type) {
        return this.entities.get(type.getCode());
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    public void setEntities(HashMap<Integer, List<ManifestEntity>> entities) {
        this.entities = entities;
    }

    public void setTypeEntities(int type, List<ManifestEntity> entities) {
        this.entities.put(type, entities);
    }

    public void setTypeEntityNames(int type, List<String> entities) {
        this.entities.put(type, entities.stream().map(ManifestEntity::new).collect(Collectors.toList()));
    }

    public String getDataspaceType() {
        return this.dataspaceType;
    }

    public void setDataspaceType(String dataspaceType) {
        this.dataspaceType = dataspaceType;
    }

    public String getDataspaceName() {
        return this.dataspaceName;
    }

    public void setDataspaceName(String dataspaceName) {
        this.dataspaceName = dataspaceName;
    }

    public boolean isPassworProtected() {
        return this.passwordProtected;
    }

    public void addArtifacts(Map<ObjectType, Set<BaseArtifact>> artifactMap) {
        for (ObjectType type : artifactMap.keySet()) {
            Set<BaseArtifact> arts = artifactMap.get((Object)type);
            for (BaseArtifact art : arts) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (art instanceof PackageArtifact) {
                    props.put(ManifestEntity.JARS_PROP, ((PackageArtifact)art).getJARs());
                }
                props.put(ManifestEntity.IGNORE, art.isIgnore());
                this.addEntity(type.getCode(), new ManifestEntity(art.getName(), props));
            }
        }
    }

    public void addEntity(int type, ManifestEntity entity) {
        if (this.entities.get(type) == null) {
            this.entities.put(type, new ArrayList());
        }
        this.entities.get(type).add(entity);
    }

    public void addObjects(Map<ObjectType, List<SchemaObject>> objMap) {
        for (ObjectType type : ObjectType.getBasicTypes()) {
            List<SchemaObject> objs = objMap.get((Object)type);
            if (objs == null) continue;
            for (SchemaObject obj : objs) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (type.equals((Object)ObjectType.COLLECTION)) {
                    Collection col = (Collection)obj;
                    props.put(ManifestEntity.COLLECTION_TYPE_PROP, col.getCollectionType().name());
                }
                this.addEntity(type.getCode(), new ManifestEntity(obj.getObjectName().name, props));
            }
        }
    }
}

