/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization.artifact;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerialization;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.slex.slang.SLSession;
import java.io.File;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;

public class ArtifactImporter
extends AbstractArtifact {
    public ArtifactImporter(Session session, AbstractSchemaSerialization.Logger logger) {
        super(session, logger);
    }

    public void load(AbstractArtifact.Type type, byte[] bytes, LinkedHashSet<String> rawNames, LinkedHashSet<String> rawNamesTo, boolean ignoreErrors, boolean local) throws Exception {
        block14: {
            if (bytes.length < 1) {
                return;
            }
            File frmFile = null;
            FabricConnection connection = null;
            SLSession slSession = null;
            try {
                String command;
                SLResponse slResp;
                connection = new FabricConnectionFactory().createConnection();
                connection.open();
                slSession = connection.createSLSession();
                frmFile = this.createTmpFile();
                FileUtils.writeByteArrayToFile(frmFile, bytes);
                String namesStr = "*";
                if (rawNames != null) {
                    namesStr = String.join((CharSequence)",", rawNames);
                }
                Object namesStrTo = "";
                if (rawNamesTo != null) {
                    namesStrTo = "(" + String.join((CharSequence)",", rawNamesTo) + ")";
                }
                String localOption = "";
                if (local && (AbstractArtifact.Type.SDO.equals((Object)type) || AbstractArtifact.Type.PACKAGE.equals((Object)type))) {
                    localOption = "global false";
                }
                if ((slResp = slSession.slangRequest(command = "import " + type.title + " (" + namesStr + ") " + (String)namesStrTo + " from '" + String.valueOf(frmFile) + "' " + localOption + " with wait ", 30000L)).isOK()) break block14;
                String error = "Import '" + type.title + "' failed: ";
                if (slResp.getException() != null) {
                    Trace.logException(this, slResp.getException(), true);
                    error = error + slResp.getException().getMessage();
                }
                if (ignoreErrors) {
                    this.logger.logError(error, false);
                    break block14;
                }
                throw new DataspaceException(error);
            }
            catch (Throwable e) {
                Trace.logException(this, e, true);
                throw new DataspaceException("Failed to load '" + type.title + "', objects: " + String.valueOf(rawNames));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (slSession != null) {
                    slSession.close();
                }
                if (frmFile != null) {
                    frmFile.delete();
                }
            }
        }
    }
}

