/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization.artifact;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerialization;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class ArtifactExporter
extends AbstractArtifact {
    public ArtifactExporter(Session session, AbstractSchemaSerialization.Logger logger) {
        super(session, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] export(AbstractArtifact.Type type, Set<String> rawNames, boolean ignoreErrors) throws Exception {
        File frmFile = null;
        SLSession slSession = null;
        try {
            frmFile = this.createTmpFile();
            slSession = this.getSLSession(this.session);
            SLResponse slResp = slSession.slangRequest("export " + type.title + "(" + String.join((CharSequence)",", rawNames) + ") to '" + String.valueOf(frmFile) + "' with wait", 60000L);
            if (!slResp.isOK()) {
                String error = "Export '" + type.title + "' failed: ";
                if (slResp.getException() != null) {
                    Trace.logException(this, slResp.getException(), true);
                    error = error + slResp.getException().getMessage();
                }
                if (ignoreErrors) {
                    this.logger.logError(error, false);
                } else {
                    throw new DataspaceException(error);
                }
            }
            byte[] bytes = new byte[]{};
            if (frmFile.exists()) {
                bytes = FileUtils.readFileToByteArray(frmFile);
                frmFile.delete();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (slSession != null) {
                slSession.close();
            }
            if (frmFile != null) {
                frmFile.delete();
            }
        }
    }

    private SLSession getSLSession(Session session) throws FabricConnectionException, SLSessionException {
        return session.dataspaceStore.schemaManager.findSchema("SDS").getSystemConnection().createSLSession();
    }
}

