/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization.artifact;

import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerialization;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sef.utils.SemanticUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractArtifact {
    protected final String TMP_FILE_SUFFIX = ".frm";
    protected static Map<Type, Predicate<String>> existCheckers = new HashMap<Type, Predicate<String>>();
    protected Session session;
    protected AbstractSchemaSerialization.Logger logger;

    public AbstractArtifact(Session session, AbstractSchemaSerialization.Logger logger) {
        this.session = session;
        this.logger = logger;
    }

    protected File createTmpFile() throws Exception {
        return new File(UUID.randomUUID().toString() + ".frm");
    }

    protected static boolean existDBFactory(String fname) {
        try {
            String[] t = fname.split("\\.");
            return RuntimeContext.getInstance().getRepositoryAccessor().existsJDBCFactory(t[1], t[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean existSDO(String name) {
        try {
            return RuntimeContext.getInstance().getRepositoryAccessor().existsSemanticType(name);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean existEventPrototype(String eventId) {
        return PrototypeFactory.existsPrototype(eventId);
    }

    private static boolean existClientFactory(String fname) {
        try {
            String[] t = fname.split("\\.");
            return RuntimeContext.getInstance().getRepositoryAccessor().existsClientFactory(t[1], t[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean existObject(String s) {
        return false;
    }

    private static boolean existFileDescriptor(String fd) {
        try {
            String[] t = fd.split("\\.");
            return FileDescriptorRepositoryUtils.existsFileDescriptor(t[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existArtifact(Type type, String name) {
        Predicate<String> pr = existCheckers.get((Object)type);
        if (pr != null) {
            return pr.test(name);
        }
        return false;
    }

    private static void dropFileDescriptor(String name) throws Exception {
        String[] t = name.split("\\.");
        FileDescriptorRepositoryUtils.removeFileDescriptor(t[1]);
    }

    private static void dropDBFactory(String name) throws Exception {
        String[] t = name.split("\\.");
        RuntimeContext.getInstance().getRepositoryAccessor().removeJDBCFactory(t[1], t[0]);
    }

    private static void dropClientFactory(String name) throws Exception {
        String[] t = name.split("\\.");
        RuntimeContext.getInstance().getRepositoryAccessor().removeClientFactory(t[1], t[0]);
    }

    private static void dropEventPrototype(String name) throws Exception {
        PrototypeFactory.removeEventPrototype(name);
    }

    public void dropArtifact(Type type, String name) {
        try {
            switch (type.ordinal()) {
                case 1: {
                    AbstractArtifact.dropEventPrototype(name);
                    break;
                }
                case 2: {
                    AbstractArtifact.dropClientFactory(name);
                    break;
                }
                case 3: {
                    AbstractArtifact.dropDBFactory(name);
                    break;
                }
                case 5: {
                    AbstractArtifact.dropFileDescriptor(name);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to drop '" + name + "'");
        }
    }

    public static boolean existPackage(String name) {
        try {
            return RuntimeContext.getInstance().getRepositoryAccessor().existsPackage(name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getPackageJars(String fullName) throws Exception {
        Package pkg = AbstractArtifact.getPackage(fullName);
        return pkg.listJARs();
    }

    public static List<String> getPackageTypes(String fullName) throws Exception {
        Package pkg = AbstractArtifact.getPackage(fullName);
        List<SemanticType> types = SemanticUtils.getRelatedSemanticTypes(pkg, RuntimeContext.getInstance());
        return types.stream().map(SemanticType::getTypeName).collect(Collectors.toList());
    }

    private static Package getPackage(String fullName) throws Exception {
        if (!AbstractArtifact.existPackage(fullName)) {
            throw new Exception("Package do not exist");
        }
        String[] tokens = fullName.split("\\.");
        return RuntimeContext.getInstance().getRepositoryAccessor().getPackage(PackageType.valueOf(tokens[0]), tokens[1]);
    }

    static {
        existCheckers.put(Type.PACKAGE, AbstractArtifact::existPackage);
        existCheckers.put(Type.SDO, AbstractArtifact::existSDO);
        existCheckers.put(Type.EVENT_PROTOTYPE, AbstractArtifact::existEventPrototype);
        existCheckers.put(Type.CLIENT_FACTORY, AbstractArtifact::existClientFactory);
        existCheckers.put(Type.DB_FACTORY, AbstractArtifact::existDBFactory);
        existCheckers.put(Type.OBJECT, AbstractArtifact::existObject);
        existCheckers.put(Type.FILE_DESCRIPTOR, AbstractArtifact::existFileDescriptor);
    }

    public static enum Type {
        SDO("sdo"),
        EVENT_PROTOTYPE("event-prototype"),
        CLIENT_FACTORY("client-factory"),
        DB_FACTORY("db-factory"),
        OBJECT("object"),
        FILE_DESCRIPTOR("file-descriptor"),
        PACKAGE("package");

        public String title;

        private Type(String title) {
            this.title = title;
        }
    }
}

