/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.ServerDef;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactExporter;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactImporter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class WebServerDef
extends ServerDef {
    private byte[] httpRequests;

    public WebServerDef(SchemaObject object) {
        super(object);
        this.parameters.put("cascadeDrop", true);
    }

    @Override
    public void beforeDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
        super.beforeDump(dumper, session, output);
        HashSet<String> raw = new HashSet<String>();
        raw.add("http/request/" + this.object.getSchemaName().name + "/" + this.object.getObjectName().name + "/*");
        this.httpRequests = new ArtifactExporter(session, dumper.logger).export(AbstractArtifact.Type.OBJECT, raw, dumper.ignoreErrors);
        this.parameters.put("initialDataspaceName", this.object.getSchemaName().name);
    }

    @Override
    public void afterLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
        boolean ignoreErrors = loader.isIgnoreErrors() || loader.isMerge();
        LinkedHashSet<String> raw = new LinkedHashSet<String>();
        raw.add("http/request/" + String.valueOf(this.parameters.get("initialDataspaceName")) + "/" + this.object.getObjectName().name + "/*");
        LinkedHashSet<String> rawTo = new LinkedHashSet<String>();
        rawTo.add("http/request/" + this.object.getSchemaName().name + "/" + this.object.getObjectName().name + "/");
        new ArtifactImporter(session, loader.logger).load(AbstractArtifact.Type.OBJECT, this.httpRequests, raw, rawTo, ignoreErrors, !loader.artifactGlobal);
        super.afterLoad(loader, session, input);
    }

    @Override
    public void beforeLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
        super.beforeLoad(loader, session, input);
        this.parameters.put("cascadeDrop", true);
    }
}

