/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import java.io.InputStream;

public class ServerDef
extends SchemaObjectDef {
    public ServerDef(SchemaObject object) {
        super(object);
    }

    @Override
    public void afterLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
        super.afterLoad(loader, session, input);
        if (!loader.isMerge()) {
            loader.logger.log("      Starting virtual server '" + this.name + "' ...");
            Result res = session.executeDirectStatement("start server [" + this.name + "]");
            if (res.isError()) {
                Trace.logException(this, res.getException(), true);
                throw new DataspaceException(res.getException().getMessage());
            }
            Thread.sleep(3000L);
            loader.logger.log(" OK\n");
        }
    }

    @Override
    protected SchemaObject mergeAction(SchemaLoader loader, Session session, InputStream input) throws Exception {
        this.mergeSkip(loader);
        return null;
    }
}

