/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerializationReader;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaComparator;
import com.streamscape.ds.utils.schemaserialization.SchemaDef;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDefFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SchemaObjectDef
implements Serializable {
    public int type;
    public String name;
    public String statementName;
    public String sql;
    public transient SchemaObject object;
    public Map<String, Object> parameters = new HashMap<String, Object>();
    public List<SchemaObjectDef> subDefs = new ArrayList<SchemaObjectDef>();
    protected Timestamp createdTimestamp;
    protected Timestamp modifiedTimestamp;

    public SchemaObjectDef(SchemaObject object) {
        this.object = object;
        this.type = object.getObjectType();
        this.name = object.getObjectName().name;
        this.statementName = object.getObjectName().statementName;
        if (object.getSQL() != null) {
            this.sql = DumpLoadUtil.replaceSchemaQualifiedNameByName(object.getSQL(), object);
        }
    }

    public void dump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
        String typeName = StringUtils.capitalize((String)ObjectType.getNameByCode(this.object.getObjectType()));
        dumper.logger.log("    Processing " + typeName + " '" + this.object.getObjectName().name + "'... ");
        dumper.logger.log("OK\n");
        this.beforeDump(dumper, session, output);
        dumper.writeObjectDefinition(output, this);
        this.afterDump(dumper, session, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject load(SchemaLoader loader, Session session, InputStream input) throws Exception {
        String currentDataspaceName = session.getCurrentDataspaceName().name;
        loader.logger.log("    Loading " + this.typeNameLogTmpl() + "... \n");
        this.beforeLoad(loader, session, input);
        SchemaObject currentObject = null;
        try {
            currentObject = session.dataspaceStore.schemaManager.findSchemaObject(this.name, currentDataspaceName, this.type);
            if (currentObject == null) {
                loader.logger.log("      Creating " + this.typeNameLogTmpl() + "... ");
                Result result = loader.executeObjectStatement(this);
                if (result == null || result.isError()) {
                    throw result.getException();
                }
                currentObject = session.dataspaceStore.schemaManager.getSchemaObject(this.name, currentDataspaceName, this.type);
                loader.logger.log("OK\n");
            } else {
                SchemaObject mergedObject;
                String typeName = StringUtils.capitalize((String)ObjectType.getNameByCode(currentObject.getObjectType()));
                if (!loader.isMerge() && !loader.isReplaceWithTruncate()) {
                    throw new DataspaceException(typeName + " object '" + this.name + "' already exists.");
                }
                if ((loader.isMerge() || loader.isReplaceWithTruncate()) && (mergedObject = this.mergeAction(loader, session, input)) != null) {
                    currentObject = mergedObject;
                }
            }
        }
        finally {
            this.object = currentObject;
        }
        this.afterLoad(loader, session, input);
        return currentObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject load2(SchemaLoader loader, Session session) throws Exception {
        String currentDataspaceName = session.getCurrentDataspaceName().name;
        SchemaObject currentObject = null;
        try {
            loader.logger.log("      Altering " + this.typeNameLogTmpl() + "... ");
            Result result = loader.executeObjectStatement2(this);
            if (result == null || result.isError()) {
                throw result.getException();
            }
            currentObject = session.dataspaceStore.schemaManager.getSchemaObject(this.name, currentDataspaceName, this.type);
            loader.logger.log("OK\n");
        }
        finally {
            this.object = currentObject;
        }
        return currentObject;
    }

    protected SchemaObject mergeAction(SchemaLoader loader, Session session, InputStream input) throws Exception {
        String currentDataspaceName = session.getCurrentDataspaceName().name;
        loader.logger.log("      Dropping " + this.typeNameLogTmpl() + "... OK\n");
        boolean isCascadeDrop = (Boolean)this.parameters.getOrDefault("cascadeDrop", false);
        loader.dropSchemaObject(this.name, this.type, isCascadeDrop);
        loader.logger.log("      Creating " + this.typeNameLogTmpl() + "... OK\n");
        Result result = loader.executeObjectStatement(this);
        if (result == null || result.isError()) {
            throw result.getException();
        }
        return session.dataspaceStore.schemaManager.getSchemaObject(this.name, currentDataspaceName, this.type);
    }

    protected void mergeSkip(SchemaLoader loader) throws Exception {
        loader.logger.log("      Creating " + this.typeNameLogTmpl() + "... Skipped\n");
    }

    public void beforeLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
    }

    public void afterLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
    }

    public void beforeDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
    }

    public void afterDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
    }

    public String typeNameLogTmpl() {
        return ObjectType.getNameByCode(this.type) + " '" + this.name + "'";
    }

    public void skip(AbstractSchemaSerializationReader loader, Session session, InputStream input) throws Exception {
    }

    public SchemaComparator.SchemaComparatorResult compare(AbstractSchemaSerializationReader comparator, Session session, InputStream input) throws Exception {
        try {
            DataspaceSchema databaseObject = this.type == 2 ? session.dataspaceStore.schemaManager.findSchema(session.currentDataspace.name) : session.dataspaceStore.schemaManager.findSchemaObject(this.name, session.currentDataspace.name, this.type);
            SchemaObjectDef databaseObjectDef = SchemaObjectDefFactory.get(databaseObject, this instanceof SchemaDef ? this.statementName : null);
            if (this.doCompare(session, databaseObjectDef)) {
                return new SchemaComparator.SchemaComparatorResult(SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.OK, this.type, this.name);
            }
            return new SchemaComparator.SchemaComparatorResult(SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.NOK, this.type, this.name, this.sql, databaseObjectDef.getOrLoadObjectDefinition(session), this.modifiedTimestamp != null ? this.modifiedTimestamp : this.createdTimestamp, databaseObjectDef.getOrLoadObjectLastModifiedTimestamp(session));
        }
        catch (Exception error) {
            return new SchemaComparator.SchemaComparatorResult(SchemaComparator.SchemaComparatorResult.SchemaComparatorStatus.MISSING_IN_TARGET_DATASPACE, this.type, this.name);
        }
    }

    protected boolean doCompare(Session session, SchemaObjectDef databaseObjectDef) {
        return this.sql.equals(databaseObjectDef.getOrLoadObjectDefinition(session));
    }

    public String getOrLoadObjectDefinition(Session session) {
        if (this.sql == null) {
            return session.dataspaceStore.schemaManager.loadObjectDefinition(session, this.object);
        }
        return this.sql;
    }

    public Timestamp getOrLoadObjectLastModifiedTimestamp(Session session) {
        return null;
    }
}

