/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerializationReader;
import com.streamscape.ds.utils.schemaserialization.CollectionDef;
import com.streamscape.ds.utils.schemaserialization.DependencyLoader;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.lib.concurrent.FabricThreadManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemaLoader
extends AbstractSchemaSerializationReader {
    protected boolean ignoreFlobs;
    protected MergeMode mergeMode;
    protected static int DEFAULT_BATCH_SIZE = 100;
    protected String dataspaceName;
    protected boolean artifactGlobal = true;

    public SchemaLoader(Session session, String filename, boolean compressed, List<String> includeObjects, List<String> excludeObjects) throws Exception {
        super(session, filename, false, includeObjects, excludeObjects);
        this.cryptMode = 2;
        this.compressed = FilenameUtils.getExtension(filename).equals("gz");
    }

    public SchemaLoader(Session session, String filename, boolean compressed) throws Exception {
        this(session, filename, compressed, null, null);
    }

    public SchemaLoader(String filename, boolean compressed) throws Exception {
        this(null, filename, compressed, null, null);
    }

    public void loadCollection(String collectionName, boolean withWait, int newMemoryModel, String newName) throws Exception {
        HTTPFabricConnection.RunnableException loader = () -> {
            try (InputStream input = this.getInputStream();){
                SchemaObjectDef def;
                long startTime = System.currentTimeMillis();
                this.logger.log("\n", true);
                if (!this.verbose) {
                    this.logger.log("    Loading... ", true);
                }
                this.logger.log("    Loading Manifest... ");
                this.manifestDefinition = this.readManifest(input);
                this.logger.log("OK\n");
                this.initEncryption();
                this.readEncryptHeader(input);
                DependencyLoader depLoader = new DependencyLoader(this);
                HashMap<ObjectType, Integer> stats = new HashMap<ObjectType, Integer>();
                stats.putAll(depLoader.load(input));
                Collection collection = null;
                while ((def = this.readObjectDefinition(input)) != null) {
                    try {
                        ObjectType defType = ObjectType.getByCode(def.type);
                        stats.putIfAbsent(defType, 0);
                        stats.put(defType, (Integer)stats.get((Object)defType) + 1);
                        if (def instanceof CollectionDef) {
                            CollectionDef defCol = (CollectionDef)def;
                            if (def.name.equals(collectionName)) {
                                collection = (Collection)defCol.load(this, this.session, input, newMemoryModel, newName);
                                break;
                            }
                            defCol.skip(this, this.session, input);
                            continue;
                        }
                        def.load(this, this.session, input);
                    }
                    catch (Exception e) {
                        if (this.ignoreErrors) {
                            this.logger.logError("    " + e.getMessage() + "\n", false);
                            continue;
                        }
                        throw e;
                    }
                }
                if (collection == null) {
                    throw new DataspaceException("There is no collection '" + collectionName + "' in the dump");
                }
                if (input != null) {
                    input.close();
                }
                long processingTime = System.currentTimeMillis() - startTime;
                this.logCollectionPreStats(processingTime);
                int pad = 19;
                for (ObjectType type : ObjectType.getTypesForStats()) {
                    int cnt = 0;
                    if (stats.get((Object)type) != null) {
                        cnt = (Integer)stats.get((Object)type);
                    }
                    Object title = DumpLoadUtil.getTypeLogPluralName(type) + ":";
                    title = StringUtils.rightPad((String)title, (int)pad);
                    this.logger.log("    " + (String)title + cnt + "\n", true);
                }
                if (!this.dataLoadStats.isEmpty()) {
                    this.logger.log("\n    Data Load Statistics\n", true);
                    this.logger.log("    ------------------------------------\n\n", true);
                    for (Collection col : this.dataLoadStats.keySet()) {
                        String title = StringUtils.rightPad((String)(col.getCollectionName() + ":"), (int)pad);
                        this.logger.log("    " + title + String.valueOf(this.dataLoadStats.get(col)) + "\n", true);
                    }
                }
            }
        };
        if (withWait) {
            loader.run();
        } else {
            FabricThreadManager.getInstance().createThread("FSYS:StatementCommand.LoadCollection", "Loads a collection.", () -> {
                try {
                    this.initProgressMonitor();
                    loader.run();
                }
                catch (Exception ex) {
                    try {
                        Trace.logException(this, ex, true);
                        this.logger.raiseErrorMessage(ex.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.stopProgressMonitor();
                    try {
                        this.logger.raiseMessage(null);
                    }
                    catch (Exception exception) {}
                }
            }).start();
        }
    }

    public void loadDataspace(boolean withWait) throws Exception {
        HTTPFabricConnection.RunnableException loader = () -> {
            NameManager.ObjectName initialDataspaceName = this.session.getCurrentDataspaceName();
            boolean isSDS = this.session.isSDSRuntimeSession();
            try (InputStream input = this.getInputStream();){
                SchemaObjectDef def;
                long startTime = System.currentTimeMillis();
                this.logger.log("\n", true);
                if (!this.verbose) {
                    this.logger.log("    Loading... ", true);
                }
                this.logger.log("    Loading Manifest... ");
                this.manifestDefinition = this.readManifest(input);
                this.logger.log("OK\n");
                this.initEncryption();
                this.readEncryptHeader(input);
                HashMap<ObjectType, Integer> stats = new HashMap<ObjectType, Integer>();
                DependencyLoader depLoader = new DependencyLoader(this);
                stats.putAll(depLoader.load(input));
                AbstractDataspace ds = (AbstractDataspace)this.session.dataspaceStore.schemaManager.findSchema(this.dataspaceName);
                if (ds != null) {
                    this.session.setCurrentDataspaceName(ds.getObjectName());
                    this.session.setSDSRuntimeSession(false);
                }
                ArrayList<SchemaObjectDef> functionDefs = new ArrayList<SchemaObjectDef>();
                while ((def = this.readObjectDefinition(input)) != null) {
                    try {
                        ObjectType defType = ObjectType.getByCode(def.type);
                        if (this.isAvailableObjectType(defType)) {
                            stats.putIfAbsent(defType, 0);
                            stats.put(defType, (Integer)stats.get((Object)defType) + 1);
                            SchemaObject current = def.load(this, this.session, input);
                            if (current instanceof AbstractDataspace) {
                                ds = (AbstractDataspace)current;
                            }
                            if (def.type == 17 || def.type == 19) {
                                functionDefs.add(def);
                                continue;
                            }
                            if (functionDefs.size() <= 0) continue;
                            for (SchemaObjectDef functionDef : functionDefs) {
                                functionDef.load2(this, this.session);
                            }
                            functionDefs.clear();
                            continue;
                        }
                        def.skip(this, this.session, input);
                    }
                    catch (Exception e) {
                        if (this.ignoreErrors) {
                            this.logger.logError("    " + e.getMessage() + "\n", false);
                            def.skip(this, this.session, input);
                            continue;
                        }
                        throw e;
                    }
                }
                for (SchemaObjectDef functionDef : functionDefs) {
                    functionDef.load2(this, this.session);
                }
                if (input != null) {
                    input.close();
                }
                int pad = 19;
                long processingTime = System.currentTimeMillis() - startTime;
                this.logDataspacePreStats(ds, processingTime);
                for (ObjectType type : ObjectType.getTypesForStats()) {
                    int cnt = 0;
                    if (stats.get((Object)type) != null) {
                        cnt = (Integer)stats.get((Object)type);
                    }
                    Object title = DumpLoadUtil.getTypeLogPluralName(type) + ":";
                    title = StringUtils.rightPad((String)title, (int)pad);
                    this.logger.log("    " + (String)title + cnt + "\n", true);
                }
                if (!this.dataLoadStats.isEmpty()) {
                    this.logger.log("\n    Data Load Statistics\n", true);
                    this.logger.log("    ------------------------------------\n\n", true);
                    for (Collection col : this.dataLoadStats.keySet()) {
                        String title = StringUtils.rightPad((String)(col.getCollectionName() + ":"), (int)pad);
                        this.logger.log("    " + title + String.valueOf(this.dataLoadStats.get(col)) + "\n", true);
                    }
                }
            }
            finally {
                this.session.setCurrentDataspaceName(initialDataspaceName);
                this.session.setSDSRuntimeSession(isSDS);
            }
        };
        if (withWait) {
            loader.run();
        } else {
            FabricThreadManager.getInstance().createThread("FSYS:StatementCommand.LoadDataspace", "Loads a dataspace.", () -> {
                try {
                    this.initProgressMonitor();
                    loader.run();
                }
                catch (Exception e) {
                    Trace.logException(this, e, true);
                    try {
                        this.logger.raiseErrorMessage(e.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.stopProgressMonitor();
                    try {
                        this.logger.raiseMessage(null);
                    }
                    catch (Exception exception) {}
                }
            }).start();
        }
    }

    public void setMergeMode(MergeMode mergeMode) {
        this.mergeMode = mergeMode;
    }

    public boolean isNew() {
        return this.mergeMode.equals((Object)MergeMode.NEW);
    }

    public boolean isMerge() {
        return this.mergeMode.equals((Object)MergeMode.MERGE);
    }

    public boolean isReplaceWithTruncate() {
        return this.mergeMode.equals((Object)MergeMode.REPLACE_WITH_TRUNCATE);
    }

    public int getBatchSize() {
        return DEFAULT_BATCH_SIZE;
    }

    public void setDataspaceName(String dataspaceName) {
        this.dataspaceName = dataspaceName;
    }

    public void setArtifactGlobal(boolean artifactGlobal) {
        this.artifactGlobal = artifactGlobal;
    }

    public void setIgnoreDependencies(boolean ignoreDeps) {
        this.session.sessionData.setIgnoreDependencies(ignoreDeps);
    }

    private void logCollectionPreStats(long processingTime) throws Exception {
        int pad = 19;
        this.logger.log("\n    Collection Load Completed\n", true);
        this.logger.log("    ------------------------------------\n\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Created On:", (int)pad) + this.dateNowFormatted() + "\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Time:", (int)pad) + DumpLoadUtil.formatNumber(processingTime) + " ms\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"File Size:", (int)pad) + DumpLoadUtil.formatFileSize(this.getFileSize()) + " bytes\n\n", true);
    }

    private void logDataspacePreStats(AbstractDataspace ds, long processingTime) throws Exception {
        int pad = 19;
        this.logger.log("\n    Dataspace Load Completed\n", true);
        this.logger.log("    ------------------------------------\n\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Dataspace Name:", (int)pad) + ds.getName() + "\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Dataspace Model:", (int)pad) + ds.getDataspaceType().name() + "\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Created On:", (int)pad) + this.dateNowFormatted() + "\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"Time:", (int)pad) + DumpLoadUtil.formatNumber(processingTime) + " ms\n", true);
        this.logger.log("    " + StringUtils.rightPad((String)"File Size:", (int)pad) + DumpLoadUtil.formatFileSize(this.getFileSize()) + " bytes\n\n", true);
    }

    public void setIgnoreFlobs(boolean ignoreFlobs) {
        this.ignoreFlobs = ignoreFlobs;
    }

    public static enum MergeMode {
        DEFAULT,
        MERGE,
        NEW,
        REPLACE_WITH_TRUNCATE;

    }
}

