/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.hadoop.HadoopVirtualTableCollection;
import com.streamscape.ds.schema.collection.tspace.view.ViewCollection;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerialization;
import com.streamscape.ds.utils.schemaserialization.DependencyDumper;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectStatistics;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDefFactory;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestDefinition;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public class SchemaDumper
extends AbstractSchemaSerialization {
    private List<String> packages;

    public SchemaDumper(Session session, String filename, boolean compressed, List<String> includeObject, List<String> excludeObject) throws Exception {
        super(session, filename, compressed, includeObject, excludeObject);
        String ext;
        String string = ext = compressed ? "gz" : "dmp";
        if (!filename.endsWith(ext)) {
            this.filename = filename + "." + ext;
        }
        this.cryptMode = 1;
    }

    public void dumpCollection(com.streamscape.ds.schema.collection.Collection collection, boolean withWait) throws Exception {
        HTTPFabricConnection.RunnableException dumper = () -> {
            int version = this.retrieveVersion();
            try (OutputStream output = this.getOutputStream();){
                String title;
                this.logger.log("\n", true);
                long startTime = System.currentTimeMillis();
                if (!this.verbose) {
                    this.logger.log("    Processing...\n", true);
                }
                this.logger.log("    Processing Manifest... ");
                SchemaObjectContainer objContainer = new SchemaObjectContainer();
                objContainer.add(ObjectType.COLLECTION, collection);
                DependencyDumper depDumper = new DependencyDumper(this);
                try {
                    depDumper.addPackages(this.packages);
                    depDumper.add(this.session, objContainer.getAllSchemaObjects());
                }
                catch (Exception e) {
                    if (this.ignoreErrors) {
                        this.logger.logError(e.getMessage() + "\n", false);
                    }
                    throw e;
                }
                objContainer.visitDumper(depDumper);
                AbstractDataspace ds = (AbstractDataspace)this.session.dataspaceStore.schemaManager.findSchema(collection.getSchemaName().name);
                this.writeManifest(output, ds, objContainer.objectMap, version, depDumper);
                this.logger.log("OK\n");
                this.initEncryption();
                this.writeEncryptHeader(output);
                depDumper.dump(output);
                ObjectStatistics stats = new ObjectStatistics();
                this.flushDataLoadStats();
                stats.addAll(depDumper.getArtifactStats());
                for (ObjectType type : ObjectType.getBasicTypes()) {
                    List<SchemaObject> objects = objContainer.getByType(type);
                    if (objects == null) {
                        objects = Collections.emptyList();
                    }
                    stats.add(type, objects.size());
                    for (SchemaObject object : objects) {
                        this.dumpSchemaObject(output, object);
                    }
                }
                long processingTime = System.currentTimeMillis() - startTime;
                int pad = 19;
                this.logger.log("\n    Collection Dump Completed\n", true);
                this.logger.log("    ------------------------------------\n\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"Created On:", (int)pad) + this.dateNowFormatted() + "\n", true);
                output.close();
                this.logger.log("    " + StringUtils.rightPad((String)"Time:", (int)pad) + DumpLoadUtil.formatNumber(processingTime) + " ms\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"File Size:", (int)pad) + DumpLoadUtil.formatFileSize(this.getFileSize()) + " bytes\n\n", true);
                for (ObjectType type : ObjectType.getTypesForStats()) {
                    title = DumpLoadUtil.getTypeLogPluralName(type);
                    title = StringUtils.rightPad((String)(title + ":"), (int)pad);
                    this.logger.log("    " + title + stats.get(type) + "\n", true);
                }
                if (!this.dataLoadStats.isEmpty()) {
                    this.logger.log("\n    Data Load Statistics\n", true);
                    this.logger.log("    ------------------------------------\n\n", true);
                    for (com.streamscape.ds.schema.collection.Collection col : this.dataLoadStats.keySet()) {
                        title = StringUtils.rightPad((String)(col.getCollectionName() + ":"), (int)pad);
                        this.logger.log("    " + title + String.valueOf(this.dataLoadStats.get(col)) + "\n", true);
                    }
                }
            }
        };
        if (withWait) {
            dumper.run();
        } else {
            FabricThreadManager.getInstance().createThread("FSYS:StatementCommand.DumpCollection", "Dumps a collection.", () -> {
                try {
                    this.initProgressMonitor();
                    dumper.run();
                }
                catch (Exception exception) {
                    try {
                        this.logger.raiseErrorMessage(exception.getMessage());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                finally {
                    this.stopProgressMonitor();
                    try {
                        this.logger.raiseMessage(null);
                    }
                    catch (Exception exception) {}
                }
            }).start();
        }
    }

    public void dumpDataspace(AbstractDataspace ds, boolean withWait) throws Exception {
        HTTPFabricConnection.RunnableException dumper = () -> {
            int version = this.retrieveVersion();
            try (OutputStream output = this.getOutputStream();){
                String title;
                long startTime = System.currentTimeMillis();
                this.logger.log("\n", true);
                if (!this.verbose) {
                    this.logger.log("    Processing...", true);
                }
                this.logger.log("    Processing Manifest... ");
                SchemaObjectContainer objContainer = new SchemaObjectContainer(ds);
                DependencyDumper depDumper = new DependencyDumper(this);
                try {
                    depDumper.addPackages(this.packages);
                    depDumper.add(this.session, objContainer.getAllSchemaObjects());
                }
                catch (Exception e) {
                    if (this.ignoreErrors) {
                        this.logger.logError(e.getMessage() + "\n", false);
                    }
                    throw e;
                }
                objContainer.visitDumper(depDumper);
                this.writeManifest(output, ds, objContainer.objectMap, version, depDumper);
                this.logger.log("OK\n");
                this.initEncryption();
                this.writeEncryptHeader(output);
                depDumper.dump(output);
                SchemaObjectDefFactory.get(ds).dump(this, this.session, output);
                ObjectStatistics stats = new ObjectStatistics();
                stats.addAll(depDumper.getArtifactStats());
                for (ObjectType type : ObjectType.getBasicTypes()) {
                    List<SchemaObject> objects = objContainer.getByType(type);
                    if (objects == null) {
                        objects = Collections.emptyList();
                    }
                    stats.add(type, objects.size());
                    for (SchemaObject object : objects) {
                        this.dumpSchemaObject(output, object);
                    }
                }
                long processingTime = System.currentTimeMillis() - startTime;
                int pad = 19;
                this.logger.log("\n    Dataspace Dump Completed\n", true);
                this.logger.log("    ------------------------------------\n\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"Dataspace Name:", (int)pad) + ds.getName() + "\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"Dataspace Model:", (int)pad) + ds.getDataspaceType().name() + "\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"Created On:", (int)pad) + this.dateNowFormatted() + "\n", true);
                output.close();
                this.logger.log("    " + StringUtils.rightPad((String)"Time:", (int)pad) + DumpLoadUtil.formatNumber(processingTime) + " ms\n", true);
                this.logger.log("    " + StringUtils.rightPad((String)"File Size:", (int)pad) + DumpLoadUtil.formatFileSize(this.getFileSize()) + " bytes\n\n", true);
                for (ObjectType type : ObjectType.getTypesForStats()) {
                    title = DumpLoadUtil.getTypeLogPluralName(type);
                    title = StringUtils.rightPad((String)(title + ":"), (int)pad);
                    this.logger.log("    " + title + stats.get(type) + "\n", true);
                }
                if (!this.dataLoadStats.isEmpty()) {
                    this.logger.log("\n    Data Load Statistics\n", true);
                    this.logger.log("    ------------------------------------\n\n", true);
                    for (com.streamscape.ds.schema.collection.Collection col : this.dataLoadStats.keySet()) {
                        title = StringUtils.rightPad((String)(col.getCollectionName() + ":"), (int)pad);
                        this.logger.log("    " + title + String.valueOf(this.dataLoadStats.get(col)) + "\n", true);
                    }
                }
            }
        };
        if (withWait) {
            dumper.run();
        } else {
            FabricThreadManager.getInstance().createThread("FSYS:StatementCommand.DumpDataspace", "Dumps a dataspace.", () -> {
                try {
                    this.initProgressMonitor();
                    dumper.run();
                }
                catch (Exception e) {
                    try {
                        Trace.logException(this, e, true);
                        this.logger.raiseErrorMessage(e.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.stopProgressMonitor();
                    try {
                        this.logger.raiseMessage(null);
                    }
                    catch (Exception exception) {}
                }
            }).start();
        }
    }

    private void writeEncryptHeader(OutputStream output) throws Exception {
        if (this.passwordProtected) {
            this.doWrite(output, "ST_AES".getBytes());
        }
    }

    private SchemaObjectDef dumpSchemaObject(OutputStream output, SchemaObject object) throws Exception {
        SchemaObjectDef def = SchemaObjectDefFactory.get(object);
        def.dump(this, this.session, output);
        for (SchemaObjectDef sub : def.subDefs) {
            sub.dump(this, this.session, output);
        }
        return def;
    }

    protected void writeObjectDefinition(OutputStream output, SchemaObjectDef objectDef) throws Exception {
        this.writeString(output, this.serialize(objectDef));
    }

    protected void writeString(OutputStream output, String value) throws Exception {
        this.writeBytes(output, value.getBytes());
    }

    protected void writeBytes(OutputStream output, byte[] bytes) throws Exception {
        this.doWriteInt(output, bytes.length);
        this.doWrite(output, bytes);
    }

    protected void doWriteInt(OutputStream output, int v) throws IOException {
        this.doWrite(output, new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)});
    }

    protected void doWrite(OutputStream output, byte[] bytes) throws IOException {
        this.doWrite(output, bytes, bytes.length);
    }

    protected void doWrite(OutputStream output, byte[] bytes, int len) throws IOException {
        if (!this.isIgnoreEnc() && this.passwordProtected) {
            bytes = this.cipher.update(bytes, 0, len);
        }
        if (bytes != null) {
            output.write(bytes, 0, len);
        }
    }

    protected void doWrite(OutputStream output, int v) throws IOException {
        this.doWrite(output, new byte[]{(byte)v});
    }

    private OutputStream getOutputStream() throws Exception {
        OutputStream output = SessionData.createFileOutputStream(this.session, this.filename, true, false);
        if (output instanceof SLFileOutputStream) {
            ((SLFileOutputStream)output).setVerbose(false);
        }
        if (this.compressed) {
            if (output instanceof SLFileOutputStream) {
                output = new BufferedOutputStream(output);
            }
            output = new GZIPOutputStream(output);
        }
        output = new BufferedOutputStream(output);
        return output;
    }

    private void writeManifest(OutputStream output, AbstractDataspace ds, Map<ObjectType, List<SchemaObject>> objMap, int version, DependencyDumper depDumper) throws Exception {
        this.setIgnoreEnc(true);
        ManifestDefinition def = new ManifestDefinition();
        def.setVersion(version);
        def.setPasswordProtected(this.password != null);
        def.setDataspaceType(ds.getType());
        def.setDataspaceName(ds.getName());
        def.setDomainName(DataspaceStoreManager.getRuntimeContext().getDomain());
        def.setNodeName(DataspaceStoreManager.getRuntimeContext().getName());
        def.setCreationTime(System.currentTimeMillis());
        def.addArtifacts(depDumper.getArtifacs());
        def.addObjects(objMap);
        this.writeString(output, this.serialize(def));
        this.setIgnoreEnc(false);
    }

    private int retrieveVersion() {
        int version = 1;
        try {
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(this.session, this.filename);
            if (utils.exists()) {
                ManifestDefinition manDef = new SchemaLoader(this.session, this.filename, false).loadManifest();
                version = manDef.getVersion() + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    @Override
    public void setPassword(String password) {
        super.setPassword(password);
        if (password != null) {
            this.passwordProtected = true;
        }
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public class SchemaObjectContainer {
        private Map<ObjectType, List<SchemaObject>> objectMap;

        public SchemaObjectContainer(AbstractDataspace ds) {
            this.objectMap = this.getSchemaObjectMap(ds);
        }

        public SchemaObjectContainer() {
            this.objectMap = new LinkedHashMap<ObjectType, List<SchemaObject>>();
        }

        private Map<ObjectType, List<SchemaObject>> getSchemaObjectMap(AbstractDataspace ds) {
            HashMap<ObjectType, List<SchemaObject>> res = new HashMap<ObjectType, List<SchemaObject>>();
            for (ObjectType type : ObjectType.getBasicTypes()) {
                List<SchemaObject> objs = this.preProcessRow(SchemaDumper.this.getFilteredSchemaObjects(ds, type), type);
                if (objs.isEmpty()) continue;
                res.put(type, objs);
            }
            return res;
        }

        private List<SchemaObject> preProcessRow(List<SchemaObject> row, ObjectType type) {
            if (type.equals((Object)ObjectType.VIEW)) {
                return row.stream().filter(o -> o instanceof View).collect(Collectors.toList());
            }
            if (type.equals((Object)ObjectType.COLLECTION)) {
                return row.stream().filter(o -> !(o instanceof ViewCollection) && !(o instanceof HadoopVirtualTableCollection)).collect(Collectors.toList());
            }
            return row;
        }

        public void visitDumper(DependencyDumper depDumper) {
            depDumper.getDataspaceDeps().entrySet().stream().forEach(entry -> {
                if (((ObjectType)((Object)((Object)entry.getKey()))).equals((Object)ObjectType.FUNCTION)) {
                    Set names;
                    if (this.objectMap.containsKey((Object)ObjectType.FUNCTION) && !(names = ((Set)entry.getValue()).stream().map(d -> d.getObjectName().statementName).collect(Collectors.toSet())).isEmpty()) {
                        ArrayList<SchemaObject> beginning = new ArrayList<SchemaObject>();
                        ArrayList<SchemaObject> end = new ArrayList<SchemaObject>();
                        for (SchemaObject obj : this.objectMap.get((Object)ObjectType.FUNCTION)) {
                            if (names.contains(obj.getObjectName().statementName)) {
                                beginning.add(obj);
                                continue;
                            }
                            end.add(obj);
                        }
                        beginning.addAll(end);
                        this.objectMap.put(ObjectType.FUNCTION, beginning);
                    }
                } else {
                    this.add((ObjectType)((Object)((Object)entry.getKey())), (Collection)entry.getValue());
                }
            });
        }

        public void add(ObjectType type, SchemaObject object) {
            this.add(type, Collections.singletonList(object));
        }

        public void add(ObjectType type, Collection<SchemaObject> objects) {
            if (!this.objectMap.containsKey((Object)type)) {
                this.objectMap.put(type, new ArrayList());
            }
            this.objectMap.get((Object)type).addAll(objects);
        }

        public List<SchemaObject> getAllSchemaObjects() {
            ArrayList<SchemaObject> res = new ArrayList<SchemaObject>();
            this.objectMap.forEach((type, row) -> res.addAll((Collection<SchemaObject>)row));
            return res;
        }

        public List<SchemaObject> getByType(ObjectType type) {
            return this.objectMap.get((Object)type);
        }
    }
}

