/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import java.io.InputStream;

public class SchemaDef
extends SchemaObjectDef {
    public SchemaDef(SchemaObject object, String schemaName) {
        super(object);
        if (schemaName != null) {
            this.statementName = schemaName;
            if (object.getSQL() != null) {
                this.sql = DumpLoadUtil.replaceSchemaQualifiedNameByName(object.getSQL(schemaName), object);
            }
        }
    }

    @Override
    public SchemaObject load(SchemaLoader loader, Session session, InputStream input) throws Exception {
        String dsName = loader.dataspaceName;
        loader.logger.log("    Loading schema '" + dsName + "'...\n");
        DataspaceSchema currentSchema = session.dataspaceStore.schemaManager.findSchema(dsName);
        if (currentSchema == null) {
            if (!this.name.equals(dsName)) {
                String escapedDsName = "[" + dsName + "]";
                String pre = "DATASPACE";
                String post = "TYPE";
                this.sql = this.sql.replace(pre + " " + this.name + " " + post, pre + " " + escapedDsName + " " + post);
                this.sql = this.sql.replace(pre + " [" + this.name + "] " + post, pre + " " + escapedDsName + " " + post);
            }
            loader.logger.log("      Creating schema '" + dsName + "'... OK\n");
            Result result = session.executeDirectStatement(this.sql);
            if (result.isError()) {
                throw result.getException();
            }
            currentSchema = session.dataspaceStore.schemaManager.findSchema(dsName);
        } else if (loader.isNew()) {
            throw new DataspaceException("Specified dataspace name '" + dsName + "' already exists.");
        }
        session.setCurrentDataspaceName(currentSchema.getObjectName());
        session.setSDSRuntimeSession(false);
        return currentSchema;
    }
}

