/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractDependency;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerializationReader;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactExporter;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactImporter;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestEntity;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class SchemaComparator
extends AbstractSchemaSerializationReader {
    protected boolean ignoreFlobs;
    protected static int DEFAULT_BATCH_SIZE = 100;
    protected String dataspaceName;
    protected boolean artifactGlobal = true;

    public SchemaComparator(Session session, String filename) throws Exception {
        super(session, filename, false, null, null);
        this.cryptMode = 2;
        this.compressed = FilenameUtils.getExtension(filename).equals("gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<ObjectType, List<SchemaComparatorResult>> compareDataspace() throws Exception {
        NameManager.ObjectName initialDataspaceName = this.session.getCurrentDataspaceName();
        boolean isSDS = this.session.isSDSRuntimeSession();
        LinkedHashMap<ObjectType, List<SchemaComparatorResult>> result = new LinkedHashMap<ObjectType, List<SchemaComparatorResult>>();
        try (InputStream input = this.getInputStream();){
            SchemaObjectDef def;
            long startTime = System.currentTimeMillis();
            this.logger.log("\n", true);
            if (!this.verbose) {
                this.logger.log("    Comparing... ", true);
            }
            this.logger.log("    Loading Manifest... ");
            this.manifestDefinition = this.readManifest(input);
            this.logger.log("OK\n");
            this.initEncryption();
            this.readEncryptHeader(input);
            this.compareDependencies(input, result);
            AbstractDataspace ds = (AbstractDataspace)this.session.dataspaceStore.schemaManager.findSchema(this.dataspaceName);
            if (ds != null) {
                this.session.setCurrentDataspaceName(ds.getObjectName());
                this.session.setSDSRuntimeSession(false);
            }
            while ((def = this.readObjectDefinition(input)) != null) {
                try {
                    ObjectType defType = ObjectType.getByCode(def.type);
                    SchemaComparatorResult defCompareResult = def.compare(this, this.session, input);
                    result.putIfAbsent(defType, new ArrayList());
                    ((List)result.get((Object)defType)).add(defCompareResult);
                }
                catch (Exception e) {
                    if (!this.ignoreErrors) throw e;
                    this.logger.logError("    " + e.getMessage() + "\n", false);
                    def.skip(this, this.session, input);
                    continue;
                    return result;
                }
            }
        }
        finally {
            this.session.setCurrentDataspaceName(initialDataspaceName);
            this.session.setSDSRuntimeSession(isSDS);
        }
    }

    private void compareDependencies(InputStream input, Map<ObjectType, List<SchemaComparatorResult>> result) throws Exception {
        ArtifactImporter artifactImporter = new ArtifactImporter(this.session, this.logger);
        ArtifactExporter artifactExporter = new ArtifactExporter(this.session, this.logger);
        for (Map.Entry<ObjectType, List<ManifestEntity>> entry : DumpLoadUtil.getDumpedDependentObjectsInOrder(this.manifestDefinition).entrySet()) {
            List names = entry.getValue().stream().filter(e -> !e.isIgnore()).map(ManifestEntity::getName).collect(Collectors.toList());
            AbstractArtifact.Type artType = AbstractDependency.TYPE_ARTIFACT.get((Object)entry.getKey());
            for (String name : names) {
                this.logger.log("    Comparing dependency " + entry.getKey().getName() + " " + name + "... OK\n");
                byte[] bytes = this.readBytes(input);
                result.putIfAbsent(entry.getKey(), new ArrayList());
                if (artifactImporter.existArtifact(artType, name)) {
                    byte[] thisBytes = artifactExporter.export(artType, new HashSet<String>(Collections.singletonList(name)), true);
                    if (Arrays.equals(bytes, thisBytes)) {
                        result.get((Object)entry.getKey()).add(new SchemaComparatorResult(SchemaComparatorResult.SchemaComparatorStatus.OK, entry.getKey().getCode(), name));
                        continue;
                    }
                    result.get((Object)entry.getKey()).add(new SchemaComparatorResult(SchemaComparatorResult.SchemaComparatorStatus.NOK, entry.getKey().getCode(), name));
                    continue;
                }
                result.get((Object)entry.getKey()).add(new SchemaComparatorResult(SchemaComparatorResult.SchemaComparatorStatus.MISSING_IN_TARGET_DATASPACE, entry.getKey().getCode(), name));
            }
        }
    }

    public int getBatchSize() {
        return DEFAULT_BATCH_SIZE;
    }

    public void setDataspaceName(String dataspaceName) {
        this.dataspaceName = dataspaceName;
    }

    public void setArtifactGlobal(boolean artifactGlobal) {
        this.artifactGlobal = artifactGlobal;
    }

    public void setIgnoreDependencies(boolean ignoreDeps) {
        this.session.sessionData.setIgnoreDependencies(ignoreDeps);
    }

    public void setIgnoreFlobs(boolean ignoreFlobs) {
        this.ignoreFlobs = ignoreFlobs;
    }

    public static class SchemaComparatorResult {
        private SchemaComparatorStatus status;
        private int type;
        private String name;
        private String dumpDefinition;
        private String dataspaceDefinition;
        private Timestamp dumpLastModifiedTimestamp;
        private Timestamp dataspaceLastModifiedTimestamp;

        public SchemaComparatorResult(SchemaComparatorStatus status, int type, String name) {
            this.status = status;
            this.type = type;
            this.name = name;
        }

        public SchemaComparatorResult(SchemaComparatorStatus status, int type, String name, String dumpDefinition, String dataspaceDefinition, Timestamp dumpLastModifiedTimestamp, Timestamp dataspaceLastModifiedTimestamp) {
            this(status, type, name);
            this.dumpDefinition = dumpDefinition;
            this.dataspaceDefinition = dataspaceDefinition;
            this.dumpLastModifiedTimestamp = dumpLastModifiedTimestamp;
            this.dataspaceLastModifiedTimestamp = dataspaceLastModifiedTimestamp;
        }

        public SchemaComparatorStatus getStatus() {
            return this.status;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDumpDefinition() {
            return this.dumpDefinition;
        }

        public String getDataspaceDefinition() {
            return this.dataspaceDefinition;
        }

        public Timestamp getDumpLastModifiedTimestamp() {
            return this.dumpLastModifiedTimestamp;
        }

        public Timestamp getDataspaceLastModifiedTimestamp() {
            return this.dataspaceLastModifiedTimestamp;
        }

        public static enum SchemaComparatorStatus {
            OK("OK"),
            NOK("Not OK"),
            MISSING_IN_TARGET_DATASPACE("Missing in Target"),
            MISSING_IN_SOURCE_DUMP("Missing in Source");

            private final String displayName;

            private SchemaComparatorStatus(String displayName) {
                this.displayName = displayName;
            }

            public String getDisplayName() {
                return this.displayName;
            }
        }
    }
}

