/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.parser.FunctionCreatorWithAlter;
import com.streamscape.ds.parser.ParserRPL;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import java.io.OutputStream;
import java.sql.Timestamp;

public class RplSchemaDef
extends SchemaObjectDef {
    public RplSchemaDef(SchemaObject object) {
        super(object);
    }

    @Override
    public void beforeDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
        super.beforeDump(dumper, session, output);
        this.sql = this.object instanceof RoutineSchema ? FunctionCreatorWithAlter.getFunctionCreateSql(session, ((RoutineSchema)this.object).routines[0]) : session.dataspaceStore.schemaManager.loadObjectDefinition(session, this.object);
        Pair<Timestamp, Timestamp> timestamps = session.dataspaceStore.schemaManager.loadObjectTimestamps(session, this.object);
        if (timestamps != null) {
            this.createdTimestamp = (Timestamp)timestamps.first;
            this.modifiedTimestamp = (Timestamp)timestamps.second;
        }
    }

    @Override
    protected boolean doCompare(Session session, SchemaObjectDef databaseObjectDef) {
        if (this.type == 17 || this.type == 19) {
            String databaseObjectDefSql = databaseObjectDef.getOrLoadObjectDefinition(session);
            ParserRPL.FunctionSyntaxSplitter thisSplitter = new ParserRPL.FunctionSyntaxSplitter(session);
            thisSplitter.reset(this.sql);
            thisSplitter.split();
            ParserRPL.FunctionSyntaxSplitter databaseObjectDefSplitter = new ParserRPL.FunctionSyntaxSplitter(session);
            databaseObjectDefSplitter.reset(databaseObjectDefSql);
            databaseObjectDefSplitter.split();
            return StringUtils.equalsNullTrimSafe(thisSplitter.getComment(), databaseObjectDefSplitter.getComment()) && StringUtils.equalsNullTrimSafe(FunctionCreatorWithAlter.removeDataspaceNameFromCreateSignature(session, thisSplitter.getSignature()), FunctionCreatorWithAlter.removeDataspaceNameFromCreateSignature(session, databaseObjectDefSplitter.getSignature())) && StringUtils.equalsNullTrimSafe(thisSplitter.getRpl(), databaseObjectDefSplitter.getRpl());
        }
        return super.doCompare(session, databaseObjectDef);
    }

    @Override
    public String getOrLoadObjectDefinition(Session session) {
        return session.dataspaceStore.schemaManager.loadObjectDefinition(session, this.object);
    }

    @Override
    public Timestamp getOrLoadObjectLastModifiedTimestamp(Session session) {
        Pair<Timestamp, Timestamp> timestamps = session.dataspaceStore.schemaManager.loadObjectTimestamps(session, this.object);
        if (timestamps != null) {
            return timestamps.second != null ? (Timestamp)timestamps.second : (Timestamp)timestamps.first;
        }
        return null;
    }
}

