/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ObjectType {
    SEMANTIC_TYPE(35, "SDO", "types", false, true),
    PACKAGE(103, "Package", "packages", false, true),
    EVENT_PROTOTYPE(36, "Event Prototype", "event prototypes", false, true),
    CLIENT_FACTORY(104, "Client Factory", "client factories", false, true),
    DB_FACTORY(105, "DB Factory", "db factories", false, true),
    FILE_DESCRIPTOR(106, "File Descriptor", "file descriptors", false, true),
    FLOB(107, "Flob", "flobs", false, false),
    SCHEMA(2, "Schema", "schema", true, true),
    SERVER(27, "Server", "servers", true, true),
    ASPECTS(42, "Aspects", "aspects", true, true),
    FACETS(41, "Facets", "facets", true, true),
    COLLECTION(4, "Collection", "collections", true, true),
    VIEW(5, "View", "views", true, true),
    FULL_TEXT_INDEX(38, "Text Index", "textindexes", true, true),
    SEQUENCE(8, "Sequence", "sequences", true, true),
    FUNCTION(17, "Function", "functions", true, true),
    ACTOR(32, "Actor", "actors", true, true),
    TRIGGER(9, "Trigger", "triggers", true, true),
    TIMER(30, "Timer", "timers", true, true);

    private final int code;
    private final String name;
    private final String optionName;
    private final boolean isBasic;
    private final boolean stats;

    private ObjectType(int code, String name, String optionName, boolean isBasic, boolean stats) {
        this.code = code;
        this.name = name;
        this.optionName = optionName;
        this.isBasic = isBasic;
        this.stats = stats;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public static List<ObjectType> getWithOptions() {
        return ObjectType.list().stream().filter(t -> t.optionName != null).collect(Collectors.toList());
    }

    public static ObjectType getByOptionName(String typeOptionName) {
        return Arrays.stream(ObjectType.values()).filter(t -> typeOptionName.equals(t.optionName)).findFirst().orElse(null);
    }

    public static List<ObjectType> getTypesForStats() {
        return ObjectType.list().stream().filter(t -> t.stats).collect(Collectors.toList());
    }

    public static List<ObjectType> getDependencyTypes() {
        return ObjectType.list().stream().filter(t -> !t.isBasic).collect(Collectors.toList());
    }

    public static List<ObjectType> getBasicTypes() {
        return ObjectType.list().stream().filter(t -> t.isBasic).collect(Collectors.toList());
    }

    public static List<String> getOptions() {
        return ObjectType.list().stream().filter(t -> t.optionName != null).map(t -> t.optionName).collect(Collectors.toList());
    }

    public static ObjectType getByCode(int typeCode) {
        return Arrays.stream(ObjectType.values()).filter(t -> t.code == typeCode).findFirst().orElse(null);
    }

    public static String getNameByCode(int typeCode) {
        ObjectType type = Arrays.stream(ObjectType.values()).filter(t -> t.code == typeCode).findFirst().orElse(null);
        if (type != null) {
            return type.getName();
        }
        return null;
    }

    private static List<ObjectType> list() {
        return Arrays.stream(ObjectType.values()).filter(t -> !t.equals((Object)SCHEMA)).collect(Collectors.toList());
    }
}

