/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class LobUtil {
    public static void writeBlob(SchemaDumper dumper, OutputStream output, BlobDataID blobId) throws Exception {
        if (blobId == null) {
            dumper.writeBytes(output, new byte[0]);
        }
        try (InputStream input = blobId.getBinaryStream(dumper.session);){
            dumper.writeBytes(output, IOUtils.toByteArray(input));
        }
    }

    public static void writeClob(SchemaDumper dumper, OutputStream output, ClobDataID clobId) throws Exception {
        if (clobId == null) {
            dumper.writeBytes(output, new byte[0]);
        }
        try (Reader reader = clobId.getCharacterStream(dumper.session);){
            dumper.writeBytes(output, IOUtils.toByteArray(reader));
        }
    }

    public static void writeFlob(SchemaDumper dumper, OutputStream output, FlobData flob) throws Exception {
        if (flob != null && !dumper.session.dataspaceStore.flobManager.getFlobFileManager().isFlobFileExists(flob)) {
            flob = null;
        }
        if (flob == null) {
            dumper.writeBytes(output, new byte[0]);
            return;
        }
        byte[] bt = dumper.session.dataspaceStore.flobManager.getFlobFileManager().getBytes(flob.getFilename(), flob.getLocation(), 0L, (int)flob.length(dumper.session));
        dumper.writeBytes(output, bt);
    }
}

