/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.CollectionDef;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.lib.file.FileDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class FileTableDef
extends CollectionDef {
    public String source;

    public FileTableDef(FileTableCollection collection) {
        super(collection);
        this.source = collection.getFileTable().getDataSource();
    }

    @Override
    protected long dumpData(SchemaDumper dumper, OutputStream output) throws Exception {
        String filePath = ((FileTableCollection)this.collection).getFileTable().getFileTableSettings(null).getFileName();
        dumper.logger.log("      Processing Data Source '" + filePath + "'...");
        File file = new File(filePath);
        DumpLoadUtil.dumpFile(dumper, output, file);
        dumper.logger.log(" Size(" + DumpLoadUtil.formatFileSize(file.length()) + ")");
        dumper.logger.log(" OK\n");
        return this.collection.getBaseTable().getSampleCount();
    }

    @Override
    protected long loadData(SchemaLoader loader, Session session, InputStream input) throws Exception {
        String filePath = this.getRelativeSourceFile();
        if (filePath == null) {
            return 0L;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return 0L;
        }
        loader.logger.log("      Loading Data Source '" + filePath + "'...");
        DumpLoadUtil.loadFile(loader, input, file);
        loader.logger.log(" Size(" + DumpLoadUtil.formatFileSize(file.length()) + ")");
        loader.logger.log(" OK\n");
        loader.logger.log("      Linking File Table ...");
        FileDescriptor fd = ((FileTableCollection)this.object).getFileTable().getFileDescriptor();
        String delimiter = fd != null ? fd.getDelimiter() : ((FileTableCollection)this.object).getFileTable().getFileTableSettings(null).fs;
        Result res = session.executeDirectStatement("link file table " + this.statementName + " source '" + filePath + ";fs=" + delimiter + "'");
        if (!loader.ignoreErrors && res.isError()) {
            Trace.logException(this, res.getException(), true);
            throw new DataspaceException(res.getException().getMessage());
        }
        Thread.sleep(3000L);
        loader.logger.log(" OK\n");
        return 0L;
    }

    private String getRelativeSourceFile() throws Exception {
        if (this.source == null) {
            return null;
        }
        String[] splittedSource = this.source.split(";");
        if (splittedSource[0].isEmpty()) {
            return null;
        }
        return splittedSource[0];
    }

    @Override
    protected void replaceMemoryModel(int modelType) {
    }
}

