/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestDefinition;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestEntity;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.SizeUnit;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class DumpLoadUtil {
    public static String replaceSchemaQualifiedNameByName(String sql, SchemaObject object) {
        return sql.replace(object.getObjectName().getSchemaQualifiedStatementName(), object.getObjectName().statementName);
    }

    public static void loadFile(SchemaLoader loader, InputStream input, File file) throws Exception {
        FileUtils.writeByteArrayToFile(file, loader.readBytes(input));
    }

    public static void dumpFile(SchemaDumper dumper, OutputStream output, File file) throws Exception {
        dumper.writeBytes(output, FileUtils.readFileToByteArray(file));
    }

    public static String formatNumber(long num) {
        return NumberFormat.getInstance().format(num);
    }

    public static String formatFileSize(long bytes) {
        return SizeUnit.convertToBestFractional(bytes, SizeUnit.BYTES).toStringWithPrecision(2);
    }

    public static String getTypeLogPluralName(ObjectType type) {
        String name = type.getName();
        if (StringUtils.isAllUpperCase((CharSequence)name)) {
            return name;
        }
        if ((name = WordUtils.capitalizeFully((String)name)).endsWith("x")) {
            return name + "es";
        }
        if (name.endsWith("y")) {
            return StringUtils.removeEndIgnoreCase((String)name, (String)"y") + "ies";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return name + "s";
    }

    public static List<Object[]> describeDataspaceColumns(SchemaLoader loader) throws Exception {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        ManifestDefinition definition = loader.loadManifest();
        long fileSize = loader.getFileSize();
        res.add(new Object[]{"Name", loader.getFilename()});
        res.add(new Object[]{"Size", DumpLoadUtil.formatFileSize(fileSize)});
        res.add(new Object[]{"Created On", DumpLoadUtil.formatDate(definition.getCreationTime())});
        res.add(new Object[]{"Dataspace Type", definition.getDataspaceType()});
        res.add(new Object[]{"Dataspace Name", definition.getDataspaceName()});
        res.add(new Object[]{"Version", definition.getVersion()});
        res.add(new Object[]{"Password Protected", String.valueOf(definition.isPasswordProtected())});
        res.add(new Object[]{"Domain Name", definition.getDomainName()});
        res.add(new Object[]{"Node Name", definition.getNodeName()});
        for (ObjectType type : ObjectType.getTypesForStats()) {
            List entities = definition.getTypeEntities(type);
            if (entities == null) {
                entities = Collections.EMPTY_LIST;
            }
            if (type.equals((Object)ObjectType.COLLECTION)) {
                if (entities.isEmpty()) continue;
                Map<String, List<ManifestEntity>> index = entities.stream().collect(Collectors.groupingBy(e -> (String)e.getProperty(ManifestEntity.COLLECTION_TYPE_PROP)));
                for (String colTypeName : index.keySet()) {
                    String title = "";
                    try {
                        CollectionType colType = CollectionType.valueOf(colTypeName);
                        title = DumpLoadUtil.spacify(colType.getCollectionClass().getSimpleName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    res.add(new Object[]{title + " Collections", ManifestEntity.toNames(index.get(colTypeName))});
                }
                continue;
            }
            List<String> names = type.equals((Object)ObjectType.PACKAGE) ? entities.stream().map(e -> {
                Object item = e.getName();
                if (e.getProperty(ManifestEntity.JARS_PROP) != null) {
                    List jars = (List)e.getProperty(ManifestEntity.JARS_PROP);
                    item = (String)item + "(" + String.join((CharSequence)",", jars) + ")";
                }
                return item;
            }).collect(Collectors.toList()) : ManifestEntity.toNames(entities);
            res.add(new Object[]{DumpLoadUtil.getTypeLogPluralName(type), names});
        }
        return res;
    }

    public static String spacify(String str) {
        return str.replaceAll("(.)([A-Z])", "$1 $2");
    }

    protected static String formatDate(long time) {
        return AbstractOperation.formatDate(time);
    }

    protected static List<SchemaObject> getSchemaObjects(Session session, AbstractDataspace dataspace, ObjectType type) {
        ArrayList<SchemaObject> objects = new ArrayList<SchemaObject>();
        Iterator it = session.dataspaceStore.schemaManager.dataspaceObjectIterator(dataspace.getObjectName().name, type.getCode());
        while (it.hasNext()) {
            objects.add((SchemaObject)it.next());
        }
        return objects;
    }

    public static LinkedHashMap<ObjectType, List<ManifestEntity>> getDumpedDependentObjectsInOrder(ManifestDefinition manifestDefinition) {
        LinkedHashMap<ObjectType, List<ManifestEntity>> result = new LinkedHashMap<ObjectType, List<ManifestEntity>>();
        for (ObjectType type : ObjectType.getDependencyTypes()) {
            List<ManifestEntity> entities = manifestDefinition.getTypeEntities(type);
            if (entities == null || entities.isEmpty()) continue;
            result.put(type, entities);
        }
        return result;
    }
}

