/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.utils.schemaserialization.AbstractDependency;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactImporter;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestEntity;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DependencyLoader
extends AbstractDependency {
    private SchemaLoader loader;
    private ArtifactImporter importer;

    public DependencyLoader(SchemaLoader loader) {
        this.loader = loader;
        this.importer = new ArtifactImporter(loader.session, loader.logger);
    }

    public Map<ObjectType, Integer> load(InputStream input) throws Exception {
        HashMap<ObjectType, Integer> stats = new HashMap<ObjectType, Integer>();
        boolean ignoreErrors = this.loader.isIgnoreErrors();
        for (Map.Entry<ObjectType, List<ManifestEntity>> entry : DumpLoadUtil.getDumpedDependentObjectsInOrder(this.loader.manifestDefinition).entrySet()) {
            ObjectType type = entry.getKey();
            List<ManifestEntity> entities = entry.getValue();
            for (ManifestEntity entity : entities) {
                if (!entity.isIgnore()) continue;
                this.loader.logger.log("    Loading " + type.getName() + " " + entity.getName() + "... OK\n");
            }
            stats.put(type, entities.size());
            List names = entities.stream().filter(e -> !e.isIgnore()).map(ManifestEntity::getName).collect(Collectors.toList());
            if (names.isEmpty()) continue;
            AbstractArtifact.Type artType = (AbstractArtifact.Type)((Object)TYPE_ARTIFACT.get((Object)type));
            for (String name : names) {
                byte[] bts = this.loader.readBytes(input);
                if (!this.loader.isAvailableObjectType(type)) {
                    this.loader.logger.log("    Skipping object " + name + " of type " + type.getName() + "... OK\n");
                    continue;
                }
                try {
                    if (!this.loader.isMerge()) {
                        if (this.importer.existArtifact(artType, name)) {
                            String message = type.getName() + " '" + name + "' already exists.";
                            throw new DataspaceException(message);
                        }
                        this.loadArtifact(artType, bts, name, null, type.getName());
                        continue;
                    }
                    if (this.importer.existArtifact(artType, name)) {
                        if (artType.equals((Object)AbstractArtifact.Type.SDO)) continue;
                        if (artType.equals((Object)AbstractArtifact.Type.PACKAGE)) {
                            this.loadArtifact(artType, bts, name, null, type.getName());
                            continue;
                        }
                        this.loader.logger.log("      Dropping " + type.getName() + " '" + name + "'... ");
                        this.importer.dropArtifact(artType, name);
                        this.loader.logger.log("OK\n");
                        this.loadArtifact(artType, bts, name, null, type.getName());
                        continue;
                    }
                    this.loadArtifact(artType, bts, name, null, type.getName());
                }
                catch (Exception e2) {
                    if (ignoreErrors) {
                        this.loader.logger.logError(e2.getMessage(), false);
                        continue;
                    }
                    throw e2;
                }
            }
        }
        return stats;
    }

    private void loadArtifact(AbstractArtifact.Type artType, byte[] bts, String name, LinkedHashSet<String> rawNamesTo, String typeName) throws Exception {
        this.loader.logger.log("    Loading " + typeName + " " + name + "... ");
        this.importer.load(artType, bts, new LinkedHashSet<String>(Collections.singletonList(name)), null, this.loader.ignoreErrors, !this.loader.artifactGlobal);
        this.loader.logger.log("OK\n");
    }
}

