/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.schema.server.web.WebServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractDependency;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.artifact.AbstractArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactExporter;
import com.streamscape.ds.utils.schemaserialization.artifact.ArtifactFactory;
import com.streamscape.ds.utils.schemaserialization.artifact.BaseArtifact;
import com.streamscape.ds.utils.schemaserialization.artifact.PackageArtifact;
import com.streamscape.lib.analyzer.EventAnalyzer;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyDumper
extends AbstractDependency {
    private Map<ObjectType, Set<BaseArtifact>> artifacs = new LinkedHashMap<ObjectType, Set<BaseArtifact>>();
    private Map<ObjectType, Set<SchemaObject>> dataspaceDeps = new LinkedHashMap<ObjectType, Set<SchemaObject>>();
    private SchemaDumper dumper;

    public DependencyDumper(SchemaDumper dumper) {
        this.dumper = dumper;
        for (ObjectType type : ObjectType.getDependencyTypes()) {
            this.artifacs.put(type, new LinkedHashSet());
        }
    }

    public <T extends SchemaObject> void add(Session session, List<T> objects) throws Exception {
        for (SchemaObject obj : objects) {
            FileTableCollection ft;
            FileDescriptor fileDescriptor;
            if (obj instanceof WebServerObject || obj instanceof NoSqlServerObject) {
                ServerObject ws = (ServerObject)obj;
                String clientName = ws.getFactoryType() + "." + ws.getFactoryName();
                this.addArtifact(ObjectType.CLIENT_FACTORY, clientName);
                if ("HTTP".equals(ws.getFactoryType())) continue;
                if (AbstractArtifact.existPackage("client." + ws.getFactoryType())) {
                    this.addArtifact(ObjectType.PACKAGE, "client." + ws.getFactoryType());
                    continue;
                }
                this.dumper.logger.log("\n  Package client." + ws.getFactoryType() + " doesn't exist.", false);
                continue;
            }
            if (obj instanceof VirtualServerObject) {
                VirtualServerObject vs = (VirtualServerObject)obj;
                String clientName = vs.getFactoryType() + "." + vs.getFactoryName();
                this.addArtifact(ObjectType.DB_FACTORY, clientName);
                continue;
            }
            if (obj instanceof FileTableCollection && (fileDescriptor = (ft = (FileTableCollection)obj).getFileTable().getFileDescriptor()) != null) {
                this.addArtifact(ObjectType.FILE_DESCRIPTOR, "FileDescriptor." + ft.getFileTable().getFileDescriptorName());
                for (FileDescriptorRecord record : fileDescriptor.getRecords()) {
                    if (!(record instanceof RecordTypeDefinition)) continue;
                    this.addSemanticType(((RecordTypeDefinition)record).getSemanticType());
                }
            }
            NameManager.ObjectName name = obj.getObjectName();
            boolean withLocal = obj.getObjectType() == 17;
            Map<NameManager.ObjectName, List<NameManager.ObjectName>> refs = session.dataspaceStore.schemaManager.getCascadingReferencesFromObject(obj, withLocal, true, 1, name.schema);
            for (NameManager.ObjectName dep : refs.keySet()) {
                ObjectType depType = ObjectType.getByCode(dep.type);
                SchemaObject depObject = session.dataspaceStore.schemaManager.getSchemaObject(dep);
                if (ObjectType.SEMANTIC_TYPE.equals((Object)depType)) {
                    this.addSemanticType(dep.name);
                    continue;
                }
                if (ObjectType.EVENT_PROTOTYPE.equals((Object)depType)) {
                    try {
                        boolean isSystem;
                        EventDatagram event = RuntimeContext.getInstance().getEventDatagramFactory().createEvent(dep.name);
                        Class payloadClass = new EventAnalyzer(event).getPayLoadClass();
                        if (payloadClass != null) {
                            this.addSemanticType(EventAnalyzer.resolveTypeName(payloadClass));
                        }
                        if (isSystem = AbstractDSLOperation.isSystemEvent(event.getEventId()) || AbstractDSLOperation.isPredefinedEvent(event.getEventId())) continue;
                        this.addArtifact(ObjectType.EVENT_PROTOTYPE, dep.name);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (dep.type == 25) {
                    this.addDataspaceDep(ObjectType.FUNCTION, depObject);
                    continue;
                }
                if (!ObjectType.ASPECTS.equals((Object)depType) && !ObjectType.FACETS.equals((Object)depType)) continue;
                this.addDataspaceDep(depType, depObject);
            }
        }
    }

    private void addDataspaceDep(ObjectType type, SchemaObject name) {
        if (!this.dumper.isAvailableObjectType(type)) {
            return;
        }
        if (!this.dataspaceDeps.containsKey((Object)type)) {
            this.dataspaceDeps.put(type, new LinkedHashSet());
        }
        this.dataspaceDeps.get((Object)type).add(name);
    }

    private void addSemanticType(String rawName) {
        SemanticType type = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(rawName);
        if (type != null && !type.isSystem()) {
            this.addArtifact(ObjectType.SEMANTIC_TYPE, rawName);
        }
    }

    public void dump(OutputStream output) throws Exception {
        ArtifactExporter exporter = new ArtifactExporter(this.dumper.session, this.dumper.logger);
        for (ObjectType type : this.artifacs.keySet()) {
            List names = this.artifacs.get((Object)type).stream().filter(a -> !a.isIgnore()).map(BaseArtifact::getName).collect(Collectors.toList());
            if (names.isEmpty()) continue;
            this.dumper.logger.log("    Processing " + type.getName() + " " + String.join((CharSequence)",", names) + "...");
            for (String name : names) {
                this.dumper.writeBytes(output, exporter.export((AbstractArtifact.Type)((Object)TYPE_ARTIFACT.get((Object)type)), new HashSet<String>(Collections.singletonList(name)), this.dumper.ignoreErrors));
            }
            this.dumper.logger.log(" OK\n");
        }
    }

    private void addArtifact(ObjectType type, String name) {
        this.addArtifact(type, name, false);
    }

    private void addArtifact(ObjectType type, String name, boolean ignore) {
        if ((type.equals((Object)ObjectType.PACKAGE) || type.equals((Object)ObjectType.SEMANTIC_TYPE)) && !this.dumper.getAvailableObjectTypes().contains((Object)type)) {
            return;
        }
        BaseArtifact artifact = ArtifactFactory.get(type, name, ignore);
        this.artifacs.get((Object)type).add(artifact);
    }

    public Map<ObjectType, Set<BaseArtifact>> getArtifacs() {
        if (this.artifacs.get((Object)ObjectType.PACKAGE) != null) {
            Set<BaseArtifact> arts = this.artifacs.get((Object)ObjectType.PACKAGE);
            for (BaseArtifact art : arts) {
                PackageArtifact pkg = (PackageArtifact)art;
                for (String typeName : pkg.getSDOs()) {
                    this.addArtifact(ObjectType.SEMANTIC_TYPE, typeName, true);
                }
            }
        }
        return this.artifacs;
    }

    public Map<ObjectType, Set<SchemaObject>> getDataspaceDeps() {
        return this.dataspaceDeps;
    }

    public Map<ObjectType, Integer> getArtifactStats() {
        LinkedHashMap<ObjectType, Integer> stats = new LinkedHashMap<ObjectType, Integer>();
        this.artifacs.forEach((type, names) -> stats.put((ObjectType)((Object)type), names.size()));
        return stats;
    }

    public void addPackages(List<String> packages) {
        if (packages == null) {
            return;
        }
        for (String packageName : packages) {
            this.addArtifact(ObjectType.PACKAGE, packageName);
        }
    }
}

