/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.io.rowio.DumperRowOutputBinary;
import com.streamscape.ds.io.rowio.LoaderRowInputBinary;
import com.streamscape.ds.io.rowio.RowInputBinaryDecode;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerializationReader;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class CollectionUtil {
    public static long readData(SchemaLoader loader, SchemaObjectDef def, InputStream input, Collection collection) throws Exception {
        Session session = loader.session;
        LoaderRowInputBinary rowInput = new LoaderRowInputBinary(loader.session, new byte[256]);
        rowInput.setIgnoreFlobs(loader.ignoreFlobs);
        Table table = collection.getBaseTable();
        PersistentStore store = table.getRowStore(session);
        ArrayList<Object[]> insertedRows = new ArrayList<Object[]>();
        long cnt = 0L;
        long limit = loader.limit;
        int batchRowCounter = 0;
        while (limit <= 0L || cnt <= limit) {
            try {
                if (!session.isTransaction) {
                    session.startTransaction();
                }
                int rowSize = loader.doReadInt(input);
                if (rowSize == -1) break;
                rowInput.resetRow(0, rowSize + 4);
                loader.doRead(input, rowInput.getBuffer(), 4, rowSize);
                Object[] data = rowInput.readData(table.colTypes);
                table.insertSingleRow(session, store, data, null);
                StatementDML.performIntegrityChecks(session, table, null, data, null);
                insertedRows.add(data);
                ++cnt;
                if (session.dataspaceStore.isReferentialIntegrity()) {
                    int size = table.fkConstraints.length;
                    for (int i = 0; i < size; ++i) {
                        table.fkConstraints[i].checkInsert(session, table, data, true);
                    }
                }
                if (++batchRowCounter < loader.getBatchSize()) continue;
                batchRowCounter = 0;
                session.commit(false);
                table.dfetchMonitor.rowsInserted(session, insertedRows);
                insertedRows.clear();
            }
            catch (Throwable error) {
                if (loader.ignoreErrors) {
                    loader.logger.logError(error.getMessage(), false);
                    continue;
                }
                session.commit(false);
                throw error;
            }
        }
        if (session.isTransaction) {
            session.commit(false);
        }
        table.dfetchMonitor.rowsInserted(session, insertedRows);
        return cnt;
    }

    public static long writeData(SchemaDumper dumper, OutputStream output, Collection collection) throws Exception {
        Row row;
        long cnt;
        DumperRowOutputBinary rowOut = new DumperRowOutputBinary(dumper.session, 256, 8);
        rowOut.setIgnoreFlobs(!dumper.isAvailableObjectType(ObjectType.FLOB));
        Table table = collection.getBaseTable();
        RowIterator iter = table.rowIterator(dumper.session);
        long limit = dumper.limit;
        for (cnt = 0L; iter.hasNext() && (limit <= 0L || cnt < limit) && (row = iter.getNextRow()) != null; ++cnt) {
            rowOut.reset();
            rowOut.writeData(row, collection.getBaseTable().colTypes);
            dumper.doWriteInt(output, rowOut.getOutputStream().size());
            dumper.doWrite(output, rowOut.getOutputStream().getBuffer(), rowOut.getOutputStream().size());
        }
        CollectionUtil.writeEnd(dumper, output);
        return cnt;
    }

    public static void writeEnd(SchemaDumper dumper, OutputStream output) throws IOException {
        dumper.doWriteInt(output, -1);
    }

    /*
     * Unable to fully structure code
     */
    public static void skipData(AbstractSchemaSerializationReader loader, InputStream input, Collection collection) throws Exception {
        block9: {
            if (collection != null) {
                session = loader.session;
                rowInput = new RowInputBinaryDecode(session.dataspaceStore.dataspaceLogger.getCrypto(), new byte[256]);
                table = collection.getBaseTable();
                while (true) {
                    try {
                        block3: while (true) {
                            rowSize = loader.doReadInt(input);
                            if (rowSize != -1) {
                                rowInput.resetRow(0, rowSize + 4);
                                loader.doRead(input, rowInput.getBuffer(), 4, rowSize);
                                data = rowInput.readData(table.colTypes);
                                if (!table.hasLobColumn()) continue;
                                j = 0;
                                while (true) {
                                    if (j < table.columnCount) ** break;
                                    continue block3;
                                    currentType = table.colTypes[j];
                                    if ((currentType.isLobType() || currentType.isFlobType()) && data[j] != null) {
                                        length = loader.doReadInt(input);
                                        input.skip(length);
                                    }
                                    ++j;
                                }
                            }
                            break block9;
                            break;
                        }
                    }
                    catch (Throwable var6_8) {
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                rowSize = loader.doReadInt(input);
                if (rowSize == -1) break;
                loader.doRead(input, new byte[4 + rowSize], 4, rowSize);
            }
        }
    }
}

