/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerializationReader;
import com.streamscape.ds.utils.schemaserialization.CollectionUtil;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.SchemaComparator;
import com.streamscape.ds.utils.schemaserialization.SchemaDumper;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import java.io.InputStream;
import java.io.OutputStream;

public class CollectionDef
extends SchemaObjectDef {
    public transient Collection collection;

    public CollectionDef(Collection collection) {
        super(collection);
        this.collection = collection;
        CharSequence[] sqls = ((Collection)this.object).getSQL(new OrderedHashSet(), new OrderedHashSet());
        String sqlJoined = String.join((CharSequence)";\n", sqls);
        this.sql = sqlJoined.replace(this.object.getObjectName().getSchemaQualifiedStatementName(), this.object.getObjectName().getStatementName());
        MemoryModel model = collection.getMemoryModel();
        if (model != null) {
            this.parameters.put("memoryModel", model.name());
        }
    }

    public SchemaObject load(SchemaLoader loader, Session session, InputStream input, int memoryModel, String newName) throws Exception {
        this.replaceName(newName);
        this.replaceMemoryModel(memoryModel);
        return this.load(loader, session, input);
    }

    @Override
    public void afterLoad(SchemaLoader loader, Session session, InputStream input) throws Exception {
        super.afterLoad(loader, session, input);
        if (loader.noData) {
            CollectionUtil.skipData(loader, input, (Collection)this.object);
            loader.logger.log(" Skipped");
        } else {
            this.loadData(loader, session, input);
        }
    }

    protected long loadData(SchemaLoader loader, Session session, InputStream input) throws Exception {
        if (loader.isReplaceWithTruncate()) {
            loader.logger.log("      Truncate before data loading... ");
            session.executeDirectStatement("truncate collection " + this.object.getObjectName().statementName);
            loader.logger.log(" OK\n");
        }
        loader.logger.log("      Loading data... ");
        long entries = CollectionUtil.readData(loader, this, input, (Collection)this.object);
        loader.addDataLoadStats((Collection)this.object, entries);
        loader.logger.log(" Entries(" + DumpLoadUtil.formatNumber(entries) + ") OK\n");
        return entries;
    }

    @Override
    public void beforeDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
        super.beforeDump(dumper, session, output);
    }

    @Override
    public void afterDump(SchemaDumper dumper, Session session, OutputStream output) throws Exception {
        super.afterDump(dumper, session, output);
        if (dumper.isNoData()) {
            CollectionUtil.writeEnd(dumper, output);
        } else {
            this.dumpData(dumper, output);
        }
    }

    protected long dumpData(SchemaDumper dumper, OutputStream output) throws Exception {
        dumper.logger.log("    Processing Collection Data '" + this.object.getObjectName().name + "'...");
        if (dumper.progressMonitor != null) {
            dumper.progressMonitor.wakeUp();
        }
        long entriesNumber = CollectionUtil.writeData(dumper, output, this.collection);
        dumper.addDataLoadStats(this.collection, entriesNumber);
        if (dumper.progressMonitor != null) {
            dumper.progressMonitor.sleep();
        }
        this.parameters.put("entries", entriesNumber);
        dumper.logger.log(" Entries(" + entriesNumber + ")");
        dumper.logger.log(" OK\n");
        return entriesNumber;
    }

    @Override
    protected SchemaObject mergeAction(SchemaLoader loader, Session session, InputStream input) throws Exception {
        this.mergeSkip(loader);
        return null;
    }

    @Override
    public void skip(AbstractSchemaSerializationReader loader, Session session, InputStream input) throws Exception {
        super.skip(loader, session, input);
        if (this.object != null) {
            CollectionUtil.skipData(loader, input, (Collection)this.object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaComparator.SchemaComparatorResult compare(AbstractSchemaSerializationReader comparator, Session session, InputStream input) throws Exception {
        try {
            SchemaComparator.SchemaComparatorResult schemaComparatorResult = super.compare(comparator, session, input);
            return schemaComparatorResult;
        }
        finally {
            CollectionUtil.skipData(comparator, input, (Collection)this.object);
        }
    }

    protected void replaceName(String name) {
        if (name == null) {
            return;
        }
        this.sql = this.sql.replace(this.statementName, "[" + name + "]");
        this.name = name;
        this.statementName = "[" + name + "]";
    }

    protected void replaceMemoryModel(int modelType) {
        String newModelName;
        if (modelType == -1) {
            return;
        }
        if (this.parameters.get("memoryModel") != null && (newModelName = Tokens.getKeyword(modelType)) != null) {
            this.sql = this.sql.replace("CREATE " + String.valueOf(this.parameters.get("memoryModel")), "CREATE " + newModelName);
            this.parameters.put("memoryModel", newModelName);
        }
    }

    public String getDumpSqlFroObject(SchemaObject o) {
        return this.object.getSQL();
    }
}

