/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionData;
import com.streamscape.ds.utils.schemaserialization.AbstractSchemaSerialization;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestDefinition;
import com.streamscape.slex.file.SLFileInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

public abstract class AbstractSchemaSerializationReader
extends AbstractSchemaSerialization {
    public AbstractSchemaSerializationReader(Session session, String filename, boolean compressed, List<String> includeObjects, List<String> excludeObjects) throws Exception {
        super(session, filename, compressed, includeObjects, excludeObjects);
    }

    protected String readString(InputStream input) throws Exception {
        return new String(this.readBytes(input));
    }

    protected byte[] readBytes(InputStream input) throws Exception {
        int length = this.doReadInt(input);
        byte[] buf = new byte[length];
        this.doRead(input, buf, length);
        return buf;
    }

    protected int doReadInt(InputStream input) throws Exception {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.doRead(input);
        if ((ch1 | (ch2 = this.doRead(input)) | (ch3 = this.doRead(input)) | (ch4 = this.doRead(input))) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    protected int doRead(InputStream input) throws Exception {
        int i = input.read();
        if (!this.isIgnoreEnc() && this.passwordProtected) {
            byte[] bytes = this.cipher.update(new byte[]{(byte)i}, 0, 1);
            return bytes[0];
        }
        return i;
    }

    protected void doRead(InputStream input, byte[] ibuf, int length) throws Exception {
        input.read(ibuf, 0, length);
        if (!this.isIgnoreEnc() && this.passwordProtected) {
            byte[] encBuf = this.cipher.update(ibuf, 0, length);
            System.arraycopy(encBuf, 0, ibuf, 0, ibuf.length);
        }
    }

    protected void doRead(InputStream input, byte[] b, int off, int length) throws Exception {
        byte[] outb = new byte[length];
        this.doRead(input, outb, length);
        for (int i = 0; i < length; ++i) {
            b[off + i] = outb[i];
        }
    }

    protected InputStream getInputStream() throws Exception {
        InputStream input = null;
        try {
            input = SessionData.createFileInputStream(this.session, this.filename, false, true, null);
            if (input instanceof SLFileInputStream) {
                ((SLFileInputStream)input).setVerbose(false);
            }
            if (this.compressed) {
                if (input instanceof SLFileInputStream) {
                    input = new BufferedInputStream(input);
                }
                input = new GZIPInputStream(input);
            }
            input = new BufferedInputStream(input);
        }
        catch (Exception exception) {
            if (input != null) {
                input.close();
            }
            throw exception;
        }
        return input;
    }

    protected void readEncryptHeader(InputStream input) throws Exception {
        if (this.passwordProtected) {
            byte[] bytes = new byte["ST_AES".length()];
            this.doRead(input, bytes, "ST_AES".length());
            if (bytes == null || !new String(bytes).equals("ST_AES")) {
                throw new DataspaceException("Wrong password");
            }
        }
    }

    protected SchemaObjectDef readObjectDefinition(InputStream input) throws Exception {
        try {
            return (SchemaObjectDef)this.deserialize(this.readString(input));
        }
        catch (EOFException error) {
            return null;
        }
    }

    public ManifestDefinition loadManifest() throws Exception {
        try (InputStream input = this.getInputStream();){
            ManifestDefinition manifestDefinition = this.readManifest(input);
            return manifestDefinition;
        }
    }

    protected ManifestDefinition readManifest(InputStream input) throws Exception {
        this.setIgnoreEnc(true);
        ManifestDefinition def = (ManifestDefinition)this.deserialize(this.readString(input));
        this.passwordProtected = def.isPasswordProtected();
        this.setIgnoreEnc(false);
        return def;
    }
}

