/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils.schemaserialization;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.parser.FunctionCreatorWithAlter;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.ObjectType;
import com.streamscape.ds.utils.schemaserialization.SchemaObjectDef;
import com.streamscape.ds.utils.schemaserialization.manifest.ManifestDefinition;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AbstractSchemaSerialization {
    protected String filename;
    protected boolean noData;
    protected boolean compressed;
    protected Session session;
    protected String password;
    protected boolean passwordProtected;
    protected int cryptMode;
    protected boolean ignoreEnc;
    protected ProgressMonitor progressMonitor;
    protected ManifestDefinition manifestDefinition;
    protected Set<ObjectType> availableObjectTypes = new HashSet<ObjectType>();
    protected boolean verbose;
    protected boolean ignoreErrors;
    protected Cipher cipher;
    protected static final int DEFAULT_VERSION = 1;
    protected static final int COLLECTION_DATA_END = -1;
    protected static final String AES_AUTH_KEY = "ST_AES";
    protected static final byte[] MAGIC = "DMP".getBytes();
    protected static final String FILE_EXT = "dmp";
    protected static final String COMPRESSED_FILE_EXT = "gz";
    protected static final String INDENT = "    ";
    protected long limit;
    protected Logger logger;
    protected Map<Collection, Long> dataLoadStats = new LinkedHashMap<Collection, Long>();

    public AbstractSchemaSerialization(Session session, String filename, boolean compressed, List<String> includeObjects, List<String> excludeObjects) throws Exception {
        this.filename = filename;
        this.compressed = compressed;
        this.session = session;
        this.logger = new Logger();
        Set<ObjectType> includeObjectTypes = this.retrieveObjectTypes(includeObjects);
        Set<ObjectType> excludeObjectsTypes = this.retrieveObjectTypes(excludeObjects);
        List<ObjectType> types = ObjectType.getWithOptions();
        if (includeObjectTypes.isEmpty()) {
            includeObjectTypes = new HashSet<ObjectType>(types);
        }
        for (ObjectType type : types) {
            if (!includeObjectTypes.contains((Object)type) || excludeObjectsTypes.contains((Object)type)) continue;
            this.availableObjectTypes.add(type);
        }
        this.availableObjectTypes.add(ObjectType.SCHEMA);
    }

    protected void initEncryption() throws Exception {
        if (!this.passwordProtected) {
            return;
        }
        byte[] salt = "ASNFHSKU".getBytes();
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(this.password.toCharArray(), salt, 10000, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec skey = new SecretKeySpec(tmp.getEncoded(), "AES");
        byte[] iv = "RYENDHATRUJGNDGS".getBytes();
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        Cipher ci = Cipher.getInstance("AES/CTR/NoPadding");
        ci.init(this.cryptMode, (Key)skey, ivspec);
        this.cipher = ci;
    }

    private Set<ObjectType> retrieveObjectTypes(List<String> names) {
        HashSet<ObjectType> res = new HashSet<ObjectType>();
        if (names == null) {
            return res;
        }
        for (String optionName : names) {
            if (optionName.trim().equals("*")) {
                res.clear();
                break;
            }
            if (optionName.trim().equals("deps") || optionName.trim().equals("dependencies")) {
                res.addAll(ObjectType.getDependencyTypes());
                continue;
            }
            ObjectType type = ObjectType.getByOptionName(optionName);
            if (type == null) {
                throw new DataspaceException("Wrong object type: " + optionName);
            }
            res.add(type);
        }
        return res;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    protected List<SchemaObject> getFilteredSchemaObjects(AbstractDataspace dataspace, ObjectType type) {
        if (this.isAvailableObjectType(type)) {
            return DumpLoadUtil.getSchemaObjects(this.session, dataspace, type);
        }
        return Collections.emptyList();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIgnoreErrors(boolean value) {
        this.ignoreErrors = value;
    }

    public boolean isIgnoreEnc() {
        return this.ignoreEnc;
    }

    public void setIgnoreEnc(boolean ignoreEnc) {
        this.ignoreEnc = ignoreEnc;
    }

    public long getFileSize() {
        try {
            FileSystem fileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(this.session, this.filename);
            return fileSystem.getSize(this.filename);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected void dropSchemaObject(String name, int typeCode, boolean dropOption) {
        String sql = "drop " + ObjectType.getNameByCode(typeCode) + " " + name;
        if (dropOption) {
            sql = sql + " cascade";
        }
        Result res = this.session.executeDirectStatement(sql);
        if (!this.ignoreErrors && res.isError()) {
            throw new DataspaceException(res.getException().getMessage());
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNoData(boolean noData) {
        this.noData = noData;
    }

    protected void initProgressMonitor() throws FabricException {
        this.progressMonitor = new ProgressMonitor();
        this.progressMonitor.start();
        this.progressMonitor.sleep();
    }

    protected void stopProgressMonitor() {
        this.progressMonitor.stop();
    }

    public String serialize(Object res) throws SerializerException {
        return DataspaceStoreManager.getRuntimeContext().getJSONSerializerFactory().getDefaultSerializer().serialize(res);
    }

    public Object deserialize(String res) throws SerializerException {
        return DataspaceStoreManager.getRuntimeContext().getJSONSerializerFactory().getDefaultSerializer().deserialize(res);
    }

    public boolean isNoData() {
        return this.noData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result executeObjectStatement(SchemaObjectDef def) {
        if (def.type == 4) {
            String[] sqls;
            Result result = null;
            this.session.startTransaction();
            for (String subSql : sqls = def.sql.split(";\n")) {
                boolean isCreatingDataspaceLike = this.session.isCreatingDataspaceLike;
                this.session.isCreatingDataspaceLike = true;
                try {
                    result = this.session.executeDirectStatement(subSql);
                }
                finally {
                    this.session.isCreatingDataspaceLike = isCreatingDataspaceLike;
                }
                if (!result.isError()) continue;
                this.session.rollback(false);
                return result;
            }
            this.session.commit(false);
            return result;
        }
        if (def.type == 17 || def.type == 19) {
            return FunctionCreatorWithAlter.createFunctionDeclaration(this.session, def.sql, null);
        }
        return this.session.executeDirectStatement(def.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result executeObjectStatement2(SchemaObjectDef def) {
        if (def.type == 17 || def.type == 19) {
            boolean isCreatingDataspaceLike = this.session.isCreatingDataspaceLike;
            this.session.isCreatingDataspaceLike = true;
            try {
                Result result = FunctionCreatorWithAlter.alterFunction(this.session, def.sql, null);
                return result;
            }
            finally {
                this.session.isCreatingDataspaceLike = isCreatingDataspaceLike;
            }
        }
        return Result.updateNoResult;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public String getFilename() {
        return this.filename;
    }

    public Set<ObjectType> getAvailableObjectTypes() {
        return this.availableObjectTypes;
    }

    public boolean isAvailableObjectType(ObjectType type) {
        return this.availableObjectTypes.contains((Object)type);
    }

    public void addDataLoadStats(Collection col, long amount) {
        this.dataLoadStats.put(col, amount);
    }

    public void flushDataLoadStats() {
        this.dataLoadStats = new LinkedHashMap<Collection, Long>();
    }

    protected String dateNowFormatted() {
        return DataspaceDateTime.getSqlTimestampString(System.currentTimeMillis(), this.session.getTimeZone());
    }

    public class Logger {
        public void raiseMessage(String message, boolean error) throws FabricException {
            SLMessage slm = new SLMessage(message, !error, AbstractSchemaSerialization.this.session.getComponentName(), AbstractSchemaSerialization.this.session.getSLSessionName());
            AbstractOperation.raiseSLMessage(slm);
        }

        public void raiseMessage(String message) throws FabricException {
            this.raiseMessage(message, false);
        }

        public void log(String message, boolean ignoreVerbose) throws Exception {
            this.log(message, ignoreVerbose, false);
        }

        private void log(String message, boolean ignoreVerbose, boolean error) throws Exception {
            if (ignoreVerbose || AbstractSchemaSerialization.this.verbose) {
                this.raiseMessage(message, error);
            }
        }

        public void log(String message) throws Exception {
            this.log(message, false);
        }

        public void logError(String message, boolean ignoreVerbose) throws Exception {
            this.log(message, ignoreVerbose, true);
        }

        public void raiseErrorMessage(String message) throws Exception {
            AbstractOperation.raiseSLMessage(new SLMessage(message, false, AbstractSchemaSerialization.this.session.getComponentName(), AbstractSchemaSerialization.this.session.getSLSessionName()));
        }
    }

    protected class ProgressMonitor
    extends MonitorWorker {
        public ProgressMonitor() throws FabricException {
            super("FSYS:SLANG.ProgressMonitor", "Monitors a current progress of Dump/Load operation.", 1000L);
        }

        @Override
        protected void doExecute() throws FabricException {
            AbstractSchemaSerialization.this.logger.raiseMessage(".");
        }
    }
}

