/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.ds.utils.WindowCollection;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;

public class TableSlidingTimeWindowChecker
implements Runnable {
    protected AbstractDataspace dataspace;
    protected AbstractCollection collection;
    protected CollectionWindowType windowType;
    protected long windowSizeInMillis;
    protected long windowCheckIntervalInMillis;
    protected int createdColumnIndex;
    protected RowMetaData metaData;
    protected Type[] types;

    public TableSlidingTimeWindowChecker(AbstractDataspace dataspace, AbstractCollection collection, long windowSizeInMillis, long windowCheckIntervalInMillis, CollectionWindowType windowType) {
        this.dataspace = dataspace;
        this.collection = collection;
        this.windowType = windowType;
        this.windowSizeInMillis = windowSizeInMillis;
        this.windowCheckIntervalInMillis = windowCheckIntervalInMillis;
        this.createdColumnIndex = collection.getBaseTable().findColumn("Created");
        if (this.createdColumnIndex < 0) {
            throw new DataspaceException("Unable to initialize window mechanism because column with creation timestamp is missing.");
        }
        try {
            dataspace.bindProducerForSystem("event.CollectionWindowChange");
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to bind event id for collection window change event.");
        }
        this.metaData = SqlUtils.getCollectionMeta(collection);
        this.types = collection.getBaseTable().getColumnTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Session windowCheckSession = this.dataspace.createSession();
        windowCheckSession.setAutoCommit(false);
        while (true) {
            try {
                ((WindowCollection)((Object)this.collection)).setNextSlidingTimeWindowCheckerTime(System.currentTimeMillis() + this.windowCheckIntervalInMillis);
                Thread.sleep(this.windowCheckIntervalInMillis);
                windowCheckSession.startTransaction();
                TimestampData currentTimestamp = windowCheckSession.getCurrentSqlTimestamp();
                long expiredTimestamp = currentTimestamp.getMilliseconds() - this.windowSizeInMillis;
                PersistentStore tableStore = this.collection.getBaseTable().getRowStore(windowCheckSession);
                RowSet oldRowSet = new RowSet(this.metaData);
                RowIterator it = this.collection.getBaseTable().getPrimaryIndex().firstRow(tableStore);
                try {
                    while (it.hasNext()) {
                        Row row = it.getNextRow();
                        Object eventCreated = row.getData()[this.createdColumnIndex];
                        if (eventCreated == null || ((TimestampData)eventCreated).getMilliseconds() >= expiredTimestamp) continue;
                        Object[] oldRowSetData = row.getData();
                        oldRowSet.addToRowSet(SqlUtils.convertSqlToJava(windowCheckSession, oldRowSetData, this.types));
                        windowCheckSession.addDeleteAction((Table)row.getTable(), row, null);
                    }
                }
                finally {
                    it.release();
                }
                windowCheckSession.commit(false);
                if (oldRowSet.getRowCount() > 0) {
                    try {
                        this.collection.getBaseTable().fireWindowTriggers(windowCheckSession, oldRowSet, null);
                        MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
                        changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
                        changeEvent.setEventStringProperty("windowType", this.windowType.name());
                        this.dataspace.raiseSystemEvent(changeEvent);
                    }
                    catch (Exception error) {
                        Trace.logException(this, error, true);
                    }
                }
                ((WindowCollection)((Object)this.collection)).setLastSlidingTimeWindowDeletedRows(oldRowSet.getRowCount());
                continue;
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable ex) {
                Trace.logException(this, ex, true);
                windowCheckSession.rollback(false);
                continue;
            }
            finally {
                ((WindowCollection)((Object)this.collection)).setLastSlidingTimeWindowCheckerTime(System.currentTimeMillis());
                continue;
            }
            break;
        }
        if (windowCheckSession != null) {
            windowCheckSession.close();
            windowCheckSession = null;
        }
        try {
            this.dataspace.unbindProducerFor("event.CollectionWindowChange");
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to bind event id for collection window change event.");
        }
    }
}

