/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.jdbc.JDBCBlob;
import com.streamscape.ds.jdbc.JDBCClob;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.result.ResultLobFactoryFactory;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.DataspaceTypeToSQLTypeConverter;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.dataspace.DataspaceManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SqlUtils {
    public static Object[] convertSqlToJava(Session session, Object[] objects, Type[] types) {
        if (objects.length != types.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = SqlUtils.convertSqlToJava(session, objects[i], types[i]);
        }
        return objects;
    }

    public static Object[] convertJavaToSql(Session session, Object[] objects, Type[] types) {
        if (objects.length != types.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = SqlUtils.convertJavaToSql(session, objects[i], types[i]);
        }
        return objects;
    }

    public static Object convertSqlToJava(Session session, Object object, Type type) {
        switch (type.typeCode) {
            case 91: {
                TimestampData t = (TimestampData)object;
                return Type.SQL_DATE.convertSQLToJava(session, t);
            }
            case 92: {
                TimeData t = (TimeData)object;
                return Type.SQL_TIME.convertSQLToJava(session, t);
            }
            case 94: {
                TimeData t = (TimeData)object;
                return Type.SQL_TIME_WITH_TIME_ZONE.convertSQLToJava(session, t);
            }
            case 93: {
                TimestampData t = (TimestampData)object;
                return Type.SQL_TIMESTAMP.convertSQLToJava(session, t);
            }
            case 95: {
                TimestampData t = (TimestampData)object;
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.convertSQLToJava(session, t);
            }
            case 60: 
            case 61: {
                BinaryData binaryData = (BinaryData)object;
                return binaryData.getBytes();
            }
            case -6: {
                Integer value = (Integer)object;
                if (value != null) {
                    return value.byteValue();
                }
                return null;
            }
            case 5: {
                Integer value = (Integer)object;
                if (value != null) {
                    return value.shortValue();
                }
                return null;
            }
            case 6: 
            case 7: {
                Double value = (Double)object;
                if (value != null) {
                    return Float.valueOf(value.floatValue());
                }
                return null;
            }
            case 14: {
                BinaryData binaryData = (BinaryData)object;
                if (binaryData.equals(BinaryData.singleBitOne)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1111: 
            case 1113: 
            case 1122: 
            case 1123: 
            case 2000: {
                if (object != null) {
                    return OtherTypeWrapper.unwrap(object);
                }
                return null;
            }
            case 30: {
                try {
                    return SqlUtils.extractBlob(session, (BlobDataID)object);
                }
                catch (SQLException error) {
                    throw new DataspaceException("Unable to extract blob data. " + error.getMessage());
                }
            }
        }
        return object;
    }

    public static Object convertJavaToSql(Session session, Object object, Type type) {
        switch (type.typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return type.convertJavaToSQL(session, object);
            }
            case 60: 
            case 61: {
                return type.convertJavaToSQL(session, object);
            }
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return type.convertJavaToSQL(session, object);
            }
            case 14: {
                return type.convertJavaToSQL(session, object);
            }
            case 1111: 
            case 1113: 
            case 1122: 
            case 1123: 
            case 2000: {
                if (object instanceof OtherTypeWrapper) break;
                return new OtherTypeWrapper(object);
            }
        }
        return object;
    }

    public static Object[] processDataFromQuery(Session session, Result result, Object[] data) {
        ResultMetaData metadata = result.metaData;
        int columnCount = metadata.getColumnCount();
        Object[] rowData = new Object[columnCount];
        System.arraycopy(data, 0, rowData, 0, columnCount);
        block12: for (int i = 0; i < columnCount; ++i) {
            if (rowData[i] == null) continue;
            Type sourceType = metadata.columnTypes[i];
            switch (sourceType.typeCode) {
                case 91: {
                    Object t = (TimestampData)rowData[i];
                    rowData[i] = Type.SQL_DATE.convertSQLToJava(session, t);
                    continue block12;
                }
                case 92: 
                case 94: {
                    Object t = (TimeData)rowData[i];
                    rowData[i] = Type.SQL_TIME.convertSQLToJava(session, t);
                    continue block12;
                }
                case 93: {
                    Object t = (TimestampData)rowData[i];
                    rowData[i] = new Timestamp(((TimestampData)t).getMilliseconds());
                    continue block12;
                }
                case 95: {
                    Object t = (TimestampData)rowData[i];
                    rowData[i] = Type.SQL_TIMESTAMP.convertSQLToJava(session, t);
                    continue block12;
                }
                case 60: 
                case 61: {
                    BinaryData binaryData = (BinaryData)rowData[i];
                    rowData[i] = binaryData.getBytes();
                    continue block12;
                }
                case -6: {
                    Number value = (Integer)rowData[i];
                    if (value == null) continue block12;
                    rowData[i] = ((Integer)value).byteValue();
                    continue block12;
                }
                case 5: {
                    Number value = (Integer)rowData[i];
                    if (value == null) continue block12;
                    rowData[i] = ((Integer)value).shortValue();
                    continue block12;
                }
                case 6: 
                case 7: {
                    Number value = (Double)rowData[i];
                    if (value == null) continue block12;
                    rowData[i] = Float.valueOf(((Double)value).floatValue());
                    continue block12;
                }
                case 14: {
                    BinaryData binaryData = (BinaryData)rowData[i];
                    if (binaryData.equals(BinaryData.singleBitOne)) {
                        rowData[i] = Boolean.TRUE;
                        continue block12;
                    }
                    rowData[i] = Boolean.FALSE;
                    continue block12;
                }
                case 1111: 
                case 1113: 
                case 1122: 
                case 1123: 
                case 2000: {
                    rowData[i] = OtherTypeWrapper.unwrap(rowData[i]);
                }
            }
        }
        return rowData;
    }

    public static Object[] prepareDataForInsert(Session session, Statement stat, Object[] data) {
        ResultMetaData metadata = stat.getParametersMetaData();
        Object[] rowData = new Object[data.length];
        System.arraycopy(data, 0, rowData, 0, data.length);
        block17: for (int i = 0; i < data.length; ++i) {
            if (rowData[i] == null) continue;
            Type sourceType = metadata.columnTypes[i];
            switch (sourceType.typeCode) {
                case 91: {
                    if (!(rowData[i] instanceof Date)) continue block17;
                    rowData[i] = sourceType.convertJavaToSQL(session, rowData[i]);
                    continue block17;
                }
                case 92: 
                case 94: {
                    if (!(rowData[i] instanceof Date)) continue block17;
                    rowData[i] = sourceType.convertJavaToSQL(session, rowData[i]);
                    continue block17;
                }
                case 93: {
                    if (!(rowData[i] instanceof Date)) continue block17;
                    rowData[i] = sourceType.convertJavaToSQL(session, rowData[i]);
                    continue block17;
                }
                case 95: {
                    if (!(rowData[i] instanceof Date)) continue block17;
                    rowData[i] = sourceType.convertJavaToSQL(session, rowData[i]);
                    continue block17;
                }
                case 60: 
                case 61: {
                    if (!(rowData[i] instanceof byte[])) continue block17;
                    byte[] binaryData = (byte[])rowData[i];
                    rowData[i] = new BinaryData(binaryData, true);
                    continue block17;
                }
                case -6: 
                case 5: {
                    Serializable value = (Number)rowData[i];
                    if (value == null) continue block17;
                    rowData[i] = ((Number)value).intValue();
                    continue block17;
                }
                case 6: 
                case 7: {
                    Serializable value = (Number)rowData[i];
                    if (value == null) continue block17;
                    rowData[i] = ((Number)value).doubleValue();
                    continue block17;
                }
                case 14: {
                    Serializable value = (Boolean)rowData[i];
                    if (((Boolean)value).booleanValue()) {
                        rowData[i] = BinaryData.singleBitOne;
                        continue block17;
                    }
                    rowData[i] = BinaryData.singleBitZero;
                    continue block17;
                }
                case 30: 
                case 2004: {
                    if (!(rowData[i] instanceof byte[])) continue block17;
                    try {
                        rowData[i] = SqlUtils.allocateBlob(session, (byte[])rowData[i]);
                    }
                    catch (Exception error) {
                        Trace.logError(SqlUtils.class, "Unable to allocate LOB object. " + error.getMessage());
                    }
                    continue block17;
                }
                case 40: 
                case 2005: {
                    if (!(rowData[i] instanceof char[])) continue block17;
                    try {
                        rowData[i] = SqlUtils.allocateClob(session, (char[])rowData[i]);
                    }
                    catch (Exception error) {
                        Trace.logError(SqlUtils.class, "Unable to allocate LOB object. " + error.getMessage());
                    }
                    continue block17;
                }
                case 1111: 
                case 1113: 
                case 1122: 
                case 1123: 
                case 2000: {
                    if (rowData[i] instanceof OtherTypeWrapper) continue block17;
                    rowData[i] = new OtherTypeWrapper(rowData[i]);
                }
            }
        }
        return rowData;
    }

    public static BlobDataID allocateBlob(Session session, byte[] data) throws SQLException {
        JDBCBlob jdbcBlob = new JDBCBlob(data);
        BlobDataID blob = null;
        long length = jdbcBlob.length();
        long id = 0L;
        blob = session.createBlob(length);
        id = blob.getId();
        InputStream stream = jdbcBlob.getBinaryStream();
        ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobCreateBlobRequest(session.getId(), id, stream, length);
        session.allocateResultLob(resultLob, null);
        return blob;
    }

    public static BlobDataID allocateBlob(Session session, InputStream input, long length) throws SQLException {
        BlobDataID blob = null;
        long id = 0L;
        blob = session.createBlob(length);
        id = blob.getId();
        ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobCreateBlobRequest(session.getId(), id, input, length);
        session.allocateResultLob(resultLob, null);
        return blob;
    }

    public static ClobDataID allocateClob(Session session, char[] data) throws SQLException {
        JDBCClob jdbcClob = new JDBCClob(new String(data));
        ClobDataID clob = null;
        long length = jdbcClob.length();
        long id = 0L;
        clob = session.createClob(length);
        id = clob.getId();
        Reader stream = jdbcClob.getCharacterStream();
        ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobCreateClobRequest(session.getId(), id, stream, length);
        session.allocateResultLob(resultLob, null);
        return clob;
    }

    public static ClobDataID allocateClob(Session session, InputStream input, long length) throws SQLException {
        ClobDataID clob = null;
        long id = 0L;
        clob = session.createClob(length);
        id = clob.getId();
        ResultLob resultLob = ResultLobFactoryFactory.getLobResultFactory().newLobCreateClobRequest(session.getId(), id, null, length);
        resultLob.stream = input;
        session.allocateResultLob(resultLob, null);
        return clob;
    }

    public static byte[] extractBlob(Session session, BlobData blobId) throws SQLException {
        long blobSize = blobId.length(session);
        return blobId.getBytes(session, 0L, (int)blobSize);
    }

    public static char[] extractClob(Session session, ClobData clobId) throws SQLException {
        long clobSize = clobId.length(session);
        return clobId.getChars(session, 0L, (int)clobSize);
    }

    public static void extractDataspaceMetadata(String logFile, OutputStream output) throws Exception {
        try {
            byte[] newLineBytes = "\n".getBytes();
            BufferedReader reader = new BufferedReader(new FileReader(logFile));
            Object temp = null;
            while ((temp = reader.readLine()) != null && !((String)temp).startsWith("INSERT")) {
                if ((((String)temp).startsWith("ALTER SEQUENCE") || ((String)temp).startsWith("ALTER TABLE")) && ((String)temp).contains("RESTART WITH")) {
                    int index = ((String)temp).indexOf("RESTART WITH");
                    temp = ((String)temp).substring(0, index) + "RESTART WITH 1";
                } else if (((String)temp).startsWith("SET TABLE") && ((String)temp).contains("INDEX")) continue;
                output.write(((String)temp).getBytes());
                output.write(newLineBytes);
            }
        }
        catch (Exception error) {
            Trace.logException(SqlUtils.class, error, true);
        }
    }

    public static void timeUnitToString(StringBuilder buffer, TimeUnit unit) {
        buffer.append(SqlUtils.timeUnitToString(unit));
    }

    public static String timeUnitToString(TimeUnit unit) {
        switch (unit) {
            case SECONDS: {
                return "SEC";
            }
            case MINUTES: {
                return "MIN";
            }
            case HOURS: {
                return "HR";
            }
            case DAYS: {
                return "DAYS";
            }
        }
        return "MS";
    }

    public static long getTimeIntervalInMillis(long windowSize, TimeUnit timeWindowUnit) {
        if (timeWindowUnit == null) {
            timeWindowUnit = TimeUnit.MILLISECONDS;
        }
        long actualWindowSize = 0L;
        switch (timeWindowUnit) {
            case MILLISECONDS: {
                actualWindowSize = windowSize;
                break;
            }
            case SECONDS: {
                actualWindowSize = windowSize * 1000L;
                break;
            }
            case MINUTES: {
                actualWindowSize = windowSize * 60000L;
                break;
            }
            case HOURS: {
                actualWindowSize = windowSize * 3600000L;
                break;
            }
            case DAYS: {
                actualWindowSize = windowSize * 3600000L * 24L;
            }
        }
        return actualWindowSize;
    }

    public static RowMetaData getCollectionMeta(Collection collection) {
        RowMetaData meta = new RowMetaData();
        for (int i = 0; i < collection.getBaseTable().getColumnCount(); ++i) {
            ColumnSchema column = collection.getBaseTable().getColumn(i);
            Type type = column.getDataType();
            meta.addColumn(column.getNameString(), DataspaceTypeToSQLTypeConverter.convert(type), column.isNullable(), type.getJDBCPrecision(), type.getJDBCScale());
        }
        return meta;
    }

    public static Type getEventDataType(Session session, String eventId) {
        Type dataType = null;
        Prototype eventPrototype = DataspaceManager.getContext().getDatagramPrototypeCache().lookupPrototype(eventId);
        if (!(eventPrototype != null || eventId.contains("*") || eventId.contains("#") || eventId.contains("&"))) {
            throw new DataspaceException("Specified prototype [" + eventId + "] does not exist.");
        }
        if (eventPrototype != null) {
            DatagramFactory factory = DataspaceManager.getContext().getDatagramFactoryManager().lookupDatagramFactoryByModel(eventPrototype.getModelName());
            if (factory != null) {
                try {
                    ImmutableEventDatagram event = factory.createEvent(eventId);
                    dataType = Types.getParameterSQLType(session, event.getClass());
                }
                catch (Exception error) {
                    Trace.logError(SqlUtils.class, error.getMessage());
                    throw new DataspaceException(error);
                }
            }
            SemanticType semanticType = DataspaceManager.getContext().getSemanticTypeCache().lookupSemanticType(eventPrototype.getInstanceName());
            if (semanticType == null) {
                throw new DataspaceException("Unable to resolve Datagram Factory and semantic type for specified prototype [" + eventId + "] with '" + eventPrototype.getModelName() + "' model.");
            }
            try {
                Class clazz = ClassUtils.loadClass(semanticType.getClassName(), DataspaceManager.getContext().getSystemClassLoaderChain());
                dataType = Types.getParameterSQLType(session, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new DataspaceException("Unable to load class '" + semanticType.getClassName() + "' for prototype [" + eventId + "].");
            }
            if (dataType instanceof EventType) {
                ((EventType)dataType).setEventId(eventId);
            }
        } else {
            dataType = Types.getParameterSQLType(session, ImmutableEventDatagram.class);
        }
        return dataType;
    }

    public static String getSchemaObjectType(int type) {
        switch (type) {
            case 1: {
                return "CATALOG";
            }
            case 2: {
                return "SCHEMA";
            }
            case 3: {
                return "TABLE";
            }
            case 4: {
                return "COLLECTION";
            }
            case 5: {
                return "VIEW";
            }
            case 6: {
                return "CONSTRAINT";
            }
            case 7: {
                return "ASSERTION";
            }
            case 8: {
                return "SEQUENCE";
            }
            case 9: {
                return "TRIGGER";
            }
            case 10: {
                return "COLUMN";
            }
            case 11: {
                return "TRANSITION";
            }
            case 12: {
                return "GRANTEE";
            }
            case 13: {
                return "TYPE";
            }
            case 14: {
                return "DOMAIN";
            }
            case 15: {
                return "CHARSET";
            }
            case 42: {
                return "ASPECTS";
            }
            case 41: {
                return "FACETS";
            }
            case 16: {
                return "COLLATION";
            }
            case 17: {
                return "FUNCTION";
            }
            case 18: {
                return "PROCEDURE";
            }
            case 19: {
                return "ROUTINE";
            }
            case 20: {
                return "CURSOR";
            }
            case 21: {
                return "INDEX";
            }
            case 22: {
                return "LABEL";
            }
            case 23: {
                return "VARIABLE";
            }
            case 24: {
                return "PARAMETER";
            }
            case 25: {
                return "SPECIFIC_ROUTINE";
            }
            case 26: {
                return "WRAPPER";
            }
            case 27: {
                return "SERVER";
            }
            case 28: {
                return "SUBQUERY";
            }
            case 29: {
                return "REPLICA";
            }
            case 30: {
                return "TIMER";
            }
            case 31: {
                return "JOB";
            }
            case 32: {
                return "ACTOR";
            }
            case 37: {
                return "REFERENCE_LINK";
            }
        }
        return "UNKNOWN";
    }

    public static String getSchemaObjectTypeName(NameManager.ObjectName objectName, Session session) {
        AbstractCollection collection;
        if ((objectName.type == 3 || objectName.type == 4) && (collection = (AbstractCollection)session.dataspaceStore.schemaManager.getCollection(session, objectName.name, objectName.schema.name)) != null) {
            return AbstractCollection.getCollectionTypeName(collection.getCollectionType());
        }
        return SqlUtils.getSchemaObjectTypeName(objectName.type);
    }

    public static String getSchemaObjectTypeName(int type) {
        switch (type) {
            case 1: {
                return "CATALOG";
            }
            case 2: {
                return "SCHEMA";
            }
            case 3: {
                return "TABLE";
            }
            case 4: {
                return "COLLECTION";
            }
            case 5: {
                return "VIEW";
            }
            case 6: {
                return "CONSTRAINT";
            }
            case 7: {
                return "ASSERTION";
            }
            case 8: {
                return "SEQUENCE";
            }
            case 9: {
                return "TRIGGER";
            }
            case 10: {
                return "TUPLE";
            }
            case 11: {
                return "TRANSITION";
            }
            case 12: {
                return "GRANTEE";
            }
            case 13: {
                return "TYPE";
            }
            case 14: {
                return "DOMAIN";
            }
            case 15: {
                return "CHARSET";
            }
            case 42: {
                return "ASPECTS";
            }
            case 41: {
                return "FACETS";
            }
            case 16: {
                return "COLLATION";
            }
            case 17: {
                return "FUNCTION";
            }
            case 25: {
                return "FUNCTION";
            }
            case 18: {
                return "FUNCTION";
            }
            case 19: {
                return "FUNCTION";
            }
            case 20: {
                return "CURSOR";
            }
            case 21: {
                return "INDEX";
            }
            case 22: {
                return "LABEL";
            }
            case 23: {
                return "VARIABLE";
            }
            case 24: {
                return "PARAMETER";
            }
            case 26: {
                return "WRAPPER";
            }
            case 27: {
                return "SERVER";
            }
            case 28: {
                return "SUBQUERY";
            }
            case 29: {
                return "REPLICA";
            }
            case 30: {
                return "TIMER";
            }
            case 31: {
                return "JOB";
            }
            case 32: {
                return "ACTOR";
            }
            case 37: {
                return "REFERENCE LINK";
            }
            case 35: {
                return "SEMANTIC TYPE";
            }
            case 36: {
                return "EVENT";
            }
            case 38: {
                return "TEXT INDEX";
            }
            case 39: {
                return "FILE DESCRIPTOR";
            }
            case 40: {
                return "CONNECTION FACTORY";
            }
        }
        return "UNKNOWN";
    }

    public static List<Integer> listAllSchemaTypes() {
        return Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 41, 43, 44, 45, 46, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 37);
    }

    public static List<String> listAllSchemaTypeNames() {
        return SqlUtils.listAllSchemaTypes().stream().map(t -> SqlUtils.getSchemaObjectType(t)).collect(Collectors.toList());
    }

    public static String resolveEventModel(RuntimeContext context, String eventId) {
        String eventModel = "Unknown";
        try {
            eventModel = context.getDatagramPrototypeCache().getModel(eventId);
        }
        catch (DatagramFactoryException e) {
            Trace.logDebug(SqlUtils.class, "Event model not found for event [" + eventId + "]. Cause: " + e.getMessage());
        }
        return eventModel;
    }

    public static Object[] convertRowFromSqlToJava(Session session, Row row, Type[] types) {
        if (types == null) {
            throw new IllegalArgumentException("Types can't be NULL. Unable to convert row data.");
        }
        Object[] current = row.getData();
        Object[] newData = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isLobType()) {
                if (!(current[i] instanceof BlobDataID)) continue;
                try {
                    newData[i] = SqlUtils.extractBlob(session, (BlobDataID)current[i]);
                }
                catch (Exception error) {
                    Trace.logError(SqlUtils.class, "Unable to extract LOB object. " + error.getMessage());
                }
                continue;
            }
            newData[i] = types[i].convertSQLToJava(session, current[i]);
        }
        return newData;
    }

    public static Object[] getDataForInsert(Session session, Table baseTable, Object[] rowData, Type[] tableTypes, Type[] rowSetTypes) {
        Object[] data = baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < rowData.length; ++i) {
            Object value = rowData[i];
            Type type = tableTypes[i];
            value = rowSetTypes[i].convertJavaToSQL(session, value);
            if (tableTypes[i] != rowSetTypes[i]) {
                value = type.convertToType(session, value, rowSetTypes[i]);
            }
            data[i] = value;
        }
        return data;
    }

    public static void updateRplEntitiesOnDataspaceRename(Session session, String type, String oldName, String newName) {
        session.sessionContext.postponedStatements = new ArrayList();
        Statement stat = session.compileStatement("update SDS.SYSLDEF set COMPONENT_NAME = '" + newName + "'  where COMPONENT_NAME = '" + oldName + "' and COMPONENT_TYPE = '" + type + "'");
        session.sessionContext.postponedStatements.add(stat);
    }

    public static String getObjectCreatedTimestamp(Session session, SchemaObject routine) {
        Pair<Timestamp, Timestamp> timestamps = session.dataspaceStore.schemaManager.loadObjectTimestamps(session, routine);
        return timestamps != null && timestamps.first != null ? DataspaceDateTime.trimMills(DataspaceDateTime.getSqlTimestampString((Timestamp)timestamps.first)) : "n/a";
    }

    public static String getObjectModifiedTimestamp(Session session, SchemaObject routine) {
        Pair<Timestamp, Timestamp> timestamps = session.dataspaceStore.schemaManager.loadObjectTimestamps(session, routine);
        return timestamps != null && timestamps.second != null ? DataspaceDateTime.trimMills(DataspaceDateTime.getSqlTimestampString((Timestamp)timestamps.second)) : "n/a";
    }
}

