/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.collection.DataspaceTypeToSQLTypeConverter;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.FlobDataID;
import com.streamscape.ds.types.IntervalSecondData;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.AbstractRowSetFactory;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.SLSessionData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class RowSetFactoryForDSResult
extends AbstractRowSetFactory<RowSetFactoryForDSResult> {
    public List<RowSet> createRowSets(Session session, Result result) {
        ArrayList<RowSet> results = new ArrayList<RowSet>();
        boolean isUpdateCount = RowSetFactoryForDSResult.isUpdateCountResult(result);
        int updateCount = result.getUpdateCount();
        while (result != null) {
            if (result.isSimpleValue()) {
                results.add(RowSetFactoryForDSResult.createSimpleValueRowSet(result.valueData, result.valueType));
            }
            if (!result.isData()) {
                result = result.getChainedResult();
                continue;
            }
            RowSetNavigator navigator = result.getNavigator();
            ResultMetaData metadata = result.metaData;
            RowSet rowSet = this.createRowSet(session, navigator, metadata);
            rowSet.setParserStatement(result.statement);
            results.add(rowSet);
            result = result.getChainedResult();
        }
        if (results.size() == 0 && isUpdateCount) {
            results.add(RowSetFactoryForDSResult.createUpdateCountRowSet(updateCount));
        }
        return results;
    }

    public RowSet createRowSet(Session session, RowSetNavigator navigator, ResultMetaData metadata) {
        RowSet rowSet = new RowSet(this.createRowSetMetaData(metadata));
        while (navigator.next()) {
            Object[] rowData = this.convertCurrentRowData(session, navigator, metadata);
            Row row = rowSet.newRow();
            try {
                row.setRawData(rowData);
                rowSet.addToRowSet(row);
            }
            catch (RowException error) {
                Trace.logError(SqlUtils.class, "Unable to populate row from Result Set. " + error.getMessage());
            }
            catch (SQLException error) {
                Trace.logError(SqlUtils.class, "Unable to populate row from Result Set. " + error.getMessage());
            }
        }
        try {
            rowSet.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rowSet;
    }

    public RowMetaData createRowSetMetaData(ResultMetaData metadata) {
        RowMetaData descriptor = new RowMetaData(100);
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            SQLType type;
            String label = metadata.columnLabels[i];
            if (label == null || label.length() == 0) {
                label = metadata.columns[i].getNameString();
            }
            if ((type = DataspaceTypeToSQLTypeConverter.convert(metadata.columnTypes[i])) == null) {
                throw new DataspaceException("Unsupported by RowSet SQL type '" + metadata.columnTypes[i].getNameString() + "' used in column '" + label + "'.");
            }
            descriptor.addColumn(label, type, metadata.columns[i].isNullable(), metadata.columnTypes[i].getJDBCPrecision(), metadata.columnTypes[i].getJDBCScale());
        }
        return descriptor;
    }

    private Object[] convertCurrentRowData(Session session, RowSetNavigator navigator, ResultMetaData metadata) {
        Object[] navigatorData = navigator.getCurrent();
        int columnCount = metadata.getColumnCount();
        Object[] rowData = new Object[columnCount];
        System.arraycopy(navigatorData, 0, rowData, 0, columnCount);
        for (int i = 0; i < rowData.length; ++i) {
            if (rowData[i] == null) continue;
            rowData[i] = RowSetFactoryForDSResult.convertValue(session, rowData[i], metadata.columnTypes[i], this.withBlobs, rowData.length == 1 && navigator.getSize() == 1, this.notation);
        }
        return rowData;
    }

    public static Object convertValue(Session session, Object value, Type type, boolean withBlobs, boolean isSingleValue, SLSessionData.DataObjectNotation notation) {
        switch (type.typeCode) {
            case 91: {
                if (value instanceof TimestampData) {
                    TimestampData t = (TimestampData)value;
                    value = Type.SQL_DATE.convertSQLToJava(session, t);
                    break;
                }
                if (!(value instanceof Date)) break;
                value = new Date(((Date)value).getTime());
                break;
            }
            case 92: {
                if (value instanceof TimeData) {
                    TimeData t = (TimeData)value;
                    value = Type.SQL_TIME.convertSQLToJava(session, t);
                    break;
                }
                if (!(value instanceof Time)) break;
                value = new Time(((Time)value).getTime());
                break;
            }
            case 94: {
                TimeData t = (TimeData)value;
                value = Type.SQL_TIME_WITH_TIME_ZONE.convertSQLToJava(session, t);
                break;
            }
            case 93: {
                if (value instanceof TimestampData) {
                    TimestampData t = (TimestampData)value;
                    value = Type.SQL_TIMESTAMP.convertSQLToJava(session, t);
                    break;
                }
                if (!(value instanceof Timestamp)) break;
                Timestamp t = (Timestamp)value;
                value = new Timestamp(t.getTime());
                break;
            }
            case 95: {
                TimestampData t = (TimestampData)value;
                value = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.convertSQLToJava(session, t);
                break;
            }
            case 60: 
            case 61: {
                BinaryData binaryData = (BinaryData)value;
                value = binaryData.getBytes();
                break;
            }
            case -6: {
                Number number = (Number)value;
                if (value == null) break;
                value = number.byteValue();
                break;
            }
            case 5: {
                if (value == null) break;
                value = ((Number)value).shortValue();
                break;
            }
            case 6: 
            case 7: {
                if (value == null) break;
                value = Float.valueOf(((Number)value).floatValue());
                break;
            }
            case 14: {
                BinaryData binaryData = (BinaryData)value;
                if (binaryData.equals(BinaryData.singleBitOne)) {
                    value = Boolean.TRUE;
                    break;
                }
                value = Boolean.FALSE;
                break;
            }
            case 1111: 
            case 1113: 
            case 2000: {
                Object javaObject = OtherTypeWrapper.unwrap(value);
                if (!withBlobs && javaObject != null && !(javaObject instanceof String)) {
                    if (javaObject instanceof RowSet && isSingleValue) {
                        javaObject = RowSetFactory.updateRowSetFromSlang(javaObject);
                    } else if (javaObject instanceof URL) {
                        javaObject = ((URL)javaObject).getLink();
                    } else if (!TypeFactory.isPrimitive(javaObject.getClass()) && !(javaObject instanceof java.util.Date)) {
                        javaObject = RowSetFactory.convertValueInNotation(javaObject, "[ OBJECT : " + (javaObject != null ? javaObject.getClass().getSimpleName() : "null") + " ]", notation);
                    }
                } else {
                    try {
                        javaObject = SDOUtils.clone(javaObject);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                value = javaObject;
                break;
            }
            case 1122: {
                Object javaObject = OtherTypeWrapper.unwrap(value);
                if (!withBlobs) {
                    value = javaObject instanceof Facets ? FacetsUtils.facetsToString((Facets)javaObject) : String.valueOf(javaObject);
                    break;
                }
                try {
                    value = SDOUtils.clone(javaObject);
                }
                catch (Exception exception) {}
                break;
            }
            case 1123: {
                Object javaObject = OtherTypeWrapper.unwrap(value);
                if (!withBlobs) {
                    value = javaObject instanceof Aspects ? FacetsUtils.aspectsToString((Aspects)javaObject) : String.valueOf(javaObject);
                    break;
                }
                try {
                    value = SDOUtils.clone(javaObject);
                }
                catch (Exception exception) {}
                break;
            }
            case 30: 
            case 2004: {
                if (!(value instanceof BlobDataID)) break;
                if (withBlobs) {
                    try {
                        value = SqlUtils.extractBlob(session, (BlobDataID)value);
                    }
                    catch (Exception error) {
                        value = "[ BLOB : INVALID ]";
                    }
                    break;
                }
                value = "[ BLOB : " + ((BlobDataID)value).getId() + " ]";
                break;
            }
            case 40: 
            case 2005: {
                if (!(value instanceof ClobDataID)) break;
                if (withBlobs) {
                    try {
                        value = SqlUtils.extractClob(session, (ClobDataID)value);
                    }
                    catch (Exception error) {
                        value = "[ CLOB : INVALID ]";
                    }
                    break;
                }
                value = "[ CLOB : " + ((ClobDataID)value).getId() + " ]";
                break;
            }
            case 1119: {
                if (!(value instanceof FlobDataID)) break;
                if (withBlobs) {
                    try {
                        value = SqlUtils.extractBlob(session, ((FlobDataID)value).getBlobAdapter());
                    }
                    catch (Exception error) {
                        value = "[ FLOB : INVALID ]";
                    }
                    break;
                }
                value = "[ FLOB : " + ((FlobDataID)value).getId() + " ]";
                break;
            }
            case 111: {
                value = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((IntervalSecondData)value).getSeconds(), 0, true);
            }
        }
        return value;
    }

    public static boolean isUpdateCountResult(Result result) {
        return RowSetFactoryForDSResult.isUpdateCountResult(result.getStatement() != null ? result.getStatement().getSQL() : null, result.getUpdateCount());
    }

    public static boolean isUpdateCountResult(String sql, int updateCount) {
        if (updateCount >= 0) {
            return true;
        }
        if (sql != null) {
            sql = sql.substring(0, (sql = sql.trim()).length() < 10 ? sql.length() : 10).toLowerCase();
            return sql.startsWith("insert ") || sql.startsWith("update ") || sql.startsWith("delete ");
        }
        return false;
    }

    public static RowSet createUpdateCountRowSet(int updateCount) {
        RowMetaData metaData = new RowMetaData();
        metaData.addColumn("UpdateCount", Integer.class);
        RowSet rowSet = new RowSet(metaData);
        try {
            rowSet.addToRowSet(new Object[]{updateCount});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rowSet;
    }

    public static RowSet createSimpleValueRowSet(Object simpleValue, Type simpleValueType) {
        RowMetaData metaData = new RowMetaData();
        SQLType type = DataspaceTypeToSQLTypeConverter.convert(simpleValueType);
        if (type == null) {
            throw new DataspaceException("Unsupported by RowSet SQL type '" + simpleValueType.getNameString() + "' used in result value.'");
        }
        metaData.addColumn("Value", type, false, simpleValueType.getJDBCPrecision(), simpleValueType.getJDBCScale());
        RowSet rowSet = new RowSet(metaData);
        try {
            rowSet.addToRowSet(new Object[]{simpleValue});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rowSet;
    }
}

