/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import java.util.ArrayList;

public class QueueSlidingTimeWindowChecker
implements Runnable {
    protected AbstractDataspace dataspace;
    protected EventQueueCollection collection;
    protected CollectionWindowType windowType;
    protected long windowSizeInMillis;
    protected long windowCheckIntervalInMillis;
    protected int eventColumnIndex;
    protected int seqIdColumnIndex;
    protected int createdColumnIndex;
    protected Statement deleteStatement;

    public QueueSlidingTimeWindowChecker(AbstractDataspace dataspace, EventQueueCollection collection, long windowSizeInMillis, long windowCheckIntervalInMillis, CollectionWindowType windowType) {
        this.dataspace = dataspace;
        this.collection = collection;
        this.windowType = windowType;
        this.windowSizeInMillis = windowSizeInMillis;
        this.windowCheckIntervalInMillis = windowCheckIntervalInMillis;
        this.eventColumnIndex = collection.getBaseTable().findColumn("Event");
        if (this.eventColumnIndex < 0) {
            throw new DataspaceException("Unable to initialize window mechanism because column with Event is missing.");
        }
        this.createdColumnIndex = collection.getBaseTable().findColumn("Created");
        if (this.createdColumnIndex < 0) {
            throw new DataspaceException("Unable to initialize window mechanism because column with creation timestamp is missing.");
        }
        this.seqIdColumnIndex = collection.getBaseTable().findColumn("SeqId");
        if (this.seqIdColumnIndex < 0) {
            throw new DataspaceException("Unable to initialize window mechanism because column with SeqId is missing.");
        }
        try {
            dataspace.bindProducerForSystem("event.CollectionWindowChange");
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to bind event id for collection window change event.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Session windowCheckSession = null;
        try {
            while (true) {
                try {
                    this.collection.setNextSlidingTimeWindowCheckerTime(System.currentTimeMillis() + this.windowCheckIntervalInMillis);
                    Thread.sleep(this.windowCheckIntervalInMillis);
                    if (windowCheckSession == null) {
                        windowCheckSession = this.dataspace.createSession();
                        this.deleteStatement = windowCheckSession.compileStatement("delete from " + this.collection.getBaseTable().getObjectName().getSchemaQualifiedStatementName());
                    }
                    int deletedRows = this.deleteExpiredRows(windowCheckSession);
                    this.collection.setLastSlidingTimeWindowDeletedRows(deletedRows);
                    this.collection.setLastSlidingTimeWindowCheckerTime(System.currentTimeMillis());
                    if (windowCheckSession == null) continue;
                    windowCheckSession.close();
                    windowCheckSession = null;
                    continue;
                }
                catch (InterruptedException ex) {
                    this.collection.setLastSlidingTimeWindowCheckerTime(System.currentTimeMillis());
                    if (windowCheckSession != null) {
                        windowCheckSession.close();
                        windowCheckSession = null;
                    }
                }
                catch (Throwable ex) {
                    try {
                        Trace.logException(this, ex, true);
                        try {
                            windowCheckSession.rollback(true);
                        }
                        catch (Exception exception) {
                            Trace.logException(this, exception, true);
                        }
                        try {
                            windowCheckSession.close();
                            continue;
                        }
                        catch (Exception exception) {
                            Trace.logException(this, exception, true);
                            continue;
                        }
                        finally {
                            windowCheckSession = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.collection.setLastSlidingTimeWindowCheckerTime(System.currentTimeMillis());
                        if (windowCheckSession == null) continue;
                        windowCheckSession.close();
                        windowCheckSession = null;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            if (windowCheckSession != null) {
                windowCheckSession.close();
            }
            try {
                this.dataspace.unbindProducerFor("event.CollectionWindowChange");
            }
            catch (Exception error) {
                Trace.logError(this, "Unable to bind event id for collection window change event.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteExpiredRows(Session windowCheckSession) throws InterruptedException {
        long minSeqId = -1L;
        long expiredTimestamp = windowCheckSession.getCurrentSqlTimestamp().getMilliseconds() - this.windowSizeInMillis;
        try {
            windowCheckSession.setAutoCommit(false);
            windowCheckSession.startTransactionWithWait(this.deleteStatement, true);
            if (windowCheckSession.abortTransaction) {
                int n = 0;
                return n;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            PersistentStore tableStore = this.collection.getBaseTable().getRowStore(windowCheckSession);
            RowIterator it = this.collection.getBaseTable().getPrimaryIndex().firstRow(tableStore);
            try {
                Row row;
                Object eventCreated;
                while (it.hasNext() && (eventCreated = (row = it.getNextRow()).getData()[this.createdColumnIndex]) != null) {
                    if (((TimestampData)eventCreated).getMilliseconds() >= expiredTimestamp) {
                        break;
                    }
                    minSeqId = ((Number)row.getData()[this.seqIdColumnIndex]).longValue();
                }
            }
            finally {
                if (it != null) {
                    it.release();
                }
            }
        }
        finally {
            windowCheckSession.commitTransactionWithAction(false);
            windowCheckSession.setAutoCommit(true);
        }
        if (minSeqId >= 0L) {
            int updateCount;
            int totalCount = 0;
            do {
                windowCheckSession.setAutoCommit(true);
                Result result = windowCheckSession.executeDirectStatement("delete from " + this.collection.getBaseTable().getObjectName().getSchemaQualifiedStatementName() + " where SeqId <= " + minSeqId + " and rownum() < 50000");
                if (result.isError()) {
                    throw result.getException();
                }
                updateCount = result.getUpdateCount();
                totalCount += updateCount;
            } while (updateCount > 0);
            if (totalCount > 0) {
                try {
                    this.collection.getBaseTable().fireWindowTriggers(windowCheckSession, new ArrayList(), null);
                    MapEvent changeEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.CollectionWindowChange");
                    changeEvent.setEventStringProperty("collectionName", this.collection.getObjectName().name);
                    changeEvent.setEventStringProperty("windowType", this.windowType.name());
                    this.dataspace.raiseSystemEvent(changeEvent);
                }
                catch (Exception error) {
                    Trace.logException(this, error, true);
                }
            }
            Trace.logDebug(this, "{} rows with SeqId lower than {} removed from queue {}.", totalCount, minSeqId, this.collection.getObjectName().getSchemaQualifiedStatementName());
            return totalCount;
        }
        return 0;
    }
}

