/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.analyzer.EventAnalyzer;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;

public class EventSystemPropertiesGetters {
    private final LinkedHashMap<String, EventAnalyzer.Property> systemProperties;

    public EventSystemPropertiesGetters(ImmutableEventDatagram eventDatagram) {
        this.systemProperties = new EventAnalyzer(eventDatagram).getSystemProperties();
    }

    public boolean existsSystemProperty(String propertyName) {
        return this.systemProperties.containsKey(propertyName);
    }

    public boolean getSystemPropertyType(String propertyName) {
        this.checkSystemPropertyExists(propertyName);
        return this.systemProperties.containsKey(propertyName);
    }

    public SystemPropertyGetter getSystemPropertyGetter(String propertyName) {
        this.checkSystemPropertyExists(propertyName);
        EventAnalyzer.Property property = this.systemProperties.get(propertyName);
        return new SystemPropertyGetter(property.getGetterName(), property.getType());
    }

    private void checkSystemPropertyExists(String name) {
        if (!this.existsSystemProperty(name)) {
            throw new DataspaceException("System property '" + name + "' does not exist.");
        }
    }

    public static class SystemPropertyGetter {
        private String getterName;
        private Class<?> type;
        private Class datagramClass;
        private Method getterMethod;

        public SystemPropertyGetter(String getterName, Class<?> type) {
            this.getterName = getterName;
            this.type = type;
        }

        public Object get(EventDatagram datagram) {
            if (datagram == null) {
                return null;
            }
            if (this.getterMethod == null || this.datagramClass != datagram.getClass()) {
                this.getterMethod = ClassUtils.getDeclaredOrInheritedMethod(datagram.getClass(), this.getterName, new Class[0], false);
                this.datagramClass = datagram.getClass();
            }
            try {
                return this.getterMethod.invoke((Object)datagram, new Object[0]);
            }
            catch (Exception e) {
                throw new DataspaceException("Failed to get system property using getter " + this.getterName + ".", e);
            }
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

