/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.pqueue.ProcessQueueCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.EventSystemPropertiesGetters;
import com.streamscape.ds.utils.WindowCollection;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.advisory.SystemAdvisories;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.AuditEvent;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class EventPropertiesMapper {
    protected List<Type> columnTypes = new ArrayList<Type>();
    protected String prototype = null;
    protected EventDatagram prototypeDatagram = null;
    protected List<String> includeProps = null;
    protected List<String> excludeProps = null;
    private WindowCollection windowCollection;
    protected List<String> primaryKeyColumns = null;
    protected EventSystemPropertiesGetters eventSystemPropertiesGetters = null;
    protected String columnList = "";
    protected String paramsList = "";
    protected String pKeyColumnList = "";
    protected String notPKeyColumnList = "";
    protected List<SystemProperty> systemProps = new ArrayList<SystemProperty>();
    protected List<String> userProps = new ArrayList<String>();
    protected LinkedHashMap<String, EventSystemPropertiesGetters.SystemPropertyGetter> systemUserProps = new LinkedHashMap();
    protected List<SystemProperty> pKeySystemProps = null;
    protected List<String> pKeyUserProps = null;
    protected List<SystemProperty> notPKeySystemProps = new ArrayList<SystemProperty>();
    protected List<String> notPKeyUserProps = new ArrayList<String>();

    public EventPropertiesMapper(String prototype, List<String> includeProps, List<String> excludeProps, WindowCollection windowCollection) {
        this.prototype = prototype;
        this.includeProps = includeProps;
        this.excludeProps = excludeProps;
        this.windowCollection = windowCollection;
    }

    public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
        this.pKeySystemProps = new ArrayList<SystemProperty>();
        this.pKeyUserProps = new ArrayList<String>();
        this.notPKeySystemProps = new ArrayList<SystemProperty>();
        this.notPKeyUserProps = new ArrayList<String>();
    }

    public void compile(Collection collection) throws DataspaceException {
        Type columnType;
        SystemProperty prop;
        boolean includeEventId = true;
        boolean isProcessQueue = collection instanceof ProcessQueueCollection;
        if (this.prototype != null) {
            includeEventId = false;
            RuntimeContext runtimeCtx = DataspaceStoreManager.getRuntimeContext();
            Prototype eventPrototype = runtimeCtx.getDatagramPrototypeCache().lookupPrototype(this.prototype);
            if (!(eventPrototype != null || this.prototype.contains("*") || this.prototype.contains("#") || this.prototype.contains("&"))) {
                throw new DataspaceException("Specified prototype '" + this.prototype + "' does not exist.");
            }
            if (eventPrototype != null) {
                ImmutableEventDatagram event;
                DatagramFactory factory = runtimeCtx.getDatagramFactoryManager().lookupDatagramFactoryByModel(eventPrototype.getModelName());
                if (factory != null) {
                    try {
                        event = factory.createEvent(this.prototype);
                    }
                    catch (Exception error) {
                        Trace.logError(EventQueueCollection.class, error.getMessage());
                        throw new DataspaceException(error);
                    }
                } else if (SystemAdvisories.isSystem(this.prototype)) {
                    event = SystemAdvisories.getEventPrototypes().get(this.prototype);
                } else {
                    throw new DataspaceException("Unable to resolve Datagram Factory for specified prototype '" + this.prototype + "' with '" + eventPrototype.getModelName() + "' model.");
                }
                if (event instanceof EventDatagram) {
                    this.prototypeDatagram = (EventDatagram)event;
                }
                this.eventSystemPropertiesGetters = new EventSystemPropertiesGetters(event);
            }
        }
        boolean excludeAll = false;
        if (this.includeProps != null) {
            if (this.includeProps.contains("*")) {
                this.addAllSystemAndUserProperties(this.prototypeDatagram, includeEventId, collection, isProcessQueue);
            }
        } else {
            this.addAllSystemAndUserProperties(this.prototypeDatagram, includeEventId, collection, isProcessQueue);
        }
        if (this.excludeProps != null && this.excludeProps.size() == 1 && this.excludeProps.get(0).equals("*")) {
            excludeAll = true;
            this.systemProps.clear();
            this.userProps.clear();
        }
        if (this.includeProps != null) {
            for (String property : this.includeProps) {
                if ("*".equals(property)) continue;
                try {
                    prop = SystemProperty.valueOf(property);
                    if (isProcessQueue && prop == SystemProperty.CorrelationId) {
                        prop = SystemProperty.ProcessId;
                    }
                    this.systemProps.add(prop);
                }
                catch (IllegalArgumentException error) {
                    if (this.eventSystemPropertiesGetters != null && this.eventSystemPropertiesGetters.existsSystemProperty(property)) {
                        this.systemUserProps.put(property, this.eventSystemPropertiesGetters.getSystemPropertyGetter(property));
                        continue;
                    }
                    if (this.prototypeDatagram == null || this.prototypeDatagram.getEventPropertyNames().contains(property)) {
                        this.userProps.add(property);
                        continue;
                    }
                    throw new DataspaceException("Unknown property '" + property + "' inclusion for Event Prototype " + (this.prototype != null ? this.prototype : "unknown") + " specified.");
                }
            }
        }
        if (this.excludeProps != null && !excludeAll) {
            for (String property : this.excludeProps) {
                try {
                    prop = SystemProperty.valueOf(property);
                    this.systemProps.remove((Object)prop);
                }
                catch (IllegalArgumentException error) {
                    if (this.prototypeDatagram != null && this.prototypeDatagram.getEventPropertyNames().contains(property)) {
                        this.userProps.remove(property);
                        continue;
                    }
                    throw new DataspaceException("Unknown property '" + property + "' specified.");
                }
            }
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder paramsBuffer = new StringBuilder();
        StringBuilder pKeyColumnListBuffer = new StringBuilder();
        StringBuilder notPKeyColumnListBuffer = new StringBuilder();
        boolean hasProcessId = false;
        for (SystemProperty systemProperty : this.systemProps) {
            switch (systemProperty.ordinal()) {
                case 9: {
                    hasProcessId = true;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.columnTypes.add(Type.STRING);
                    break;
                }
                case 7: 
                case 8: {
                    this.columnTypes.add(Type.SQL_TIMESTAMP);
                }
            }
            buffer.append("[").append(systemProperty.name()).append("],");
            paramsBuffer.append("?,");
            if (this.primaryKeyColumns != null && this.primaryKeyColumns.contains(systemProperty.name())) {
                this.pKeySystemProps.add(systemProperty);
                pKeyColumnListBuffer.append("[").append(systemProperty.name()).append("] = ?,");
                continue;
            }
            this.notPKeySystemProps.add(systemProperty);
            notPKeyColumnListBuffer.append("[").append(systemProperty.name()).append("] = ?,");
        }
        if (isProcessQueue && !hasProcessId) {
            throw new DataspaceException("Process queue collection requires ProcessId column. It can't be excluded.");
        }
        for (Map.Entry entry : this.systemUserProps.entrySet()) {
            try {
                columnType = Types.getParameterSQLType(null, ((EventSystemPropertiesGetters.SystemPropertyGetter)entry.getValue()).getType());
            }
            catch (Exception exception) {
                columnType = new OtherType(((EventSystemPropertiesGetters.SystemPropertyGetter)entry.getValue()).getType().getSimpleName(), ((EventSystemPropertiesGetters.SystemPropertyGetter)entry.getValue()).getType());
            }
            this.columnTypes.add(columnType);
            buffer.append("[").append((String)entry.getKey()).append("],");
            paramsBuffer.append("?,");
            if (this.primaryKeyColumns != null && this.primaryKeyColumns.contains(entry.getKey())) {
                pKeyColumnListBuffer.append("[").append((String)entry.getKey()).append("] = ?,");
                continue;
            }
            notPKeyColumnListBuffer.append("[").append((String)entry.getKey()).append("] = ?,");
        }
        for (String string : this.userProps) {
            columnType = Type.STRING;
            if (this.prototypeDatagram != null) {
                try {
                    columnType = this.resolveSQLType(string, this.prototypeDatagram);
                }
                catch (SDOException exception) {
                    Trace.logError(this, "Unable to define type of '" + string + "' event property. Using varchar type. Cause: " + exception.getMessage());
                }
            }
            this.columnTypes.add(columnType);
            buffer.append("[").append(string).append("],");
            paramsBuffer.append("?,");
            if (this.primaryKeyColumns != null && this.primaryKeyColumns.contains(string)) {
                this.pKeyUserProps.add(string);
                pKeyColumnListBuffer.append("[").append(string).append("] = ?,");
                continue;
            }
            this.notPKeyUserProps.add(string);
            notPKeyColumnListBuffer.append("[").append(string).append("] = ?,");
        }
        if (pKeyColumnListBuffer.length() > 0 && pKeyColumnListBuffer.charAt(pKeyColumnListBuffer.length() - 1) == ',') {
            pKeyColumnListBuffer.setLength(pKeyColumnListBuffer.length() - 1);
        }
        if (notPKeyColumnListBuffer.length() > 0 && notPKeyColumnListBuffer.charAt(notPKeyColumnListBuffer.length() - 1) == ',') {
            notPKeyColumnListBuffer.setLength(notPKeyColumnListBuffer.length() - 1);
        }
        this.columnList = buffer.toString();
        this.paramsList = paramsBuffer.toString();
        this.pKeyColumnList = pKeyColumnListBuffer.toString();
        this.notPKeyColumnList = notPKeyColumnListBuffer.toString();
    }

    private void addAllSystemAndUserProperties(EventDatagram datagram, boolean includeEventId, Collection collection, boolean isProcessQueue) {
        if (includeEventId || collection == null) {
            this.systemProps.add(SystemProperty.EventId);
        }
        if (isProcessQueue) {
            this.systemProps.add(SystemProperty.ProcessId);
        } else {
            this.systemProps.add(SystemProperty.CorrelationId);
        }
        this.systemProps.add(SystemProperty.EventGroupId);
        this.systemProps.add(SystemProperty.EventKey);
        this.systemProps.add(SystemProperty.EventSource);
        this.systemProps.add(SystemProperty.EventReplyTo);
        this.systemProps.add(SystemProperty.EventForwardTo);
        this.systemProps.add(SystemProperty.EventExpiration);
        this.systemProps.add(SystemProperty.Timestamp);
        if (datagram != null) {
            for (String property : datagram.getEventPropertyNames()) {
                this.userProps.add(property);
            }
        }
    }

    public String getColumnsNames() {
        return this.columnList;
    }

    public String getParamsList() {
        return this.paramsList;
    }

    public void addPropertyColumns(Table table) {
        for (ColumnSchema column : this.getColumnDefinitions(table.getObjectName())) {
            table.addColumn(column);
        }
    }

    public List<ColumnSchema> getColumnDefinitions(NameManager.ObjectName tableName) {
        ColumnSchema column;
        NameManager.ObjectName columnName;
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        int index = -1;
        for (SystemProperty systemProperty : this.systemProps) {
            columnName = NameManager.newInfoSchemaColumnName(systemProperty.name(), tableName);
            column = new ColumnSchema(columnName, this.columnTypes.get(++index), true, false, null);
            columns.add(column);
        }
        for (Map.Entry entry : this.systemUserProps.entrySet()) {
            columnName = NameManager.newInfoSchemaColumnName((String)entry.getKey(), tableName);
            column = new ColumnSchema(columnName, this.columnTypes.get(++index), true, false, null);
            columns.add(column);
        }
        for (String string : this.userProps) {
            columnName = NameManager.newInfoSchemaColumnName(string, tableName);
            column = new ColumnSchema(columnName, this.columnTypes.get(++index), true, false, null);
            columns.add(column);
        }
        return columns;
    }

    public int setColumnValues(Session session, ImmutableEventDatagram event, Object[] params, int index, AbstractDataspace dataspace) throws SQLException {
        return this.doSetColumnValues(session, event, params, index, dataspace, this.systemProps, this.userProps);
    }

    public int setPrimaryKeyColumnValues(Session session, ImmutableEventDatagram event, Object[] params, int index, AbstractDataspace dataspace) throws SQLException {
        return this.doSetColumnValues(session, event, params, index, dataspace, this.pKeySystemProps, this.pKeyUserProps);
    }

    public int setNotPrimaryKeyColumnValues(Session session, ImmutableEventDatagram event, Object[] params, int index, AbstractDataspace dataspace) throws SQLException {
        return this.doSetColumnValues(session, event, params, index, dataspace, this.notPKeySystemProps, this.notPKeyUserProps);
    }

    private int doSetColumnValues(Session session, ImmutableEventDatagram event, Object[] params, int index, AbstractDataspace dataspace, List<SystemProperty> sysProperties, List<String> userProperties) throws SQLException {
        EventDatagram datagram = null;
        AdvisoryEventDatagram advisoryEventDatagram = null;
        if (event instanceof EventDatagram) {
            datagram = (EventDatagram)event;
        }
        if (event instanceof AdvisoryEventDatagram) {
            advisoryEventDatagram = (AdvisoryEventDatagram)event;
        }
        for (SystemProperty systemProperty : sysProperties) {
            switch (systemProperty.ordinal()) {
                case 1: {
                    params[++index] = event.getEventId();
                    break;
                }
                case 4: 
                case 9: {
                    if (datagram != null) {
                        params[++index] = datagram.getCorrelationId();
                        break;
                    }
                    if (advisoryEventDatagram != null) {
                        params[++index] = advisoryEventDatagram.getCorrelationId();
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 3: {
                    if (datagram != null) {
                        params[++index] = datagram.getEventGroupId();
                        break;
                    }
                    if (advisoryEventDatagram != null) {
                        params[++index] = advisoryEventDatagram.getEventGroupId();
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 2: {
                    if (datagram != null) {
                        params[++index] = datagram.getEventKey();
                        break;
                    }
                    if (advisoryEventDatagram != null) {
                        params[++index] = advisoryEventDatagram.getEventKey();
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 6: {
                    if (datagram != null) {
                        params[++index] = datagram.getForwardTo();
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 5: {
                    if (datagram != null) {
                        params[++index] = datagram.getReplyTo();
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 0: {
                    if (dataspace != null && event.getEventSource() != null) {
                        FabricAddress source = new FabricAddress(event.getEventSource());
                        ComponentReference component = dataspace.getModerator().lookupComponent(source);
                        String sourceName = component != null ? component.getName() : "Unknown";
                        params[++index] = sourceName;
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 8: {
                    if (datagram != null) {
                        params[++index] = session.getSqlTimestamp(datagram.getEventExpiration());
                        if (datagram.getEventExpiration() != 0L || this.windowCollection == null || this.windowCollection.getWindowType() != CollectionWindowType.BATCH_TIME_WINDOW && this.windowCollection.getWindowType() != CollectionWindowType.SLIDING_TIME_WINDOW || this.windowCollection.getTimeWindowUnit() == null) break;
                        TimestampData current = session.getCurrentSqlTimestamp();
                        current = new TimestampData(current.getMilliseconds() + this.windowCollection.getTimeWindowUnit().toMillis(this.windowCollection.getWindowSize()), current.getNanos(), current.getZone());
                        params[index] = current;
                        break;
                    }
                    params[++index] = null;
                    break;
                }
                case 7: {
                    params[++index] = session.getSqlTimestamp(event.getTimestamp().getTime());
                }
            }
        }
        if (datagram != null) {
            Object value;
            for (Map.Entry entry : this.systemUserProps.entrySet()) {
                try {
                    value = ((EventSystemPropertiesGetters.SystemPropertyGetter)entry.getValue()).get(datagram);
                    if (value != null) {
                        if (value instanceof Float) {
                            value = ((Float)value).doubleValue();
                        } else if (value instanceof Byte || value instanceof Short) {
                            value = ((Number)value).intValue();
                        }
                    }
                    params[++index] = value;
                }
                catch (Exception error) {
                    throw new SQLException(error.getMessage());
                }
            }
            for (String string : userProperties) {
                try {
                    value = datagram.getEventObjectProperty(string);
                    if (datagram instanceof AuditEvent && string.equals("Severity")) {
                        value = ((AuditEvent)datagram).getSeverity().toString();
                    }
                    if (value != null) {
                        if (this.prototypeDatagram == null) {
                            value = value.toString();
                        }
                        if (value instanceof Float) {
                            value = ((Float)value).doubleValue();
                        } else if (value instanceof Byte || value instanceof Short) {
                            value = ((Number)value).intValue();
                        }
                    }
                    params[++index] = value;
                }
                catch (Exception error) {
                    throw new SQLException(error.getMessage());
                }
            }
        }
        return index;
    }

    protected Type resolveSQLType(String propertyName, EventDatagram datagram) throws SDOException {
        PropertyType propType = datagram.getEventPropertyType(propertyName);
        if (propType == null) {
            return Type.STRING;
        }
        switch (propType) {
            case Boolean: {
                return Type.SQL_BOOLEAN;
            }
            case Byte: 
            case Short: 
            case Integer: {
                return Type.SQL_INTEGER;
            }
            case Float: 
            case Double: {
                return Type.SQL_DOUBLE;
            }
            case Long: {
                return Type.LONG;
            }
            case String: {
                return Type.STRING;
            }
            case BigDecimal: {
                Object propValue = datagram.getEventObjectProperty(propertyName);
                return new NumberType(3, EventPropertyValidator.getBigDecimalPrecision(propValue), EventPropertyValidator.getBigDecimalScale(propValue));
            }
        }
        throw new DataspaceException("Unable to get '" + propertyName + "' property type.");
    }

    public int getColumnsCount() {
        return this.columnTypes.size();
    }

    public int getPrimaryKeyColumnsCount() {
        return this.primaryKeyColumns != null ? this.primaryKeyColumns.size() : 0;
    }

    public int getNotPrimaryKeyColumnsCount() {
        return this.notPKeySystemProps.size() + this.notPKeyUserProps.size();
    }

    public String getPrimaryKeyColumnNamesWithParams() {
        return this.pKeyColumnList;
    }

    public String getNotPrimaryKeyColumnNamesWithParams() {
        return this.notPKeyColumnList;
    }

    public int[] getPrimaryKeyColumnIndices(int offset) {
        return this.primaryKeyColumns.stream().map(primaryKeyColumnName -> {
            int systemPropIndex = IntStream.range(0, this.systemProps.size()).filter(i -> primaryKeyColumnName.equals(this.systemProps.get(i).name())).findFirst().orElse(-1);
            if (systemPropIndex == -1) {
                int userPropIndex = this.userProps.indexOf(primaryKeyColumnName);
                if (userPropIndex != -1) {
                    return this.systemProps.size() + userPropIndex + offset;
                }
                throw new DataspaceException("Unable to find column for primary key column '" + primaryKeyColumnName + "'");
            }
            return systemPropIndex + offset;
        }).mapToInt(Integer::intValue).toArray();
    }

    public static enum SystemProperty {
        EventSource,
        EventId,
        EventKey,
        EventGroupId,
        CorrelationId,
        EventReplyTo,
        EventForwardTo,
        Timestamp,
        EventExpiration,
        ProcessId;

    }
}

