/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.utils;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.parser.Tokens;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class DDLCollectionFormatter {
    private static final String INITIAL_LINE = System.lineSeparator();
    private static final String INDENT = "   ";
    private static final String OTHER_LINES = System.lineSeparator() + "   ";
    private static final Set reservedWords = Tokens.reservedKeys.keySet();
    private static final Set commandWords = Tokens.commandSet.keySet();
    private NameManager.ObjectName objectName;

    public DDLCollectionFormatter(NameManager.ObjectName objectName) {
        this.objectName = objectName;
    }

    public String format(String sql) {
        String sqlLow = sql.toLowerCase();
        if (sqlLow.startsWith("create index")) {
            return this.formatOther(sql);
        }
        if (sql.toLowerCase().startsWith("create")) {
            return this.formatCreateTable(sql);
        }
        return this.formatOther(sql);
    }

    public String format(List<String> sqls) {
        LinkedList<String> sqlList = new LinkedList<String>();
        for (String sql : sqls) {
            sqlList.add(this.format(sql));
        }
        return String.join((CharSequence)";\n\n", sqlList);
    }

    private String formatOther(String sql) {
        return String.join((CharSequence)"", this.tokenize(sql));
    }

    private String formatCreateTable(String sql) {
        sql = this.quoteName(sql);
        StringBuilder result = new StringBuilder().append(INITIAL_LINE);
        List<String> tList = this.tokenize(sql);
        int depth = 0;
        boolean quoted = false;
        boolean forceBracketNl = false;
        for (int i = 0; i < tList.size(); ++i) {
            String token = tList.get(i);
            String nextToken = null;
            String next2Token = null;
            if (i + 1 < tList.size()) {
                nextToken = tList.get(i + 1);
            }
            if (i + 2 < tList.size()) {
                next2Token = tList.get(i + 2);
            }
            if (DDLCollectionFormatter.isQuote(token)) {
                quoted = !quoted;
                result.append(token);
            } else if (quoted) {
                result.append(token);
            } else {
                if (")".equals(token)) {
                    if (--depth == 0) {
                        result.append(INITIAL_LINE);
                    }
                } else if ("constrained".equals(token) && "by".equals(next2Token)) {
                    result.append(OTHER_LINES);
                    depth = 1;
                } else if ("with".equals(token) && "source".equals(next2Token)) {
                    result.append(OTHER_LINES);
                } else if ("when".equals(token) && "(".equals(nextToken)) {
                    result.append(OTHER_LINES);
                    result.append(INDENT);
                } else if ("include".equals(token) && "properties".equals(next2Token)) {
                    result.append(OTHER_LINES);
                    result.append(INDENT);
                    depth = 2;
                    forceBracketNl = true;
                }
                result.append(token);
                if (",".equals(token) && depth > 0) {
                    result.append(INITIAL_LINE);
                    result.append(StringUtils.repeat((String)INDENT, (int)depth));
                }
                if ("(".equals(token)) {
                    if (++depth == 1) {
                        result.append(OTHER_LINES);
                    } else if (forceBracketNl) {
                        forceBracketNl = false;
                        result.append(INITIAL_LINE);
                        result.append(StringUtils.repeat((String)INDENT, (int)depth));
                    }
                }
            }
            if (!"(".equals(nextToken)) continue;
            result.append(" ");
        }
        return result.toString();
    }

    private List<String> tokenize(String sql) {
        StringTokenizer tokens = new StringTokenizer(sql, " (,)'[]\"", true);
        LinkedList<String> tList = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            tList.add(reservedWords.contains(token) || commandWords.contains(token) ? token.toLowerCase() : token);
        }
        return tList;
    }

    private String quoteName(String sql) {
        String fullyQuoted = NameManager.quoteName(this.objectName.schema.name) + "." + NameManager.quoteName(this.objectName.name);
        return sql.replace(this.objectName.getSchemaQualifiedStatementName(), fullyQuoted);
    }

    private static boolean isQuote(String tok) {
        return "\"".equals(tok) || "`".equals(tok) || "]".equals(tok) || "[".equals(tok) || "'".equals(tok);
    }
}

