/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SemanticTypeAndPrototypeSchemaObjectsCache;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.types.Type;

public class UserTypeModifier {
    private final NameManager.ObjectName name;
    private final int objectType;
    public final Type dataType;
    private Constraint[] constraints = Constraint.emptyArray;
    private Expression defaultExpression;
    private boolean isNullable = true;
    private DataspaceStateHolder stateHolder = new DataspaceStateHolder();

    public UserTypeModifier(NameManager.ObjectName name, int objectType, Type dataType) {
        this.name = name;
        this.objectType = objectType;
        this.dataType = dataType;
    }

    public void addConstraint(Constraint c) {
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, this.constraints.length + 1);
        this.constraints[this.constraints.length - 1] = c;
        this.setNotNull();
    }

    public void removeConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getObjectName().name.equals(name)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getObjectName().name.equals(name)) continue;
            return this.constraints[i];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].isNotNull()) continue;
            this.isNullable = false;
        }
    }

    public int getObjectType() {
        return this.objectType;
    }

    public NameManager.ObjectName getName() {
        return this.name;
    }

    public NameManager.ObjectName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.objectType == 13) {
            set.add(SemanticTypeAndPrototypeSchemaObjectsCache.createOrGetSemanticTypeObjectName(this.name.name));
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            OrderedHashSet subSet = this.constraints[i].getReferences();
            if (subSet == null) continue;
            set.addAll(subSet);
        }
        return set;
    }

    public final OrderedHashSet getComponents() {
        if (this.constraints == null) {
            return null;
        }
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.constraints);
        return set;
    }

    public void compile(Session session) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        if (this.objectType == 13) {
            builder.append("CREATE").append(' ').append("TYPE").append(' ');
            builder.append(this.name.getSchemaQualifiedStatementName());
            builder.append(' ').append("AS").append(' ');
            builder.append(this.dataType.getDefinition());
            if (this.dataType.hasCollation()) {
                builder.append(' ').append("COLLATE").append(' ');
                builder.append(this.dataType.getCollationDefinition());
            }
        } else {
            builder.append("CREATE").append(' ').append("DOMAIN").append(' ');
            builder.append(this.name.getSchemaQualifiedStatementName());
            builder.append(' ').append("AS").append(' ');
            builder.append(this.dataType.getDefinition());
            if (this.defaultExpression != null) {
                builder.append(' ').append("DEFAULT").append(' ');
                builder.append(this.defaultExpression.getSQL());
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                builder.append(' ').append("CONSTRAINT").append(' ');
                builder.append(this.constraints[i].getObjectName().statementName).append(' ');
                builder.append("CHECK").append('(').append(this.constraints[i].getCheckSQL()).append(')');
            }
        }
        return builder.toString();
    }

    public DataspaceStateHolder getStateHolder() {
        return this.stateHolder;
    }

    public DataspaceStateHolder aggregateStateHolder() {
        DataspaceStateHolder state = new DataspaceStateHolder();
        OrderedHashSet references = this.getReferences();
        for (int i = 0; i < references.size(); ++i) {
            NameManager.ObjectName reference = (NameManager.ObjectName)references.get(i);
            if (reference.type == 35) {
                DataspaceStateHolder.validateSemanticType(state, reference.name);
                continue;
            }
            if (reference.type == 39) {
                DataspaceStateHolder.validateFileDescriptor(state, reference.name);
                continue;
            }
            if (reference.type != 40) continue;
            DataspaceStateHolder.validateConnectionFactory(state, reference.name);
        }
        return state;
    }

    public void exposeStateHolder(RowSetNavigatorClient navigator) {
        this.aggregateStateHolder().exposeState(navigator, false, false, "State", DataspaceStateHolder.SemanticTypeSuspectStateOriginator.class);
    }
}

