/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.IntKeyHashMap;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.AspectsType;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BitType;
import com.streamscape.ds.types.BlobType;
import com.streamscape.ds.types.BooleanType;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.Charset;
import com.streamscape.ds.types.ClobType;
import com.streamscape.ds.types.Collation;
import com.streamscape.ds.types.DataspaceCollectionType;
import com.streamscape.ds.types.DataspaceType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.DropboxType;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.FacetsType;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NullType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.RuntimeType;
import com.streamscape.ds.types.ServerType;
import com.streamscape.ds.types.ServiceType;
import com.streamscape.ds.types.UserTypeModifier;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public abstract class Type
implements SchemaObject,
Cloneable {
    public static final Type[] emptyArray = new Type[0];
    public int typeComparisonGroup;
    public int typeCode;
    public long precision;
    public int scale;
    public UserTypeModifier userTypeModifier;
    public static final Type SQL_ALL_TYPES = NullType.getNullType();
    public static final CharacterType SQL_CHAR = new CharacterType(1, 1L);
    public static final CharacterType SQL_CHAR_16 = new CharacterType(1, 16L);
    public static final CharacterType SQL_CHAR_DEFAULT = new CharacterType(1, 256L);
    public static final CharacterType SQL_VARCHAR = new CharacterType(12, 0L);
    public static final CharacterType SQL_VARCHAR_DEFAULT = new CharacterType(12, 32768L);
    public static final ClobType SQL_CLOB = new ClobType(0x1000000L);
    public static final CharacterType VARCHAR_IGNORECASE = new CharacterType(100, 0L);
    public static final CharacterType VARCHAR_IGNORECASE_DEFAULT = new CharacterType(100, 32768L);
    public static final BitType SQL_BIT = new BitType(14, 1L);
    public static final BitType SQL_BIT_VARYING = new BitType(15, 1L);
    public static final BitType SQL_BIT_VARYING_MAX_LENGTH = new BitType(15, 1024L);
    public static final FlobType FLOB = new FlobType();
    public static final BinaryType SQL_BINARY = new BinaryType(60, 1L);
    public static final BinaryType SQL_BINARY_16 = new BinaryType(60, 16L);
    public static final BinaryType SQL_BINARY_DEFAULT = new BinaryType(60, 32768L);
    public static final BinaryType SQL_VARBINARY = new BinaryType(61, 0L);
    public static final BinaryType SQL_VARBINARY_DEFAULT = new BinaryType(61, 32768L);
    public static final BlobType SQL_BLOB = new BlobType(0x1000000L);
    public static final CharacterType STRING = new CharacterType(1112, Integer.MAX_VALUE);
    public static final CharacterType CATEGORY = new CharacterType(1121, Integer.MAX_VALUE);
    public static final OtherType OTHER = new OtherType();
    public static final EventType EVENT = new EventType();
    public static final DataspaceType DATASPACE = new DataspaceType();
    public static final RuntimeType RUNTIME = new RuntimeType();
    public static final DataspaceCollectionType DATASPACE_COLLECTION = new DataspaceCollectionType();
    public static final ServiceType SERVICE = new ServiceType();
    public static final BooleanType SQL_BOOLEAN = BooleanType.getBooleanType();
    public static final ServerType SERVER_TYPE = new ServerType();
    public static final DropboxType DROPBOX_TYPE = new DropboxType();
    public static final NumberType SQL_NUMERIC = new NumberType(2, 128L, 0);
    public static final NumberType SQL_DECIMAL = new NumberType(3, 128L, 0);
    public static final NumberType SQL_BIGINT = new NumberType(25, 128L, 0);
    public static final NumberType SQL_DECIMAL_DEFAULT = new NumberType(3, 128L, 32);
    public static final NumberType SQL_DECIMAL_BIGINT_SQR = new NumberType(3, 40L, 0);
    public static final NumberType SQL_DOUBLE = new NumberType(8, 0L, 0);
    public static final NumberType SQL_FLOAT = new NumberType(6, 0L, 0);
    public static final NumberType TINYINT = new NumberType(-6, 3L, 0);
    public static final NumberType SQL_SMALLINT = new NumberType(5, 5L, 0);
    public static final NumberType SQL_INTEGER = new NumberType(4, 10L, 0);
    public static final NumberType LONG = new NumberType(1117, 19L, 0);
    public static final DateTimeType SQL_DATE = new DateTimeType(93, 91, 0);
    public static final DateTimeType SQL_TIME = new DateTimeType(93, 92, 0);
    public static final DateTimeType SQL_TIME_WITH_TIME_ZONE = new DateTimeType(93, 94, 0);
    public static final DateTimeType SQL_TIMESTAMP = new DateTimeType(93, 93, 6);
    public static final DateTimeType SQL_TIMESTAMP_WITH_TIME_ZONE = new DateTimeType(93, 95, 6);
    public static final DateTimeType SQL_TIMESTAMP_NO_FRACTION = new DateTimeType(93, 93, 0);
    public static final IntervalType SQL_INTERVAL_YEAR = IntervalType.newIntervalType(101, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH = IntervalType.newIntervalType(102, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY = IntervalType.newIntervalType(103, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR = IntervalType.newIntervalType(104, 2L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE = IntervalType.newIntervalType(105, 2L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND = IntervalType.newIntervalType(106, 2L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION = IntervalType.newIntervalType(106, 2L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH = IntervalType.newIntervalType(107, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_HOUR = IntervalType.newIntervalType(108, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_MINUTE = IntervalType.newIntervalType(109, 2L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND = IntervalType.newIntervalType(110, 2L, 6);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_MINUTE = IntervalType.newIntervalType(111, 2L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_TO_SECOND = IntervalType.newIntervalType(112, 2L, 6);
    public static final IntervalType SQL_INTERVAL_MINUTE_TO_SECOND = IntervalType.newIntervalType(113, 2L, 6);
    public static final IntervalType SQL_INTERVAL_YEAR_MAX_PRECISION = IntervalType.newIntervalType(101, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MONTH_MAX_PRECISION = IntervalType.newIntervalType(102, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_MAX_PRECISION = IntervalType.newIntervalType(103, 9L, 0);
    public static final IntervalType SQL_INTERVAL_HOUR_MAX_PRECISION = IntervalType.newIntervalType(104, 9L, 0);
    public static final IntervalType SQL_INTERVAL_MINUTE_MAX_PRECISION = IntervalType.newIntervalType(105, 9L, 0);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_PRECISION = IntervalType.newIntervalType(106, 9L, 6);
    public static final IntervalType SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION = IntervalType.newIntervalType(106, 9L, 9);
    public static final IntervalType SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION = IntervalType.newIntervalType(107, 9L, 0);
    public static final IntervalType SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION = IntervalType.newIntervalType(110, 9L, 9);
    public static final ArrayType SQL_ARRAY_ALL_TYPES = new ArrayType(SQL_ALL_TYPES, -1);
    public static final IntValueHashMap typeAliases;
    public static final IntValueHashMap typeNames;
    public static final IntKeyHashMap jdbcConvertTypes;
    private static final Map<String, OtherType> systemTypes;

    Type(int typeGroup, int type, long precision, int scale) {
        this.typeComparisonGroup = typeGroup;
        this.typeCode = type;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public final int getObjectType() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getObjectType();
    }

    @Override
    public final NameManager.ObjectName getObjectName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getName();
    }

    @Override
    public final NameManager.ObjectName getCatalogName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName().schema;
    }

    @Override
    public final NameManager.ObjectName getSchemaName() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSchemaName();
    }

    @Override
    public final Grantee getOwner() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getOwner();
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getReferences();
    }

    @Override
    public final OrderedHashSet getComponents() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getComponents();
    }

    @Override
    public final void compile(Session session, SchemaObject parentObject) {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        this.userTypeModifier.compile(session);
    }

    @Override
    public String getSQL() {
        if (this.userTypeModifier == null) {
            throw Error.runtimeError(201, "Type");
        }
        return this.userTypeModifier.getSQL();
    }

    @Override
    public String getSQL(String name) {
        return this.getSQL();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public Type duplicate() {
        try {
            return (Type)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Error.runtimeError(201, "Type");
        }
    }

    public abstract int displaySize();

    public abstract int getJDBCTypeCode();

    public abstract String getJDBCClassName();

    public abstract Class<?> getJDBCClass();

    public abstract Class<?> getInternalClass(Session var1);

    public int getJDBCScale() {
        return this.scale;
    }

    public int getJDBCPrecision() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public abstract String getNameString();

    public String getFullNameString() {
        return this.getNameString();
    }

    public abstract String getDefinition();

    public boolean hasCollation() {
        return false;
    }

    public String getCollationDefinition() {
        return "";
    }

    public Collation getCollation() {
        return null;
    }

    public Charset getCharacterSet() {
        return null;
    }

    public String getTypeDefinition() {
        if (this.userTypeModifier == null) {
            return this.getDefinition();
        }
        return this.getObjectName().name;
    }

    public abstract int compare(Session var1, Object var2, Object var3);

    public int compare(Session session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return sort.sortNullsLast[0] ? 1 : -1;
        }
        if (b == null) {
            return sort.sortNullsLast[0] ? -1 : 1;
        }
        int result = this.compare(session, a, b);
        return sort.sortDescending[0] ? -result : result;
    }

    public abstract Object convertToTypeLimits(SessionInterface var1, Object var2);

    public Object castToType(SessionInterface session, Object a, Type type) {
        return this.convertToType(session, a, type);
    }

    public abstract Object convertToType(SessionInterface var1, Object var2, Type var3);

    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (otherType.isLobType()) {
            throw Error.error(5561);
        }
        return this.convertToType(session, a, otherType);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return a;
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        return a;
    }

    public Object convertSQLToJDBC(SessionInterface session, Object a) {
        return this.convertSQLToJava(session, a);
    }

    public abstract Object convertToDefaultType(SessionInterface var1, Object var2);

    public abstract String convertToString(Object var1);

    public abstract String convertToSQLString(Object var1);

    public abstract boolean canConvertFrom(Type var1);

    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        return -1;
    }

    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        return otherType.typeCode == 0 || this.typeComparisonGroup == otherType.typeComparisonGroup;
    }

    public int arrayLimitCardinality() {
        return 0;
    }

    public Type collectionBaseType() {
        return null;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isSetType() {
        return false;
    }

    public boolean isCollectionType() {
        return false;
    }

    public boolean isMultisetType() {
        return false;
    }

    public boolean isRowType() {
        return false;
    }

    public boolean isStructuredType() {
        return false;
    }

    public boolean isCharacterType() {
        return false;
    }

    public boolean isNumberType() {
        return false;
    }

    public boolean isIntegralType() {
        return false;
    }

    public boolean isExactNumberType() {
        return false;
    }

    public boolean isDecimalType() {
        return false;
    }

    public boolean isDateTimeType() {
        return false;
    }

    public boolean isDateTimeTypeWithZone() {
        return false;
    }

    public boolean isIntervalType() {
        return false;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isBooleanType() {
        return false;
    }

    public boolean isLobType() {
        return false;
    }

    public boolean isFlobType() {
        return false;
    }

    public boolean isBitType() {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isDistinctType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.getObjectType() == 13;
    }

    public boolean isDomainType() {
        return this.userTypeModifier == null ? false : this.userTypeModifier.getObjectType() == 14;
    }

    public boolean acceptsPrecision() {
        return false;
    }

    public boolean requiresPrecision() {
        return false;
    }

    public long getMaxPrecision() {
        return 0L;
    }

    public int getMaxScale() {
        return 0;
    }

    public int getPrecisionRadix() {
        return 0;
    }

    public boolean acceptsFractionalPrecision() {
        return false;
    }

    public boolean acceptsScale() {
        return false;
    }

    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            if (this.typeCode == 50) {
                return this.collectionBaseType().precedenceDegree(other.collectionBaseType());
            }
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public abstract Type getAggregateType(Type var1);

    public abstract Type getCombinedType(Session var1, Type var2, int var3);

    public int compareToTypeRange(Object o) {
        return 0;
    }

    public Object absolute(Object a) {
        throw Error.runtimeError(201, "Type");
    }

    public Object negate(Object a) {
        throw Error.runtimeError(201, "Type");
    }

    public Object add(Object a, Object b, Type otherType) {
        throw Error.runtimeError(201, "Type");
    }

    public Object subtract(Object a, Object b, Type otherType) {
        throw Error.runtimeError(201, "Type");
    }

    public Object multiply(Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public Object divide(Session session, Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public Object concat(Session session, Object a, Object b) {
        throw Error.runtimeError(201, "Type");
    }

    public int cardinality(Session session, Object a) {
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (((Type)other).typeCode == 50) {
                return false;
            }
            if (((Type)other).typeCode == 19) {
                return false;
            }
            return ((Type)other).typeCode == this.typeCode && ((Type)other).precision == this.precision && ((Type)other).scale == this.scale && ((Type)other).userTypeModifier == this.userTypeModifier;
        }
        return false;
    }

    public int hashCode() {
        return this.typeCode + (int)this.precision << 8 + this.scale << 16;
    }

    public static TypedComparator newComparator(Session session) {
        return new TypedComparator(session);
    }

    public static ArrayType getDefaultArrayType(int type) {
        return new ArrayType(Type.getDefaultType(type), -1);
    }

    public static Type getDefaultType(int type) {
        return Type.getDefaultType(type, 0, 0);
    }

    public static Type getDefaultType(ColumnDescriptor columnDescriptor) {
        SQLType type = columnDescriptor.getType();
        int jdbcType = type.getType();
        if (type == SQLType.STRING) {
            jdbcType = 1112;
        } else if (type == SQLType.CATEGORY) {
            jdbcType = 1121;
        }
        return Type.getDefaultType(jdbcType, columnDescriptor.getPrecision(), columnDescriptor.getScale());
    }

    public static Type getDefaultType(int type, int precision, int scale) {
        try {
            return Type.getType(type, SQL_VARCHAR.getCharacterSet(), SQL_VARCHAR.getCollation(), precision, scale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Type getDefaultTypeWithSize(int type) {
        switch (type) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case 50: {
                return SQL_ARRAY_ALL_TYPES;
            }
            case 1: {
                return SQL_CHAR_DEFAULT;
            }
            case 12: {
                return SQL_VARCHAR_DEFAULT;
            }
            case 100: {
                return VARCHAR_IGNORECASE_DEFAULT;
            }
            case 40: {
                return SQL_CLOB;
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case 25: {
                return SQL_BIGINT;
            }
            case -6: {
                return TINYINT;
            }
            case 6: 
            case 7: 
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: {
                return SQL_NUMERIC;
            }
            case 3: {
                return SQL_DECIMAL;
            }
            case 16: {
                return SQL_BOOLEAN;
            }
            case 60: {
                return SQL_BINARY_DEFAULT;
            }
            case 61: {
                return SQL_VARBINARY_DEFAULT;
            }
            case 30: {
                return SQL_BLOB;
            }
            case 14: {
                return SQL_BIT;
            }
            case 15: {
                return SQL_BIT_VARYING;
            }
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                return SQL_TIME;
            }
            case 94: {
                return SQL_TIME_WITH_TIME_ZONE;
            }
            case 93: {
                return SQL_TIMESTAMP;
            }
            case 95: {
                return SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
            case 101: {
                return SQL_INTERVAL_YEAR;
            }
            case 107: {
                return SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 102: {
                return SQL_INTERVAL_MONTH;
            }
            case 103: {
                return SQL_INTERVAL_DAY;
            }
            case 108: {
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                return SQL_INTERVAL_HOUR;
            }
            case 111: {
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 112: {
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 105: {
                return SQL_INTERVAL_MINUTE;
            }
            case 113: {
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                return SQL_INTERVAL_SECOND;
            }
            case 1111: {
                return OTHER;
            }
            case 1113: {
                return EVENT;
            }
            case 1117: {
                return LONG;
            }
        }
        return null;
    }

    public static int getHSQLDBTypeCode(int jdbcTypeNumber) {
        switch (jdbcTypeNumber) {
            case -5: {
                return 25;
            }
            case -1: {
                return 12;
            }
            case 2005: {
                return 40;
            }
            case -2: {
                return 60;
            }
            case -7: {
                return 15;
            }
            case -4: 
            case -3: {
                return 61;
            }
            case 2004: {
                return 30;
            }
            case 2003: {
                return 50;
            }
        }
        return jdbcTypeNumber;
    }

    public static int getJDBCTypeCode(int type) {
        switch (type) {
            case 30: {
                return 2004;
            }
            case 40: {
                return 2005;
            }
            case 25: {
                return -5;
            }
            case 1117: {
                return -5;
            }
            case 60: {
                return -2;
            }
            case 61: {
                return -3;
            }
            case 14: 
            case 15: {
                return -7;
            }
            case 50: {
                return 2003;
            }
        }
        return type;
    }

    public static Type getType(int type, Charset charset, Collation collation, long precision, int scale) {
        switch (type) {
            case 0: {
                return SQL_ALL_TYPES;
            }
            case -9: {
                type = 12;
            }
            case -1: 
            case 1: 
            case 12: 
            case 40: 
            case 100: {
                return CharacterType.getCharacterType(type, precision, collation);
            }
            case 4: {
                return SQL_INTEGER;
            }
            case 5: {
                return SQL_SMALLINT;
            }
            case -5: 
            case 25: {
                if (precision == 0L) {
                    precision = 128L;
                }
                return NumberType.getNumberType(25, precision, scale);
            }
            case 1117: {
                return LONG;
            }
            case -6: {
                return TINYINT;
            }
            case 6: 
            case 7: {
                if (precision > 53L) {
                    throw Error.error(5592, "" + precision);
                }
                return SQL_FLOAT;
            }
            case 8: {
                return SQL_DOUBLE;
            }
            case 2: 
            case 3: {
                if (precision == 0L) {
                    precision = 128L;
                }
                return NumberType.getNumberType(type, precision, scale);
            }
            case -7: 
            case 16: {
                return SQL_BOOLEAN;
            }
            case -4: 
            case -3: 
            case -2: 
            case 30: 
            case 60: 
            case 61: {
                return BinaryType.getBinaryType(type, precision);
            }
            case 14: 
            case 15: {
                return BitType.getBitType(type, precision);
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return DateTimeType.getDateTimeType(type, scale);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalType.getIntervalType(type, precision, scale);
            }
            case 1111: {
                return OTHER;
            }
            case 1113: {
                return EVENT;
            }
            case 1112: {
                return STRING;
            }
            case 1121: {
                return CATEGORY;
            }
            case 1114: {
                return DATASPACE;
            }
            case 1115: {
                return DATASPACE_COLLECTION;
            }
            case 1116: {
                return SERVICE;
            }
            case 1118: {
                return RUNTIME;
            }
            case 1120: {
                return SERVER_TYPE;
            }
            case 1124: {
                return DROPBOX_TYPE;
            }
            case 1119: {
                return new FlobType();
            }
            case 1122: {
                return FacetsType.DEFAULT;
            }
            case 1123: {
                return AspectsType.DEFAULT;
            }
        }
        throw Error.runtimeError(201, "Unknown data type with code : " + type);
    }

    public static Type getAggregateType(Type add, Type existing) {
        if (existing == null || existing.typeCode == 0) {
            return add;
        }
        if (add == null || add.typeCode == 0) {
            return existing;
        }
        return existing.getAggregateType(add);
    }

    private static void registerSystemType(String name, Class<?> clazz) {
        systemTypes.put(name.toUpperCase(), new OtherType(name, clazz));
    }

    public static Type getSystemType(String name) {
        return systemTypes.get(name.toUpperCase());
    }

    public static int getTypeCode(String name) {
        int i = typeNames.get((Object)name, Integer.MIN_VALUE);
        if (i != Integer.MIN_VALUE) {
            return i;
        }
        i = typeAliases.get((Object)name, Integer.MIN_VALUE);
        if (i != Integer.MIN_VALUE) {
            return i;
        }
        i = typeNames.get((Object)name.toUpperCase(), Integer.MIN_VALUE);
        if (i != Integer.MIN_VALUE) {
            return i;
        }
        i = typeAliases.get((Object)name.toUpperCase(), Integer.MIN_VALUE);
        return i;
    }

    public static String getTypeName(int code) {
        int value;
        String typeName;
        Iterator iter = typeNames.keySet().iterator();
        while (iter.hasNext()) {
            typeName = (String)iter.next();
            value = typeNames.get(typeName);
            if (value != code) continue;
            return typeName;
        }
        iter = typeAliases.keySet().iterator();
        while (iter.hasNext()) {
            typeName = (String)iter.next();
            value = typeAliases.get(typeName);
            if (value != code) continue;
            return typeName;
        }
        return null;
    }

    public static Type getTypeForJDBCConvertToken(int name) {
        return (Type)jdbcConvertTypes.get(name);
    }

    public static boolean isSupportedSQLType(int typeNumber) {
        return Type.getDefaultType(typeNumber) != null;
    }

    public static boolean matches(Type[] one, Type[] other) {
        for (int i = 0; i < one.length; ++i) {
            if (one[i].typeCode == other[i].typeCode) continue;
            return false;
        }
        return true;
    }

    public static Type resolveType(Session session, Class<?> clazz, int width) {
        if (clazz.isArray()) {
            Type type = Type.resolveSimpleType(session, clazz.getComponentType(), -1);
            if (type == null) {
                type = new OtherType();
            }
            return new ArrayType(type, width >= 0 ? width : -1);
        }
        return Type.resolveSimpleType(session, clazz, width);
    }

    private static Type resolveSimpleType(Session session, Class<?> clazz, int width) {
        clazz = TypeFactory.unwrapBoxer(clazz);
        Type type = null;
        if (clazz == Short.TYPE) {
            type = new NumberType(5, 5L, 0);
        } else if (clazz == Integer.TYPE) {
            type = new NumberType(4, 10L, 0);
        } else if (clazz == Long.TYPE) {
            type = new NumberType(2, 128L, 0);
        } else if (clazz == Float.TYPE) {
            type = new NumberType(6, 0L, 0);
        } else if (clazz == Double.TYPE) {
            type = new NumberType(8, 0L, 0);
        } else if (clazz == Byte.TYPE) {
            type = new NumberType(-6, 3L, 0);
        } else {
            if (clazz == Boolean.TYPE) {
                return SQL_BOOLEAN;
            }
            if (clazz == Character.TYPE) {
                return SQL_CHAR;
            }
            if (clazz == String.class) {
                return width != -1 ? new CharacterType(1112, width) : new CharacterType(1112, Integer.MAX_VALUE);
            }
            if (clazz == Date.class) {
                return SQL_DATE;
            }
            if (clazz == Timestamp.class) {
                return SQL_TIMESTAMP;
            }
            if (clazz == Time.class) {
                return SQL_TIME;
            }
            if (clazz == BigInteger.class) {
                type = SQL_BIGINT;
            } else if (clazz == BigDecimal.class) {
                return new NumberType(3, 128L, 32);
            }
        }
        if (type != null) {
            if (width != -1) {
                if (type instanceof NumberType) {
                    type.typeWidth = width;
                }
                type.precision = width;
            }
            return type;
        }
        SemanticType semanticType = DataspaceStore.getContext().getSemanticTypeCache().lookupSemanticClass(clazz);
        if (semanticType != null && (type = session.dataspaceStore.schemaManager.getDomainOrDistinctType(semanticType.getTypeName(), session.getCurrentDataspaceName().name, false)) == null) {
            type = session.dataspaceStore.schemaManager.getDomainOrDistinctType(semanticType.getTypeName(), "SYS", false);
        }
        return type;
    }

    public static String resolveTypeName(SessionInterface session, Object o) {
        if (o == null) {
            return null;
        }
        int width = -1;
        String valueTypeName = null;
        if (o.getClass().isArray()) {
            width = Array.getLength(o);
        }
        Type valueType = null;
        if (session instanceof Session) {
            valueType = Type.resolveType((Session)session, o.getClass(), width);
        }
        if (valueType != null) {
            valueTypeName = valueType.getTypeDefinition();
        }
        if (valueTypeName == null || valueTypeName.equalsIgnoreCase("other")) {
            valueTypeName = TypeFactory.resolveTypeName(o.getClass(), new TriggerFunctionParserContextImpl(DataspaceManager.getContext()));
        }
        return valueTypeName;
    }

    static {
        systemTypes = new HashMap<String, OtherType>();
        typeNames = new IntValueHashMap(37);
        typeNames.put("CHARACTER", 1);
        typeNames.put("VARCHAR", 12);
        typeNames.put("VARCHAR_IGNORECASE", 100);
        typeNames.put("NVARCHAR", 12);
        typeNames.put("SQLDATE", 91);
        typeNames.put("SQLTIME", 92);
        typeNames.put("SQLTIMESTAMP", 93);
        typeNames.put("INTERVAL", 10);
        typeNames.put("TINYINT", -6);
        typeNames.put("SMALLINT", 5);
        typeNames.put("INTEGER", 4);
        typeNames.put("LONG", 1117);
        typeNames.put("REAL", 7);
        typeNames.put("FLOAT", 6);
        typeNames.put("DOUBLE", 8);
        typeNames.put("DECIMAL", 3);
        typeNames.put("NUMERIC", 2);
        typeNames.put("BIGINT", 25);
        typeNames.put("BOOLEAN", 16);
        typeNames.put("BINARY", 60);
        typeNames.put("VARBINARY", 61);
        typeNames.put("CLOB", 40);
        typeNames.put("BLOB", 30);
        typeNames.put("BIT", 14);
        typeNames.put("OTHER", 1111);
        typeNames.put("EVENT", 1113);
        typeNames.put("STRING", 1112);
        typeNames.put("CATEGORY", 1121);
        typeNames.put("FLOB", 1119);
        typeNames.put("FACETS", 1122);
        typeNames.put("ASPECTS", 1123);
        typeNames.put("DATASPACE", 1114);
        typeNames.put("DATASPACE_COLLECTION", 1115);
        typeNames.put("SERVICE", 1116);
        typeNames.put("RUNTIME", 1118);
        typeNames.put("SERVER", 1120);
        typeNames.put("DROPBOX", 1124);
        Type.registerSystemType("map", Map.class);
        Type.registerSystemType("mapentry", Map.Entry.class);
        Type.registerSystemType("list", List.class);
        Type.registerSystemType("set", Set.class);
        Type.registerSystemType("queue", Queue.class);
        Type.registerSystemType("date", java.util.Date.class);
        Type.registerSystemType("row", Row.class);
        Type.registerSystemType("rowset", RowSet.class);
        Type.registerSystemType("rowarray", RowArray.class);
        typeAliases = new IntValueHashMap(64);
        typeAliases.put("CHAR", 1);
        typeAliases.put("INT", 4);
        typeAliases.put("DEC", 3);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("DATETIME", 93);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OBJECT", 1111);
        typeAliases.put("BYTE", -6);
        typeAliases.put("SHORT", 5);
        typeAliases.put("BIGINTEGER", 25);
        typeAliases.put("SqlDate", 91);
        typeAliases.put("SqlTime", 92);
        typeAliases.put("SqlTimestamp", 93);
        typeAliases.put("SqlBinary", 60);
        typeAliases.put("SqlVarbinary", 61);
        typeAliases.put("SqlLongVarbinary", -4);
        typeAliases.put("SqlBlob", 30);
        typeAliases.put("SqlClob", 40);
        jdbcConvertTypes = new IntKeyHashMap(37);
        jdbcConvertTypes.put(806, SQL_CHAR_DEFAULT);
        jdbcConvertTypes.put(829, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(816, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(820, SQL_VARCHAR_DEFAULT);
        jdbcConvertTypes.put(808, SQL_DATE);
        jdbcConvertTypes.put(825, SQL_TIME);
        jdbcConvertTypes.put(826, SQL_TIMESTAMP);
        jdbcConvertTypes.put(827, TINYINT);
        jdbcConvertTypes.put(824, SQL_SMALLINT);
        jdbcConvertTypes.put(813, SQL_INTEGER);
        jdbcConvertTypes.put(801, SQL_BIGINT);
        jdbcConvertTypes.put(821, SQL_DOUBLE);
        jdbcConvertTypes.put(812, SQL_DOUBLE);
        jdbcConvertTypes.put(811, SQL_DOUBLE);
        jdbcConvertTypes.put(819, SQL_NUMERIC);
        jdbcConvertTypes.put(809, SQL_DECIMAL);
        jdbcConvertTypes.put(805, SQL_BOOLEAN);
        jdbcConvertTypes.put(802, SQL_BINARY_DEFAULT);
        jdbcConvertTypes.put(828, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(814, SQL_VARBINARY_DEFAULT);
        jdbcConvertTypes.put(807, SQL_CLOB);
        jdbcConvertTypes.put(804, SQL_BLOB);
        jdbcConvertTypes.put(803, SQL_BIT);
    }

    public static class TypedComparator
    implements Comparator {
        Session session;
        Type type;
        SortAndSlice sort;

        TypedComparator(Session session) {
            this.session = session;
            this.sort = this.sort;
        }

        public int compare(Object a, Object b) {
            return this.type.compare(this.session, a, b, this.sort);
        }

        public void setType(Type type, SortAndSlice sort) {
            this.type = type;
            this.sort = sort;
        }
    }
}

