/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

public class TimestampData {
    final long milliseconds;
    final int nanos;
    final int zone;

    public TimestampData(long milliseconds) {
        this.milliseconds = milliseconds;
        this.nanos = 0;
        this.zone = 0;
    }

    public TimestampData(long milliseconds, int nanos) {
        this.milliseconds = milliseconds;
        this.nanos = nanos;
        this.zone = 0;
    }

    public TimestampData(long milliseconds, int nanos, int zoneSeconds) {
        this.milliseconds = milliseconds;
        this.nanos = nanos;
        this.zone = zoneSeconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public boolean equals(Object other) {
        if (other instanceof TimestampData) {
            return this.milliseconds == ((TimestampData)other).milliseconds && this.nanos == ((TimestampData)other).nanos && this.zone == ((TimestampData)other).zone;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.milliseconds ^ this.nanos;
    }

    public int compareTo(TimestampData b) {
        long diff = this.milliseconds - b.milliseconds;
        if (diff == 0L && (diff = (long)(this.nanos - b.nanos)) == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }
}

