/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.types.AccessorTypeWrapper;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.utils.EIMObject;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import java.util.Map;

public class ServiceTypeWrapper
implements AccessorTypeWrapper {
    public transient ServiceAccessor accessor;

    public ServiceTypeWrapper(ServiceAccessor accessor) {
        this.accessor = accessor;
    }

    public Object invokeRequest(String handlerName, Object param, Map<String, Object> properties) {
        return this.invokeRequest(handlerName, param, properties, 0L);
    }

    public Object invokeRequest(String handlerName, Object param, Map<String, Object> properties, long timeout) {
        if (this.accessor != null) {
            try {
                return this.accessor.invokeServiceRequest(handlerName, param, properties, timeout);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return null;
    }

    public Object invokeRequest(String handlerName, Object param) {
        return this.invokeRequest(handlerName, param, 0L);
    }

    public Object invokeRequest(String handlerName, Object param, long timeout) {
        if (this.accessor != null) {
            try {
                return this.accessor.invokeServiceRequest(handlerName, param, timeout);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return null;
    }

    public Object invokeRequest(String eventHandler, EIMObject eimData, Object data) throws FabricComponentAccessorException, ServiceFrameworkException {
        if (this.accessor != null) {
            try {
                return this.accessor.invokeServiceRequest(eventHandler, eimData, data);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return null;
    }

    public Object invokeRequest(String eventHandler, EIMObject eimData, Object data, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        if (this.accessor != null) {
            try {
                return this.accessor.invokeServiceRequest(eventHandler, eimData, data, timeout);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        return null;
    }

    public Object query(String sql) throws Throwable {
        return this.query(sql, this.accessor.getRequestTimeout());
    }

    public Object query(String sql, long timeout) throws Throwable {
        SLResponse response = null;
        if (this.accessor != null) {
            try {
                response = this.accessor.invokeLanguageRequest(sql, timeout);
            }
            catch (Exception error) {
                throw new DataspaceException(error.getMessage());
            }
        }
        if (response != null && !response.isOK()) {
            if (response.getException() != null && response.getException().getMessage().equals("Execution interrupted.")) {
                this.accessor.close();
                throw response.getException();
            }
            String error = null;
            error = response.getException() != null ? response.getException().getMessage() : response.getText();
            throw new DataspaceException("Failed to execute query '" + sql + "' on " + this.accessor.getActualNodeName() + "://" + this.accessor.getComponentType() + "." + this.accessor.getComponentName() + " service. " + error);
        }
        if (response != null && response.isOK()) {
            if (response.getRowSet() != null) {
                return response.getRowSet();
            }
            if (response.getText() != null) {
                return response.getText();
            }
            if (response.getObject() != null) {
                return response.getObject();
            }
        }
        return null;
    }

    public void setRequestTimeout(long timeout) {
        if (this.accessor == null) {
            throw new DataspaceException("Service accessor is closed.");
        }
        this.accessor.setRequestTimeout(timeout);
    }

    public long getRequestTimeout() {
        if (this.accessor != null) {
            return this.accessor.getRequestTimeout();
        }
        throw new DataspaceException("Service accessor is closed.");
    }

    @Override
    public void close() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }
}

