/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.types;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.schema.server.AbstractVirtualClientServerObject;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.session.Session;
import java.util.Arrays;

public class ServerTypeWrapper {
    private ServerObject serverObject;
    private Session session;

    public ServerTypeWrapper(ServerObject serverObject, Session session) {
        this.serverObject = serverObject;
        this.session = session;
    }

    public void start() {
        this.serverObject.startServer(this.session);
    }

    public void stop() {
        this.serverObject.stopServer(this.session);
    }

    public boolean isRunning() {
        return this.serverObject.isRunning();
    }

    public Object query(String query) {
        return this.query(query, new Object[0]);
    }

    public Object query(String query, Object ... arguments) {
        return this.query(query, null, arguments);
    }

    private Object query(String query, Class<?> targetClass, Object ... arguments) {
        if (this.serverObject instanceof VirtualServerObject) {
            return ((VirtualServerObject)this.serverObject).executeQuery(query, Arrays.asList(arguments));
        }
        if (this.serverObject instanceof AbstractVirtualClientServerObject) {
            if (arguments != null && arguments.length > 0) {
                throw new DataspaceException("Query parameters not supported for NoSql queries.");
            }
            return ((AbstractVirtualClientServerObject)this.serverObject).executeQuery(this.session, query, targetClass);
        }
        throw new DataspaceException("Query method is not supported for this server.");
    }
}

